/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

import java.util.ArrayList;
import java.util.List;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;
import org.jcodec.containers.mkv.elements.Block;
import org.jcodec.containers.mkv.elements.BlockElement;
import org.jcodec.containers.mkv.elements.BlockGroup;

public class Cluster
extends MasterElement
implements Comparable<Cluster> {
    public List<Block> simpleBlockContentOffsets;
    public List<BlockGroup> blockGroups;
    public long timecode;
    public long prevsize;

    public Cluster(byte[] b2) {
        super(b2);
    }

    public Cluster(List<Block> simpleBlockContentOffsets, List<BlockGroup> blockGroups, long timecode, long prevsize) {
        super(Type.Cluster.id);
        this.simpleBlockContentOffsets = simpleBlockContentOffsets;
        this.blockGroups = blockGroups;
        this.timecode = timecode;
        this.prevsize = prevsize;
    }

    public static Cluster create(List<Block> simpleBlockContentOffsets, List<BlockGroup> blockGroups, long timecode, long prevsize) {
        return new Cluster(simpleBlockContentOffsets, blockGroups, timecode, prevsize);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Timecode: ").append(this.timecode).append("\n");
        sb.append("Prevsize: ").append(this.prevsize).append("\n");
        for (Block simple : this.simpleBlockContentOffsets) {
            sb.append("SimpleBlock: ").append(simple.toString());
        }
        for (BlockGroup bg : this.blockGroups) {
            sb.append("BlockGroup: ").append(bg.toString());
        }
        return sb.toString();
    }

    public List<BlockElement> getBlocksByTrackNumber(long nr) {
        ArrayList<BlockElement> blocks = new ArrayList<BlockElement>();
        for (Element child : this.children) {
            BlockElement block = null;
            if (child.type.equals((Object)Type.SimpleBlock)) {
                block = (BlockElement)child;
            } else {
                if (!child.type.equals((Object)Type.BlockGroup)) continue;
                block = (BlockElement)Type.findFirst(child, Type.BlockGroup, Type.Block);
            }
            if (block.trackNumber != nr) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public long getMinTimecode(int trackNr) {
        long clusterTimecode;
        UnsignedIntegerElement timecode = (UnsignedIntegerElement)Type.findFirst(this, Type.Cluster, Type.Timecode);
        long minTimecode = clusterTimecode = timecode.get();
        for (BlockElement be : this.getBlocksByTrackNumber(trackNr)) {
            if (clusterTimecode + (long)be.timecode >= minTimecode) continue;
            minTimecode = clusterTimecode + (long)be.timecode;
        }
        return minTimecode;
    }

    public long getMaxTimecode(int trackNr) {
        long clusterTimecode;
        UnsignedIntegerElement timecode = (UnsignedIntegerElement)Type.findFirst(this, Type.Cluster, Type.Timecode);
        long maxTimecode = clusterTimecode = timecode.get();
        for (BlockElement be : this.getBlocksByTrackNumber(trackNr)) {
            if (clusterTimecode + (long)be.timecode <= maxTimecode) continue;
            maxTimecode = clusterTimecode + (long)be.timecode;
        }
        return maxTimecode;
    }

    @Override
    public int compareTo(Cluster o2) {
        return (int)(this.timecode - o2.timecode);
    }
}

