/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mkv.Reader;

public class Block {
    private long pos;
    private long size;
    private int headerSize;

    public Block(long pos, long size) {
        this.pos = pos;
        this.size = size;
    }

    public static Block create(long pos, long size) {
        return new Block(pos, size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Offset: ").append(this.pos).append("\n");
        sb.append("Size: ").append(this.size).append("\n");
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void seekParsePrint(FileChannel source, File parent) throws Exception {
        ByteBuffer data = ByteBuffer.allocate((int)this.size);
        source.position(this.pos);
        source.read(data);
        System.out.println("Offset: " + this.pos);
        System.out.println("Size: " + this.size);
        int trackNr = (int)Reader.getEbmlVInt(data);
        int index = data.position();
        int blockTimecode1 = data.get() & 0xFF;
        int blockTimecode2 = data.get() & 0xFF;
        int timecode = blockTimecode1 << 8 | blockTimecode2;
        byte flags = data.get();
        int keyFlag = flags & 0x80;
        boolean keyFrame = keyFlag > 0;
        int laceFlags = flags & 6;
        if (laceFlags != 0) {
            long[] sizes = null;
            int lacesCount = data.get();
            if (laceFlags == 2) {
                System.out.println("Lacing: Xiph");
                sizes = this.readXiphLaceSizes(data, (byte)lacesCount);
                int currentFramePos = this.headerSize;
                for (int i2 = 0; i2 < sizes.length; ++i2) {
                    int s = (int)sizes[i2];
                    System.out.println("Lace Size: " + s);
                    byte[] frameData = new byte[s];
                    if (frameData.length + currentFramePos > data.limit()) {
                        System.err.println("file offset [" + this.pos + "] laced frame [" + i2 + "] position+size (" + (frameData.length + currentFramePos) + ") exceeds block... skipping read");
                        return;
                    }
                    System.arraycopy(data, currentFramePos, frameData, 0, frameData.length);
                    NIOUtils.writeTo(ByteBuffer.wrap(frameData), new File(parent, "pos-" + this.pos + "-lace-" + i2 + ".frm"));
                    currentFramePos += s;
                }
            } else if (laceFlags == 6) {
                System.out.println("Lacing: EBML");
                sizes = this.readEBMLLaceSizes(data, (short)lacesCount);
                System.out.println("Header Size: " + this.headerSize);
                int currentFramePos = this.headerSize;
                for (int i3 = 0; i3 < sizes.length; ++i3) {
                    int s = (int)sizes[i3];
                    System.out.println("Lace Size: " + s);
                    byte[] frameData = new byte[s];
                    if (frameData.length + currentFramePos > data.limit()) {
                        System.err.println("file offset [" + this.pos + "] laced frame [" + i3 + "] position+size (" + (frameData.length + currentFramePos) + ") exceeds block... skipping read");
                        return;
                    }
                    System.arraycopy(data, currentFramePos, frameData, 0, frameData.length);
                    NIOUtils.writeTo(ByteBuffer.wrap(frameData), new File(parent, "pos-" + this.pos + "-lace-" + i3 + ".frm"));
                    currentFramePos += s;
                }
            } else {
                if (laceFlags != 4) throw new RuntimeException("Unsupported lacing type flag.");
                this.headerSize = index;
                int laceSize = (int)((this.size - (long)this.headerSize) / (long)lacesCount);
                System.out.println("Lace Size: " + laceSize);
                System.out.println("Lace Count: " + lacesCount);
                for (int i4 = 0; i4 < lacesCount; ++i4) {
                    byte[] frameData = new byte[laceSize];
                    if (frameData.length * (i4 + 1) + this.headerSize > data.limit()) {
                        System.err.println("file offset [" + this.pos + "] laced frame [" + i4 + "] position+size (" + (frameData.length * (i4 + 1) + this.headerSize) + ") exceeds block... skipping read");
                        return;
                    }
                    System.arraycopy(data, index, frameData, 0, frameData.length);
                    NIOUtils.writeTo(ByteBuffer.wrap(frameData), new File(parent, "pos-" + this.pos + "-lace-" + i4 + ".frm"));
                    index += laceSize;
                }
            }
        } else {
            System.out.println("Lacing: n/a");
        }
        System.out.println("Timecode: " + timecode);
        System.out.println("Track Nr: " + trackNr);
        System.out.println("KeyFrame: " + keyFrame);
        byte[] frameData = new byte[data.limit() - index];
        System.arraycopy(data, index, frameData, 0, frameData.length);
        NIOUtils.writeTo(ByteBuffer.wrap(frameData), new File(parent, "pos-" + this.pos + ".frm"));
    }

    private long[] readXiphLaceSizes(ByteBuffer data, byte count) {
        long[] sizes = new long[count + 1];
        sizes[count] = (int)this.size;
        for (int l2 = 0; l2 < count; ++l2) {
            int laceSize = 255;
            while (laceSize == 255) {
                laceSize = (short)(data.get() & 0xFF);
                int n2 = l2;
                sizes[n2] = sizes[n2] + (long)laceSize;
            }
            int n3 = count;
            sizes[n3] = sizes[n3] - sizes[l2];
        }
        this.headerSize = data.position();
        int n4 = count;
        sizes[n4] = sizes[n4] - (long)this.headerSize;
        return sizes;
    }

    public long[] readEBMLLaceSizes(ByteBuffer data, short count) {
        long[] sizes = new long[count + 1];
        sizes[count] = (int)this.size;
        sizes[0] = Reader.getEbmlVInt(data);
        int n2 = count;
        sizes[n2] = sizes[n2] - sizes[0];
        long laceSize = sizes[0];
        long laceSizeDiff = 0L;
        for (int l2 = 1; l2 < count; ++l2) {
            laceSizeDiff = Reader.getSignedEbmlVInt(data);
            sizes[l2] = laceSize += laceSizeDiff;
            int n3 = count;
            sizes[n3] = sizes[n3] - sizes[l2];
        }
        this.headerSize = data.position();
        int n4 = count;
        sizes[n4] = sizes[n4] - (long)this.headerSize;
        return sizes;
    }

    public byte[] readData(FileChannel ds) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate((int)this.size);
        ds.position(this.pos);
        ds.read(buff);
        return buff.array();
    }
}

