/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import org.jcodec.containers.mkv.ebml.BinaryElement;
import org.jcodec.containers.mkv.ebml.Element;

public class SignedIntegerElement
extends BinaryElement {
    public static final long[] signedComplement = new long[]{0L, 63L, 8191L, 1048575L, 0x7FFFFFFL, 0x3FFFFFFFFL, 0x1FFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL};

    public SignedIntegerElement(byte[] typeID) {
        super(typeID);
    }

    public void setValue(long value) {
        this.setData(SignedIntegerElement.convertToBytes(value));
    }

    public long getValue() {
        if (this.data.limit() - this.data.position() == 8) {
            return this.data.duplicate().getLong();
        }
        byte[] b2 = this.data.array();
        long l2 = 0L;
        for (int i2 = b2.length - 1; i2 >= 0; --i2) {
            l2 |= ((long)b2[i2] & 0xFFL) << 8 * (b2.length - 1 - i2);
        }
        return l2;
    }

    public static int getSerializedSize(long val) {
        if (val <= 64L && val >= -63L) {
            return 1;
        }
        if (val <= 8192L && val >= -8191L) {
            return 2;
        }
        if (val <= 0x100000L && val >= -1048575L) {
            return 3;
        }
        if (val <= 0x8000000L && val >= -134217727L) {
            return 4;
        }
        if (val <= 0x400000000L && val >= -17179869183L) {
            return 5;
        }
        if (val <= 0x20000000000L && val >= -2199023255551L) {
            return 6;
        }
        if (val <= 0x1000000000000L && val >= -281474976710655L) {
            return 7;
        }
        return 8;
    }

    public static long convertToUnsigned(long val) {
        return val + signedComplement[SignedIntegerElement.getSerializedSize(val)];
    }

    public static byte[] convertToBytes(long val) {
        int num = SignedIntegerElement.getSerializedSize(val);
        return Element.ebmlBytes(val += signedComplement[num], num);
    }
}

