/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import java.nio.ByteBuffer;
import java.util.Date;
import org.jcodec.containers.mkv.ebml.SignedIntegerElement;

public class DateElement
extends SignedIntegerElement {
    public static long UnixEpochDelay = 978307200L;

    public DateElement(byte[] type) {
        super(type);
    }

    public void setDate(Date value) {
        this.setMiliseconds(value.getTime());
    }

    public Date getDate() {
        long val = this.getValue();
        val = val / 1000000000L + UnixEpochDelay;
        return new Date(val);
    }

    public void setMiliseconds(long milliseconds) {
        this.setValue((milliseconds - UnixEpochDelay) * 1000000000L);
    }

    @Override
    public void setValue(long value) {
        this.data = ByteBuffer.allocate(8);
        this.data.putLong(value);
        this.data.flip();
    }
}

