/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.BinaryElement;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;

public class SeekHeadIndexer {
    List<SeekMock> a = new ArrayList<SeekMock>();
    long currentDataOffset = 0L;

    public void add(Element e2) {
        SeekMock z = SeekMock.make(e2);
        z.dataOffset = this.currentDataOffset;
        z.seekPointerSize = UnsignedIntegerElement.getMinByteSizeUnsigned(z.dataOffset);
        this.currentDataOffset += (long)z.size;
        this.a.add(z);
    }

    public MasterElement indexSeekHead() {
        int seekHeadSize = this.computeSeekHeadSize();
        MasterElement seekHead = (MasterElement)Type.createElementByType(Type.SeekHead);
        for (SeekMock z : this.a) {
            MasterElement seek = (MasterElement)Type.createElementByType(Type.Seek);
            BinaryElement seekId = (BinaryElement)Type.createElementByType(Type.SeekID);
            seekId.setData(z.id);
            seek.addChildElement(seekId);
            UnsignedIntegerElement seekPosition = (UnsignedIntegerElement)Type.createElementByType(Type.SeekPosition);
            seekPosition.set(z.dataOffset + (long)seekHeadSize);
            if (seekPosition.getData().length != z.seekPointerSize) {
                System.err.println("estimated size of seekPosition differs from the one actually used. ElementId: " + Reader.printAsHex(z.id) + " " + seekPosition.getData().length + " vs " + z.seekPointerSize);
            }
            seek.addChildElement(seekPosition);
            seekHead.addChildElement(seek);
        }
        ByteBuffer mux = seekHead.mux();
        if (mux.limit() != seekHeadSize) {
            System.err.println("estimated size of seekHead differs from the one actually used. " + mux.limit() + " vs " + seekHeadSize);
        }
        return seekHead;
    }

    public int computeSeekHeadSize() {
        int seekHeadSize = this.estimateSize();
        boolean reindex = false;
        block0: do {
            reindex = false;
            for (SeekMock z : this.a) {
                int minSize = UnsignedIntegerElement.getMinByteSizeUnsigned(z.dataOffset + (long)seekHeadSize);
                if (minSize > z.seekPointerSize) {
                    System.out.println("Size " + seekHeadSize + " seems too small for element " + Reader.printAsHex(z.id) + " increasing size by one.");
                    ++z.seekPointerSize;
                    ++seekHeadSize;
                    reindex = true;
                    continue block0;
                }
                if (minSize >= z.seekPointerSize) continue;
                throw new RuntimeException("Downsizing the index is not well thought through.");
            }
        } while (reindex);
        return seekHeadSize;
    }

    int estimateSize() {
        int s = Type.SeekHead.id.length + 1;
        s += SeekHeadIndexer.estimeteSeekSize(this.a.get((int)0).id.length, 1);
        for (int i2 = 1; i2 < this.a.size(); ++i2) {
            s += SeekHeadIndexer.estimeteSeekSize(this.a.get((int)i2).id.length, this.a.get((int)i2).seekPointerSize);
        }
        return s;
    }

    public static int estimeteSeekSize(int idLength, int offsetSizeInBytes) {
        int seekIdSize = Type.SeekID.id.length + Element.getEbmlSize(idLength) + idLength;
        int seekPositionSize = Type.SeekPosition.id.length + Element.getEbmlSize(offsetSizeInBytes) + offsetSizeInBytes;
        int seekSize = Type.Seek.id.length + Element.getEbmlSize(seekIdSize + seekPositionSize) + seekIdSize + seekPositionSize;
        return seekSize;
    }

    public static class SeekMock {
        public long dataOffset;
        byte[] id;
        int size;
        int seekPointerSize;

        public static SeekMock make(Element e2) {
            SeekMock z = new SeekMock();
            z.id = e2.id;
            z.size = (int)e2.getSize();
            return z;
        }
    }
}

