/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.Element;

public class Reader {
    protected FileChannel ds;
    public static final long[] signedComplement = new long[]{0L, 63L, 8191L, 1048575L, 0x7FFFFFFL, 0x3FFFFFFFFL, 0x1FFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL};

    public Reader(FileChannel source) {
        this.ds = source;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public long getAvailable() throws IOException {
        return 0L;
    }

    public static String bytesToHex(byte[] bts) {
        StringBuilder sb = new StringBuilder();
        if (bts == null) {
            return "";
        }
        for (byte b2 : bts) {
            sb.append(" 0x").append(Integer.toHexString(b2 & 0xFF).toUpperCase());
        }
        return sb.toString();
    }

    public static String printAsHex(byte[] a2) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : a2) {
            sb.append(String.format("0x%02x ", b2 & 0xFF));
        }
        return sb.toString();
    }

    public Element readNextElement() throws IOException {
        long offset = this.ds.position();
        byte[] typeId = Reader.getRawEbmlBytes(this.ds);
        if (typeId == null) {
            return null;
        }
        byte[] ebmlCodedElementSize = Reader.getEbmlBytes(this.ds);
        long size = Reader.bytesToLong(ebmlCodedElementSize);
        if (size == 0L) {
            // empty if block
        }
        Object elem = Type.createElementById(typeId);
        ((Element)elem).offset = offset;
        ((Element)elem).size = size;
        return elem;
    }

    public static long getEbmlVInt(FileChannel source) throws IOException {
        ByteBuffer bufferForFirstByte = ByteBuffer.allocate(1);
        source.read(bufferForFirstByte);
        bufferForFirstByte.flip();
        byte firstByte = bufferForFirstByte.get();
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        if (numBytes == 1) {
            return firstByte & 255 >>> numBytes;
        }
        ByteBuffer bb = ByteBuffer.allocate(numBytes);
        bb.put((byte)(firstByte & 255 >>> numBytes));
        source.read(bb);
        return Reader.bytesToLong(bb.array());
    }

    public static long getSignedEbmlVInt(FileChannel is) throws IOException {
        byte[] vInt = Reader.getEbmlBytes(is);
        long uInt = Reader.bytesToLong(vInt);
        return uInt - signedComplement[vInt.length];
    }

    public static long bytesToLong(ByteBuffer data) {
        if (data == null) {
            return 0L;
        }
        long value = 0L;
        while (data.position() < data.limit()) {
            value = value << 8 | (long)(data.get() & 0xFF);
        }
        return value;
    }

    public static long bytesToLong(byte[] data) {
        if (data == null) {
            return 0L;
        }
        long value = 0L;
        for (int i2 = 0; i2 < data.length; ++i2) {
            value = value << 8 | (long)(data[i2] & 0xFF);
        }
        return value;
    }

    public static int getEbmlSizeByFirstByte(byte b2) {
        int numBytes = 0;
        long mask = 128L;
        for (int i2 = 0; i2 < 8; ++i2) {
            if (((long)b2 & mask) == mask) {
                numBytes = i2 + 1;
                i2 = 8;
            }
            mask >>>= 1;
        }
        return numBytes;
    }

    public static long getEbmlVInt(ByteBuffer bb) {
        byte firstByte = bb.get();
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        if (numBytes == 1) {
            return firstByte & 255 >>> numBytes;
        }
        byte[] data = new byte[numBytes];
        data[0] = (byte)(firstByte & 255 >>> numBytes);
        bb.get(data, 1, data.length - 1);
        long longValue = Reader.bytesToLong(data);
        return longValue;
    }

    public static long getEbmlVInt(ByteBuffer source, int offset) {
        byte firstByte = source.get(offset);
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        if (numBytes == 1) {
            return firstByte & 255 >>> numBytes;
        }
        byte[] data = new byte[numBytes];
        data[0] = (byte)(firstByte & 255 >>> numBytes);
        System.arraycopy(source.array(), offset + 1, data, 1, numBytes - 1);
        long longValue = Reader.bytesToLong(data);
        return longValue;
    }

    public static String asHex(int i2) {
        return "0x" + Reader.printAsHex(new byte[]{(byte)i2});
    }

    public static long getSignedEbmlVInt(ByteBuffer source) {
        byte[] bytes = Reader.getVIntEbmlBytes(source);
        if (bytes == null) {
            throw new RuntimeException("Can't convert byte 0x" + Integer.toHexString(source.get(source.position() - 1) & 0xFF).toUpperCase() + " to first ebml byte.");
        }
        return Reader.bytesToLong(bytes) - signedComplement[bytes.length];
    }

    public static byte[] getVIntEbmlBytes(ByteBuffer source) {
        byte firstByte = source.get();
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return null;
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        for (int remaining = numBytes - 1; remaining > 0; --remaining) {
            data.put(source.get());
        }
        return data.array();
    }

    public static byte[] getEbmlBytes(FileChannel source) throws IOException {
        ByteBuffer bufferForFirstByte = ByteBuffer.allocate(1);
        source.read(bufferForFirstByte);
        bufferForFirstByte.flip();
        byte firstByte = bufferForFirstByte.get();
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return null;
        }
        if (numBytes == 1) {
            return new byte[]{(byte)(firstByte & 255 >>> numBytes)};
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        source.read(data);
        return data.array();
    }

    public static byte[] getRawEbmlBytes(FileChannel source) throws IOException {
        if (source.position() == source.size()) {
            return null;
        }
        ByteBuffer bufferForFirstByte = ByteBuffer.allocate(1);
        source.read(bufferForFirstByte);
        bufferForFirstByte.flip();
        byte firstByte = bufferForFirstByte.get();
        int numBytes = Reader.getEbmlSizeByFirstByte(firstByte);
        if (numBytes == 0) {
            return null;
        }
        if (numBytes == 1) {
            return bufferForFirstByte.array();
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put(firstByte);
        source.read(data);
        return data.array();
    }

    public Element readNextFirstLevelElement() throws IOException {
        if (this.ds.position() == this.ds.size()) {
            return null;
        }
        long offset = this.ds.position();
        byte[] typeId = Reader.getRawEbmlBytes(this.ds);
        while (typeId == null || !Type.isFirstLevelHeader(typeId)) {
            this.ds.position(++offset);
            typeId = Reader.getRawEbmlBytes(this.ds);
        }
        byte[] data = Reader.getEbmlBytes(this.ds);
        long elementSize = Reader.bytesToLong(data);
        Object elem = Type.createElementById(typeId);
        ((Element)elem).size = elementSize;
        ((Element)elem).offset = offset;
        return elem;
    }
}

