/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jcodec.containers.mkv.CuesIndexer;
import org.jcodec.containers.mkv.SeekHeadIndexer;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.DateElement;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.FloatElement;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.StringElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;
import org.jcodec.containers.mkv.elements.BlockElement;
import org.jcodec.containers.mkv.elements.Cluster;
import org.jcodec.containers.mkv.elements.Info;

public class MKVRemuxer {
    public final List<MasterElement> tree;
    private FileChannel source;

    public MKVRemuxer(List<MasterElement> tree, FileChannel source) {
        this.tree = tree;
        this.source = source;
    }

    public void mux(FileChannel os) throws IOException {
        MasterElement ebmlHeaderElem = (MasterElement)Type.createElementByType(Type.EBML);
        StringElement docTypeElem = (StringElement)Type.createElementByType(Type.DocType);
        docTypeElem.set("matroska");
        UnsignedIntegerElement docTypeVersionElem = (UnsignedIntegerElement)Type.createElementByType(Type.DocTypeVersion);
        docTypeVersionElem.set(2L);
        UnsignedIntegerElement docTypeReadVersionElem = (UnsignedIntegerElement)Type.createElementByType(Type.DocTypeReadVersion);
        docTypeReadVersionElem.set(2L);
        ebmlHeaderElem.addChildElement(docTypeElem);
        ebmlHeaderElem.addChildElement(docTypeVersionElem);
        ebmlHeaderElem.addChildElement(docTypeReadVersionElem);
        ebmlHeaderElem.mux(os);
        MasterElement segmentElem = (MasterElement)Type.createElementByType(Type.Segment);
        SeekHeadIndexer shi = new SeekHeadIndexer();
        MasterElement info = this.muxInfo();
        MasterElement tracks = this.muxTracks();
        MasterElement cues = (MasterElement)Type.createElementByType(Type.Cues);
        shi.add(info);
        shi.add(tracks);
        shi.add(cues);
        MasterElement seekHead = shi.indexSeekHead();
        System.out.println("seekHead size: " + seekHead.getSize());
        System.out.println("info size: " + info.getSize());
        System.out.println("tracks size: " + tracks.getSize());
        segmentElem.addChildElement(seekHead);
        segmentElem.addChildElement(info);
        segmentElem.addChildElement(tracks);
        long off = seekHead.getSize() + info.getSize() + tracks.getSize();
        CuesIndexer ci = new CuesIndexer(off, 1L);
        for (Cluster aCluster : Type.findAll(this.tree, Cluster.class, Type.Segment, Type.Cluster)) {
            ci.add(CuesIndexer.CuePointMock.make(aCluster));
        }
        MasterElement indexedCues = ci.createCues();
        for (Element aCuePoint : indexedCues.children) {
            cues.addChildElement(aCuePoint);
        }
        System.out.println("cues size: " + cues.getSize());
        segmentElem.addChildElement(cues);
        this.muxClusters(segmentElem);
        segmentElem.mux(os);
    }

    private MasterElement muxInfo() {
        Info origInfo = (Info)Type.findFirst(this.tree, Type.Segment, Type.Info);
        if (origInfo == null) {
            throw new RuntimeException("No Info entry found in file");
        }
        MasterElement info = (MasterElement)Type.createElementByType(Type.Info);
        for (Element e2 : origInfo.children) {
            if (e2.type.equals((Object)Type.TimecodeScale)) {
                UnsignedIntegerElement timecodescaleElem = (UnsignedIntegerElement)Type.createElementByType(Type.TimecodeScale);
                timecodescaleElem.set(origInfo.getTimecodeScale());
                info.addChildElement(timecodescaleElem);
                continue;
            }
            if (!e2.type.equals((Object)Type.Duration)) continue;
            FloatElement durationElem = (FloatElement)Type.createElementByType(Type.Duration);
            durationElem.set(origInfo.getDuration());
            info.addChildElement(durationElem);
        }
        DateElement dateElem = (DateElement)Type.createElementByType(Type.DateUTC);
        dateElem.setDate(new Date());
        info.addChildElement(dateElem);
        StringElement writingAppElem = (StringElement)Type.createElementByType(Type.WritingApp);
        writingAppElem.set("Matroska Muxer v0.1a");
        info.addChildElement(writingAppElem);
        StringElement muxingAppElem = (StringElement)Type.createElementByType(Type.MuxingApp);
        muxingAppElem.set("JCodec v0.1.0");
        info.addChildElement(muxingAppElem);
        return info;
    }

    private void muxClusters(MasterElement segmentElem) throws IOException {
        for (MasterElement aCluster : Type.findAll(this.tree, MasterElement.class, Type.Segment, Type.Cluster)) {
            MasterElement clusterCopy = new MasterElement(Type.Cluster.id);
            clusterCopy.addChildElement(Type.findFirst(aCluster, Type.Cluster, Type.Timecode));
            clusterCopy.addChildElement(Type.findFirst(aCluster, Type.Cluster, Type.PrevSize));
            ArrayList<Element> blocks = new ArrayList<Element>();
            for (Element child : aCluster.children) {
                if (child.type.equals((Object)Type.SimpleBlock)) {
                    BlockElement aBlock = (BlockElement)child;
                    BlockElement be = BlockElement.copy(aBlock);
                    be.readFrames(this.source);
                    blocks.add(be);
                    continue;
                }
                if (!child.type.equals((Object)Type.BlockGroup)) continue;
                MasterElement aBlockGroup = (MasterElement)child;
                MasterElement bg = new MasterElement(Type.BlockGroup.id);
                bg.type = Type.BlockGroup;
                BlockElement aBlock = (BlockElement)Type.findFirst(aBlockGroup, Type.BlockGroup, Type.Block);
                BlockElement be = BlockElement.copy(aBlock);
                be.readFrames(this.source);
                bg.addChildElement(be);
                bg.addChildElement(Type.findFirst(aBlockGroup, Type.BlockGroup, Type.BlockDuration));
                bg.addChildElement(Type.findFirst(aBlockGroup, Type.BlockGroup, Type.ReferenceBlock));
                blocks.add(bg);
            }
            for (Element e2 : blocks) {
                clusterCopy.addChildElement(e2);
            }
            segmentElem.addChildElement(clusterCopy);
        }
    }

    private MasterElement muxTracks() throws IOException {
        MasterElement tracksElem = (MasterElement)Type.createElementByType(Type.Tracks);
        for (MasterElement track : Type.findAll(this.tree, MasterElement.class, Type.Segment, Type.Tracks, Type.TrackEntry)) {
            MasterElement trackEntryElem = (MasterElement)Type.createElementByType(Type.TrackEntry);
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.TrackNumber));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.TrackUID));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.TrackType));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Name));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Language));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.CodecID));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.CodecPrivate));
            trackEntryElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.DefaultDuration));
            Element video = Type.findFirst(track, Type.TrackEntry, Type.Video);
            Element audio = Type.findFirst(track, Type.TrackEntry, Type.Audio);
            if (video != null) {
                MasterElement trackVideoElem = (MasterElement)Type.createElementByType(Type.Video);
                trackVideoElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Video, Type.PixelWidth));
                trackVideoElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Video, Type.PixelHeight));
                trackVideoElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Video, Type.DisplayWidth));
                trackVideoElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Video, Type.DisplayHeight));
                trackEntryElem.addChildElement(trackVideoElem);
            } else if (audio != null) {
                MasterElement trackAudioElem = (MasterElement)Type.createElementByType(Type.Audio);
                trackAudioElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Audio, Type.Channels));
                trackAudioElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Audio, Type.BitDepth));
                trackAudioElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Audio, Type.SamplingFrequency));
                trackAudioElem.addChildElement(Type.findFirst(track, Type.TrackEntry, Type.Audio, Type.OutputSamplingFrequency));
                trackEntryElem.addChildElement(trackAudioElem);
            }
            tracksElem.addChildElement(trackEntryElem);
        }
        return tracksElem;
    }

    public static class BlockComparator
    implements Comparator<Element> {
        @Override
        public int compare(Element o1, Element o2) {
            int timecode2;
            int timecode1;
            if (o1 instanceof BlockElement) {
                timecode1 = ((BlockElement)o1).timecode;
            } else if (Type.BlockGroup.equals((Object)o1.type)) {
                timecode1 = ((BlockElement)Type.findFirst((Element)o1, (Type[])new Type[]{Type.BlockGroup, Type.Block})).timecode;
            } else {
                throw new IllegalArgumentException("Block comparator works on blocks or block groups only, first argument " + o1.getClass().getName() + " of type " + (Object)((Object)o1.type) + " provided instead.");
            }
            if (o2 instanceof BlockElement) {
                timecode2 = ((BlockElement)o2).timecode;
            } else if (Type.BlockGroup.equals((Object)o2.type)) {
                timecode2 = ((BlockElement)Type.findFirst((Element)o2, (Type[])new Type[]{Type.BlockGroup, Type.Block})).timecode;
            } else {
                throw new IllegalArgumentException("Block comparator works on blocks or block groups only, but " + o2.getClass().getName() + " of type " + (Object)((Object)o2.type) + " provided instead.");
            }
            return timecode1 - timecode2;
        }
    }
}

