/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.util.ArrayList;
import java.util.List;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;
import org.jcodec.containers.mkv.elements.Cluster;

public class CuesIndexer {
    List<CuePointMock> a = new ArrayList<CuePointMock>();
    private final long offsetBase;
    private long currentDataOffset = 0L;
    private long videoTrackNr;

    public CuesIndexer(long offset, long videoTrack) {
        this.offsetBase = offset;
        this.videoTrackNr = videoTrack;
        this.currentDataOffset += this.offsetBase;
    }

    public void add(CuePointMock z) {
        z.dataOffset = this.currentDataOffset;
        z.cueClusterPositionSize = UnsignedIntegerElement.getMinByteSizeUnsigned(z.dataOffset);
        this.currentDataOffset += z.size;
        this.a.add(z);
    }

    public MasterElement createCues() {
        int estimatedSize = this.computeCuesSize();
        MasterElement cues = (MasterElement)Type.createElementByType(Type.Cues);
        for (CuePointMock cpm : this.a) {
            MasterElement cuePoint = (MasterElement)Type.createElementByType(Type.CuePoint);
            UnsignedIntegerElement cueTime = (UnsignedIntegerElement)Type.createElementByType(Type.CueTime);
            cueTime.set(cpm.timecode);
            cuePoint.addChildElement(cueTime);
            MasterElement cueTrackPositions = (MasterElement)Type.createElementByType(Type.CueTrackPositions);
            UnsignedIntegerElement cueTrack = (UnsignedIntegerElement)Type.createElementByType(Type.CueTrack);
            cueTrack.set(this.videoTrackNr);
            cueTrackPositions.addChildElement(cueTrack);
            UnsignedIntegerElement cueClusterPosition = (UnsignedIntegerElement)Type.createElementByType(Type.CueClusterPosition);
            cueClusterPosition.set(cpm.dataOffset + (long)estimatedSize);
            if (cueClusterPosition.getData().length != cpm.cueClusterPositionSize) {
                System.err.println("estimated size of CueClusterPosition differs from the one actually used. ElementId: " + Reader.printAsHex(cpm.id) + " " + cueClusterPosition.getData().length + " vs " + cpm.cueClusterPositionSize);
            }
            cueTrackPositions.addChildElement(cueClusterPosition);
            cuePoint.addChildElement(cueTrackPositions);
            cues.addChildElement(cuePoint);
        }
        return cues;
    }

    public int computeCuesSize() {
        int cuesSize = this.estimateSize();
        boolean reindex = false;
        block0: do {
            reindex = false;
            for (CuePointMock z : this.a) {
                int minByteSize = UnsignedIntegerElement.getMinByteSizeUnsigned(z.dataOffset + (long)cuesSize);
                if (minByteSize > z.cueClusterPositionSize) {
                    System.err.println("Size " + cuesSize + " seems too small for element " + Reader.printAsHex(z.id) + " increasing size by one.");
                    ++z.cueClusterPositionSize;
                    ++cuesSize;
                    reindex = true;
                    continue block0;
                }
                if (minByteSize >= z.cueClusterPositionSize) continue;
                throw new RuntimeException("Downsizing the index is not well thought through");
            }
        } while (reindex);
        return cuesSize;
    }

    int estimateSize() {
        int s = 0;
        for (CuePointMock cpm : this.a) {
            s += CuesIndexer.estimateCuePointSize(UnsignedIntegerElement.getMinByteSizeUnsigned(cpm.timecode), UnsignedIntegerElement.getMinByteSizeUnsigned(this.videoTrackNr), UnsignedIntegerElement.getMinByteSizeUnsigned(cpm.dataOffset));
        }
        s += Type.Cues.id.length + Element.getEbmlSize(s);
        return s;
    }

    public static int estimateCuePointSize(int timecodeSizeInBytes, int trackNrSizeInBytes, int clusterPositionSizeInBytes) {
        int cueTimeSize = Type.CueTime.id.length + Element.getEbmlSize(timecodeSizeInBytes) + timecodeSizeInBytes;
        int cueTrackPositionSize = Type.CueTrack.id.length + Element.getEbmlSize(trackNrSizeInBytes) + trackNrSizeInBytes + Type.CueClusterPosition.id.length + Element.getEbmlSize(clusterPositionSizeInBytes) + clusterPositionSizeInBytes;
        cueTrackPositionSize += Type.CueTrackPositions.id.length + Element.getEbmlSize(cueTrackPositionSize);
        int cuePointSize = Type.CuePoint.id.length + Element.getEbmlSize(cueTimeSize + cueTrackPositionSize) + cueTimeSize + cueTrackPositionSize;
        return cuePointSize;
    }

    public static class CuePointMock {
        public int cueClusterPositionSize;
        public long dataOffset;
        private long timecode;
        private long size;
        private byte[] id;

        public static CuePointMock make(Cluster c2) {
            UnsignedIntegerElement tc = (UnsignedIntegerElement)Type.findFirst(c2, Type.Cluster, Type.Timecode);
            return CuePointMock.make(c2.id, tc.get(), c2.getSize());
        }

        public static CuePointMock make(byte[] id, long timecode, long size) {
            CuePointMock mock = new CuePointMock();
            mock.id = id;
            mock.timecode = timecode;
            mock.size = size;
            return mock;
        }
    }
}

