/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcodec.codecs.wav.StringReader;
import org.jcodec.codecs.wav.WavHeader;
import org.jcodec.common.Assert;

public class WavSplit {
    public static void main(String[] args) throws Exception {
        int i2;
        if (args.length < 1) {
            System.out.println("Syntax: <file>");
            return;
        }
        File s = new File(args[0]);
        WavHeader wavHeader = WavHeader.read(s);
        short bits = wavHeader.fmt.bitsPerSample;
        int channels = wavHeader.fmt.numChannels;
        long rate = wavHeader.fmt.sampleRate;
        System.out.println("WAV " + rate + " " + channels + " channels, " + bits + "bit");
        Assert.assertEquals(2, (int)wavHeader.fmt.numChannels);
        int dataOffset = wavHeader.dataOffset;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(s));
        StringReader.sureSkip(is, dataOffset);
        OutputStream[] out = new OutputStream[channels];
        for (i2 = 0; i2 < channels; ++i2) {
            out[i2] = new BufferedOutputStream(new FileOutputStream(new File(s.getParentFile(), String.format("c%02d.wav", i2))));
            WavSplit.createHeader(wavHeader, bits, channels, rate).write(out[i2]);
        }
        WavSplit.copy(bits, channels, is, out);
        for (i2 = 0; i2 < channels; ++i2) {
            out[i2].close();
        }
    }

    private static void copy(int bits, int channels, BufferedInputStream is, OutputStream[] out) throws IOException {
        int bps = bits >> 3;
        byte[] b2 = new byte[bps];
        block0: while (true) {
            int i2 = 0;
            while (true) {
                if (i2 >= channels) continue block0;
                int read = is.read(b2);
                if (read != bps) {
                    return;
                }
                out[i2].write(b2);
                ++i2;
            }
            break;
        }
    }

    private static WavHeader createHeader(WavHeader wavHeader, int bits, int channels, long rate) {
        WavHeader w = WavHeader.emptyWavHeader();
        w.fmt.audioFormat = 1;
        w.fmt.bitsPerSample = (short)bits;
        w.fmt.blockAlign = (short)(bits >> 3);
        w.fmt.byteRate = (short)(rate * (long)bits >> 3);
        w.fmt.numChannels = 1;
        w.fmt.sampleRate = (short)rate;
        w.dataSize = wavHeader.dataSize / (long)channels;
        return w;
    }
}

