/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jcodec.codecs.wav.WavHeader;
import org.jcodec.common.IOUtils;

public class WavMerge {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("wavmerge <output wav> <input wav> .... <input wav>");
            System.exit(-1);
        }
        File out = new File(args[0]);
        File[] ins = new File[args.length - 1];
        for (int i2 = 1; i2 < args.length; ++i2) {
            ins[i2 - 1] = new File(args[i2]);
        }
        WavMerge.merge(out, ins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(File result, File ... src) throws IOException {
        ArrayList<BufferedInputStream> inputs = new ArrayList<BufferedInputStream>();
        BufferedOutputStream out = null;
        ArrayList<WavHeader> headers = new ArrayList<WavHeader>();
        try {
            short sampleSize = -1;
            long l2 = -1L;
            for (File wav : src) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(wav));
                inputs.add(is);
                WavHeader hdr = WavHeader.read(is);
                if (sampleSize != -1 && sampleSize != hdr.fmt.bitsPerSample) {
                    throw new RuntimeException("Input files have different sample sizes");
                }
                if (l2 != -1L && l2 != hdr.dataSize) {
                    throw new RuntimeException("Input files have different duration");
                }
                sampleSize = hdr.fmt.bitsPerSample;
                l2 = hdr.dataSize;
                headers.add(hdr);
            }
            int ss = sampleSize >> 3;
            int nSamples = (int)(l2 / (long)ss);
            byte[] sample = new byte[ss];
            WavHeader newHeader = WavHeader.multiChannelWav(headers.toArray(new WavHeader[0]));
            out = new BufferedOutputStream(new FileOutputStream(result));
            newHeader.write(out);
            for (int i2 = 0; i2 < nSamples; ++i2) {
                for (InputStream inputStream : inputs) {
                    inputStream.read(sample);
                    out.write(sample);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            for (InputStream inputStream : inputs) {
                IOUtils.closeQuietly(inputStream);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        for (InputStream inputStream : inputs) {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

