/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;

public class ImageOP {
    public static void subImageWithFill(int[] src, int width, int height, int[] dst, int dstW, int dstH, int offX, int offY) {
        int i2;
        int srcHeight = Math.min(height - offY, dstH);
        int srcWidth = Math.min(width - offX, dstW);
        int srcStride = width;
        int dstOff = 0;
        int srcOff = offY * srcStride + offX;
        for (i2 = 0; i2 < srcHeight; ++i2) {
            int j2;
            for (j2 = 0; j2 < srcWidth; ++j2) {
                dst[dstOff + j2] = src[srcOff + j2];
            }
            int lastPix = dst[j2 - 1];
            while (j2 < dstW) {
                dst[dstOff + j2] = lastPix;
                ++j2;
            }
            srcOff += srcStride;
            dstOff += dstW;
        }
        int lastLine = dstOff - dstW;
        while (i2 < dstH) {
            System.arraycopy(dst, lastLine, dst, dstOff, dstW);
            dstOff += dstW;
            ++i2;
        }
    }

    public static void subImageWithFill(Picture in, Picture out, Rect rect) {
        int width = in.getWidth();
        int height = in.getHeight();
        ColorSpace color = in.getColor();
        int[][] data = in.getData();
        for (int i2 = 0; i2 < data.length; ++i2) {
            ImageOP.subImageWithFill(data[i2], width >> color.compWidth[i2], height >> color.compHeight[i2], out.getPlaneData(i2), rect.getWidth() >> color.compWidth[i2], rect.getHeight() >> color.compHeight[i2], rect.getX() >> color.compWidth[i2], rect.getY() >> color.compHeight[i2]);
        }
    }
}

