/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import org.jcodec.common.IntArrayList;
import org.jcodec.common.IntIntMap;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.io.VLC;

public class VLCBuilder {
    private IntIntMap forward = new IntIntMap();
    private IntIntMap inverse = new IntIntMap();
    private IntArrayList codes = new IntArrayList();
    private IntArrayList codesSizes = new IntArrayList();

    public VLCBuilder() {
    }

    public VLCBuilder(int[] codes, int[] lens, int[] vals) {
        for (int i2 = 0; i2 < codes.length; ++i2) {
            this.set(codes[i2], lens[i2], vals[i2]);
        }
    }

    public VLCBuilder set(int val, String code) {
        this.set(Integer.parseInt(code, 2), code.length(), val);
        return this;
    }

    public VLCBuilder set(int code, int len, int val) {
        this.codes.add(code << 32 - len);
        this.codesSizes.add(len);
        this.forward.put(val, this.codes.size() - 1);
        this.inverse.put(this.codes.size() - 1, val);
        return this;
    }

    public VLC getVLC() {
        return new VLC(this.codes.toArray(), this.codesSizes.toArray()){

            @Override
            public int readVLC(BitReader in) {
                return VLCBuilder.this.inverse.get(super.readVLC(in));
            }

            @Override
            public void writeVLC(BitWriter out, int code) {
                super.writeVLC(out, VLCBuilder.this.forward.get(code));
            }
        };
    }
}

