/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import java.io.PrintStream;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class VLC {
    private int[] codes;
    private int[] codeSizes;
    private int[] values;
    private int[] valueSizes;

    public VLC(int[] codes, int[] codeSizes) {
        this.codes = codes;
        this.codeSizes = codeSizes;
        this.invert();
    }

    public VLC(String ... codes) {
        IntArrayList _codes = new IntArrayList();
        IntArrayList _codeSizes = new IntArrayList();
        for (String string : codes) {
            _codes.add(Integer.parseInt(string, 2) << 32 - string.length());
            _codeSizes.add(string.length());
        }
        this.codes = _codes.toArray();
        this.codeSizes = _codeSizes.toArray();
        this.invert();
    }

    private void invert() {
        IntArrayList values = new IntArrayList();
        IntArrayList valueSizes = new IntArrayList();
        this.invert(0, 0, 0, values, valueSizes);
        this.values = values.toArray();
        this.valueSizes = valueSizes.toArray();
    }

    private int invert(int startOff, int level, int prefix, IntArrayList values, IntArrayList valueSizes) {
        int tableEnd = startOff + 256;
        values.fill(startOff, tableEnd, -1);
        valueSizes.fill(startOff, tableEnd, 0);
        int prefLen = level << 3;
        for (int i2 = 0; i2 < this.codeSizes.length; ++i2) {
            if (this.codeSizes[i2] <= prefLen || level > 0 && this.codes[i2] >>> 32 - prefLen != prefix) continue;
            int pref = this.codes[i2] >>> 32 - prefLen - 8;
            int code = pref & 0xFF;
            int len = this.codeSizes[i2] - prefLen;
            if (len <= 8) {
                for (int k2 = 0; k2 < 1 << 8 - len; ++k2) {
                    values.set(startOff + code + k2, i2);
                    valueSizes.set(startOff + code + k2, len);
                }
                continue;
            }
            if (values.get(startOff + code) != -1) continue;
            values.set(startOff + code, tableEnd);
            tableEnd = this.invert(tableEnd, level + 1, pref, values, valueSizes);
        }
        return tableEnd;
    }

    public int readVLC(BitReader in) {
        int code = 0;
        int len = 0;
        int overall = 0;
        int total = 0;
        int i2 = 0;
        while (len == 0) {
            int string = in.checkNBit(8);
            int ind = string + code;
            code = this.values[ind];
            len = this.valueSizes[ind];
            int bits = len != 0 ? len : 8;
            total += bits;
            overall = overall << bits | string >> 8 - bits;
            in.skip(bits);
            if (code == -1) {
                throw new RuntimeException("Invalid code prefix " + this.binary(overall, (i2 << 3) + bits));
            }
            ++i2;
        }
        return code;
    }

    private String binary(int string, int len) {
        char[] symb = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            symb[i2] = (string & 1 << len - i2 - 1) != 0 ? 49 : 48;
        }
        return new String(symb);
    }

    public void writeVLC(BitWriter out, int code) {
        out.writeNBit(this.codes[code] >>> 32 - this.codeSizes[code], this.codeSizes[code]);
    }

    public void printTable(PrintStream ps) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            ps.println(i2 + ": " + this.extracted(i2) + " (" + this.valueSizes[i2] + ") -> " + this.values[i2]);
        }
    }

    private String extracted(int num) {
        String str = Integer.toString(num & 0xFF, 2);
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < 8 - str.length(); ++i2) {
            builder.append('0');
        }
        builder.append(str);
        return builder.toString();
    }
}

