/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import java.io.IOException;
import java.io.InputStream;

public class DummyBitstreamReader {
    private InputStream is;
    private int curByte;
    private int nextByte;
    private int secondByte;
    int nBit;
    protected static int bitsRead;
    int cnt = 0;

    public DummyBitstreamReader(InputStream is) throws IOException {
        this.is = is;
        this.curByte = is.read();
        this.nextByte = is.read();
        this.secondByte = is.read();
    }

    public int read1Bit() throws IOException {
        return this.read1BitInt();
    }

    public int read1BitInt() throws IOException {
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int res = this.curByte >> 7 - this.nBit & 1;
        ++this.nBit;
        ++bitsRead;
        return res;
    }

    public int readNBit(int n2) throws IOException {
        if (n2 > 32) {
            throw new IllegalArgumentException("Can not read more then 32 bit");
        }
        int val = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            val <<= 1;
            val |= this.read1BitInt();
        }
        return val;
    }

    private final void advance1() throws IOException {
        this.curByte = this.nextByte;
        this.nextByte = this.secondByte;
        this.secondByte = this.is.read();
    }

    private final void advance() throws IOException {
        this.advance1();
        this.nBit = 0;
    }

    public int readByte() throws IOException {
        if (this.nBit > 0) {
            this.advance();
        }
        int res = this.curByte;
        this.advance();
        return res;
    }

    public boolean moreRBSPData() throws IOException {
        int tail;
        int mask;
        if (this.nBit == 8) {
            this.advance();
        }
        boolean hasTail = (this.curByte & (mask = ((tail = 1 << 8 - this.nBit - 1) << 1) - 1)) == tail;
        return this.curByte != -1 && (this.nextByte != -1 || !hasTail);
    }

    public long getBitPosition() {
        return bitsRead * 8 + this.nBit % 8;
    }

    public boolean moreData() throws IOException {
        if (this.nBit == 8) {
            this.advance();
        }
        if (this.curByte == -1) {
            return false;
        }
        if (this.nextByte == -1 || this.nextByte == 0 && this.secondByte == -1) {
            int mask = (1 << 8 - this.nBit) - 1;
            return (this.curByte & mask) != 0;
        }
        return true;
    }

    public long readRemainingByte() throws IOException {
        return this.readNBit(8 - this.nBit);
    }

    public int peakNextBits(int n2) throws IOException {
        int i2;
        if (n2 > 8) {
            throw new IllegalArgumentException("N should be less then 8");
        }
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int[] bits = new int[16 - this.nBit];
        int cnt = 0;
        for (i2 = this.nBit; i2 < 8; ++i2) {
            bits[cnt++] = this.curByte >> 7 - i2 & 1;
        }
        for (i2 = 0; i2 < 8; ++i2) {
            bits[cnt++] = this.nextByte >> 7 - i2 & 1;
        }
        int result = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            result <<= 1;
            result |= bits[i3];
        }
        return result;
    }

    public boolean isByteAligned() {
        return this.nBit % 8 == 0;
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int getCurBit() {
        return this.nBit;
    }

    public boolean moreData(int bits) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final int skip(int bits) throws IOException {
        this.nBit += bits;
        int was = this.nBit;
        while (this.nBit >= 8 && this.curByte != -1) {
            this.advance1();
            this.nBit -= 8;
        }
        return was - this.nBit;
    }

    public int align() throws IOException {
        int n2 = 8 - this.nBit & 7;
        this.skip(8 - this.nBit & 7);
        return n2;
    }

    public int checkNBit(int n2) throws IOException {
        return this.peakNextBits(n2);
    }

    public int curBit() {
        return this.nBit;
    }

    public boolean lastByte() throws IOException {
        return this.nextByte == -1 && this.secondByte == -1;
    }
}

