/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import java.nio.ByteBuffer;

public class BitWriter {
    private final ByteBuffer buf;
    private int curInt;
    private int curBit;
    private int initPos;

    public BitWriter(ByteBuffer buf) {
        this.buf = buf;
        this.initPos = buf.position();
    }

    private BitWriter(ByteBuffer os, int curBit, int curInt, int initPos) {
        this.buf = os;
        this.curBit = curBit;
        this.curInt = curInt;
        this.initPos = initPos;
    }

    public void flush() {
        int toWrite = this.curBit + 7 >> 3;
        for (int i2 = 0; i2 < toWrite; ++i2) {
            this.buf.put((byte)(this.curInt >>> 24));
            this.curInt <<= 8;
        }
    }

    private final void putInt(int i2) {
        this.buf.put((byte)(i2 >>> 24));
        this.buf.put((byte)(i2 >> 16));
        this.buf.put((byte)(i2 >> 8));
        this.buf.put((byte)i2);
    }

    public final void writeNBit(int value, int n2) {
        if (n2 > 32) {
            throw new IllegalArgumentException("Max 32 bit to write");
        }
        if (n2 == 0) {
            return;
        }
        value &= -1 >>> 32 - n2;
        if (32 - this.curBit >= n2) {
            this.curInt |= value << 32 - this.curBit - n2;
            this.curBit += n2;
            if (this.curBit == 32) {
                this.putInt(this.curInt);
                this.curBit = 0;
                this.curInt = 0;
            }
        } else {
            int secPart = n2 - (32 - this.curBit);
            this.curInt |= value >>> secPart;
            this.putInt(this.curInt);
            this.curInt = value << 32 - secPart;
            this.curBit = secPart;
        }
    }

    public void write1Bit(int bit) {
        this.curInt |= bit << 32 - this.curBit - 1;
        ++this.curBit;
        if (this.curBit == 32) {
            this.putInt(this.curInt);
            this.curBit = 0;
            this.curInt = 0;
        }
    }

    public int curBit() {
        return this.curBit & 7;
    }

    public BitWriter fork() {
        return new BitWriter(this.buf.duplicate(), this.curBit, this.curInt, this.initPos);
    }

    public int position() {
        return (this.buf.position() - this.initPos << 3) + this.curBit;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }
}

