/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import java.nio.ByteBuffer;

public class BitReader {
    protected int deficit;
    protected int curInt;
    private ByteBuffer bb;

    public BitReader(ByteBuffer bb) {
        this.bb = bb;
        this.curInt = this.readInt();
        this.deficit = 0;
    }

    private BitReader(BitReader other) {
        this.bb = other.bb.duplicate();
        this.curInt = other.curInt;
        this.deficit = other.deficit;
    }

    public final int readInt() {
        if (this.bb.remaining() >= 4) {
            this.deficit -= 32;
            return (this.bb.get() & 0xFF) << 24 | (this.bb.get() & 0xFF) << 16 | (this.bb.get() & 0xFF) << 8 | this.bb.get() & 0xFF;
        }
        return this.readIntSafe();
    }

    private int readIntSafe() {
        this.deficit -= this.bb.remaining() << 3;
        int res = 0;
        if (this.bb.hasRemaining()) {
            res |= this.bb.get() & 0xFF;
        }
        res <<= 8;
        if (this.bb.hasRemaining()) {
            res |= this.bb.get() & 0xFF;
        }
        res <<= 8;
        if (this.bb.hasRemaining()) {
            res |= this.bb.get() & 0xFF;
        }
        res <<= 8;
        if (this.bb.hasRemaining()) {
            res |= this.bb.get() & 0xFF;
        }
        return res;
    }

    public int read1Bit() {
        int ret = this.curInt >>> 31;
        this.curInt <<= 1;
        ++this.deficit;
        if (this.deficit == 32) {
            this.curInt = this.readInt();
        }
        return ret;
    }

    public int readNBit(int n2) {
        if (n2 > 32) {
            throw new IllegalArgumentException("Can not read more then 32 bit");
        }
        int nn = n2;
        int ret = 0;
        if (n2 + this.deficit > 31) {
            ret |= this.curInt >>> this.deficit;
            ret <<= (n2 -= 32 - this.deficit);
            this.deficit = 32;
            this.curInt = this.readInt();
        }
        if (n2 != 0) {
            ret |= this.curInt >>> 32 - n2;
            this.curInt <<= n2;
            this.deficit += n2;
        }
        return ret;
    }

    public boolean moreData() {
        int remaining = this.bb.remaining() + 4 - (this.deficit + 7 >> 3);
        return remaining > 1 || remaining == 1 && this.curInt != 0;
    }

    public int remaining() {
        return (this.bb.remaining() << 3) + 32 - this.deficit;
    }

    public final boolean isByteAligned() {
        return (this.deficit & 7) == 0;
    }

    public int skip(int bits) {
        int left = bits;
        if (left + this.deficit > 31) {
            this.deficit = 32;
            if ((left -= 32 - this.deficit) > 31) {
                int skip = Math.min(left >> 3, this.bb.remaining());
                this.bb.position(this.bb.position() + skip);
                left -= skip << 3;
            }
            this.curInt = this.readInt();
        }
        this.deficit += left;
        this.curInt <<= left;
        return bits;
    }

    public int align() {
        return (this.deficit & 7) > 0 ? this.skip(8 - (this.deficit & 7)) : 0;
    }

    public int checkNBit(int n2) {
        if (n2 > 24) {
            throw new IllegalArgumentException("Can not check more then 24 bit");
        }
        while (this.deficit + n2 > 32) {
            this.deficit -= 8;
            this.curInt |= this.nextIgnore() << this.deficit;
        }
        int res = this.curInt >>> 32 - n2;
        return res;
    }

    private int nextIgnore() {
        return this.bb.hasRemaining() ? this.bb.get() & 0xFF : 0;
    }

    public int curBit() {
        return this.deficit & 7;
    }

    public boolean lastByte() {
        return this.bb.remaining() + 4 - (this.deficit >> 3) <= 1;
    }

    public BitReader fork() {
        return new BitReader(this);
    }

    public void terminate() {
        int putBack = 32 - this.deficit >> 3;
        this.bb.position(this.bb.position() - putBack);
    }
}

