/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.dct;

import java.util.Arrays;
import org.jcodec.common.dct.SimpleIDCT10Bit;

public class SparseIDCT {
    public static final int[][] COEFF = new int[64][];
    public static final int PRECISION = 13;
    public static final int DC_SHIFT = 10;

    public static final void start(int[] block, int dc) {
        dc <<= 10;
        for (int i2 = 0; i2 < 64; i2 += 4) {
            block[i2 + 0] = dc;
            block[i2 + 1] = dc;
            block[i2 + 2] = dc;
            block[i2 + 3] = dc;
        }
    }

    public static final void coeff(int[] block, int ind, int level) {
        for (int i2 = 0; i2 < 64; i2 += 4) {
            int n2 = i2;
            block[n2] = block[n2] + COEFF[ind][i2] * level;
            int n3 = i2 + 1;
            block[n3] = block[n3] + COEFF[ind][i2 + 1] * level;
            int n4 = i2 + 2;
            block[n4] = block[n4] + COEFF[ind][i2 + 2] * level;
            int n5 = i2 + 3;
            block[n5] = block[n5] + COEFF[ind][i2 + 3] * level;
        }
    }

    public static final void finish(int[] block) {
        for (int i2 = 0; i2 < 64; i2 += 4) {
            block[i2] = SparseIDCT.div(block[i2]);
            block[i2 + 1] = SparseIDCT.div(block[i2 + 1]);
            block[i2 + 2] = SparseIDCT.div(block[i2 + 2]);
            block[i2 + 3] = SparseIDCT.div(block[i2 + 3]);
        }
    }

    private static final int div(int x) {
        int m2 = x >> 31;
        int n2 = x >>> 31;
        return ((x ^ m2) + n2 >> 13 ^ m2) + n2;
    }

    static {
        SparseIDCT.COEFF[0] = new int[64];
        Arrays.fill(COEFF[0], 1024);
        int ac = 8192;
        for (int i2 = 1; i2 < 64; ++i2) {
            SparseIDCT.COEFF[i2] = new int[64];
            SparseIDCT.COEFF[i2][i2] = ac;
            SimpleIDCT10Bit.idct10(COEFF[i2], 0);
        }
    }
}

