/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.lang.reflect.Array;

public class IntObjectMap<T> {
    private static final int GROW_BY = 128;
    private Object[] storage = new Object[128];
    private int size;

    public void put(int key, T val) {
        if (this.storage.length <= key) {
            Object[] ns = new Object[this.storage.length + 128];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        if (this.storage[key] == null) {
            ++this.size;
        }
        this.storage[key] = val;
    }

    public T get(int key) {
        return (T)(key >= this.storage.length ? null : this.storage[key]);
    }

    public int[] keys() {
        int[] result = new int[this.size];
        int r = 0;
        for (int i2 = 0; i2 < this.storage.length; ++i2) {
            if (this.storage[i2] == null) continue;
            result[r++] = i2;
        }
        return result;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.storage.length; ++i2) {
            this.storage[i2] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void remove(int key) {
        if (this.storage[key] != null) {
            --this.size;
        }
        this.storage[key] = null;
    }

    public T[] values(T[] runtime) {
        Object[] result = (Object[])Array.newInstance(runtime.getClass().getComponentType(), this.size);
        int r = 0;
        for (int i2 = 0; i2 < this.storage.length; ++i2) {
            if (this.storage[i2] == null) continue;
            result[r++] = this.storage[i2];
        }
        return result;
    }
}

