/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.io.IOException;
import java.io.InputStream;
import org.jcodec.common.ProxyInputStream;

public class CountingInputStream
extends ProxyInputStream {
    private int count;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int found = super.read(b2);
        this.count += found >= 0 ? found : 0;
        return found;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int found = super.read(b2, off, len);
        this.count += found >= 0 ? found : 0;
        return found;
    }

    @Override
    public int read() throws IOException {
        int found = super.read();
        this.count += found >= 0 ? 1 : 0;
        return found;
    }

    @Override
    public long skip(long length) throws IOException {
        long skip = super.skip(length);
        this.count = (int)((long)this.count + skip);
        return skip;
    }

    public int getCount() {
        return this.count;
    }

    public synchronized int resetCount() {
        int tmp = this.count;
        this.count = 0;
        return tmp;
    }
}

