/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;

public class AudioUtil {
    public static final float r16 = 3.0517578E-5f;
    public static final float r24 = 1.1920929E-7f;

    public static int toFloat(AudioFormat format, ByteBuffer buf, float[] floatBuf) {
        if (format.isBigEndian()) {
            if (format.getSampleSizeInBits() == 16) {
                return AudioUtil.toFloat16BE(buf, floatBuf);
            }
            return AudioUtil.toFloat24BE(buf, floatBuf);
        }
        if (format.getSampleSizeInBits() == 16) {
            return AudioUtil.toFloat16LE(buf, floatBuf);
        }
        return AudioUtil.toFloat24LE(buf, floatBuf);
    }

    private static int toFloat24LE(ByteBuffer buf, float[] out) {
        int samples = 0;
        while (buf.remaining() >= 3 && samples < out.length) {
            out[samples++] = 1.1920929E-7f * (float)(((buf.get() & 0xFF) << 8 | (buf.get() & 0xFF) << 16 | (buf.get() & 0xFF) << 24) >> 8);
        }
        return samples;
    }

    private static int toFloat16LE(ByteBuffer buf, float[] out) {
        int samples = 0;
        while (buf.remaining() >= 2 && samples < out.length) {
            out[samples++] = 3.0517578E-5f * (float)((short)(buf.get() & 0xFF | (buf.get() & 0xFF) << 8));
        }
        return samples;
    }

    private static int toFloat24BE(ByteBuffer buf, float[] out) {
        int samples = 0;
        while (buf.remaining() >= 3 && samples < out.length) {
            out[samples++] = 1.1920929E-7f * (float)(((buf.get() & 0xFF) << 24 | (buf.get() & 0xFF) << 16 | (buf.get() & 0xFF) << 8) >> 8);
        }
        return samples;
    }

    private static int toFloat16BE(ByteBuffer buf, float[] out) {
        int samples = 0;
        while (buf.remaining() >= 2 && samples < out.length) {
            out[samples++] = 3.0517578E-5f * (float)((short)((buf.get() & 0xFF) << 8 | buf.get() & 0xFF));
        }
        return samples;
    }
}

