/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.wav;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jcodec.algo.DataConvert;
import org.jcodec.codecs.wav.WavHeader;

public class WavInput {
    private InputStream is;
    private WavHeader header;
    private byte[] prevBuf;

    public WavInput(File file) throws IOException {
        this.is = new BufferedInputStream(new FileInputStream(file));
        this.header = WavHeader.read(this.is);
    }

    public int[] read(int samples) throws IOException {
        int read;
        int bufLen = samples * (this.header.fmt.bitsPerSample >> 3);
        if (this.prevBuf == null || bufLen != this.prevBuf.length) {
            this.prevBuf = new byte[bufLen];
        }
        if ((read = this.is.read(this.prevBuf)) == -1) {
            return null;
        }
        int[] conv = DataConvert.fromByte(this.prevBuf, this.header.fmt.bitsPerSample, false);
        return read == bufLen ? conv : Arrays.copyOf(conv, read / (this.header.fmt.bitsPerSample >> 3));
    }

    public void close() throws IOException {
        this.is.close();
    }

    public WavHeader getHeader() {
        return this.header;
    }
}

