/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.wav;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.jcodec.codecs.wav.ReaderLE;
import org.jcodec.codecs.wav.StringReader;
import org.jcodec.codecs.wav.WriterLE;
import org.jcodec.common.CountingInputStream;
import org.jcodec.common.IOUtils;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.model.ChannelLabel;

public class WavHeader {
    static ChannelLabel[] mapping = new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.LFE, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT, ChannelLabel.FRONT_CENTER_LEFT, ChannelLabel.FRONT_CENTER_RIGHT, ChannelLabel.REAR_CENTER, ChannelLabel.SIDE_LEFT, ChannelLabel.SIDE_RIGHT, ChannelLabel.CENTER, ChannelLabel.FRONT_LEFT, ChannelLabel.CENTER, ChannelLabel.FRONT_RIGHT, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_CENTER, ChannelLabel.REAR_RIGHT, ChannelLabel.STEREO_LEFT, ChannelLabel.STEREO_RIGHT};
    public String chunkId;
    public int chunkSize;
    public String format;
    public FmtChunk fmt;
    public int dataOffset;
    public long dataSize;
    public static final int WAV_HEADER_SIZE = 44;

    public WavHeader(String chunkId, int chunkSize, String format, FmtChunk fmt, int dataOffset, long dataSize) {
        this.chunkId = chunkId;
        this.chunkSize = chunkSize;
        this.format = format;
        this.fmt = fmt;
        this.dataOffset = dataOffset;
        this.dataSize = dataSize;
    }

    public WavHeader(WavHeader header) {
        throw new UnsupportedOperationException();
    }

    public WavHeader(WavHeader header, int rate) {
        this(header);
        this.fmt.sampleRate = rate;
    }

    public static WavHeader stereo48k() {
        return WavHeader.stereo48k(0L);
    }

    public static WavHeader stereo48k(long samples) {
        return new WavHeader("RIFF", 40, "WAVE", new FmtChunk(1, 2, 48000, 192000, 4, 16), 44, WavHeader.calcDataSize(1, 2, samples));
    }

    public static WavHeader mono48k(long samples) {
        return new WavHeader("RIFF", 40, "WAVE", new FmtChunk(1, 1, 48000, 96000, 2, 16), 44, WavHeader.calcDataSize(1, 2, samples));
    }

    public static WavHeader emptyWavHeader() {
        return new WavHeader("RIFF", 40, "WAVE", new FmtChunk(), 44, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WavHeader read(File file) throws IOException {
        WavHeader wavHeader;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            wavHeader = WavHeader.read(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly(is);
        return wavHeader;
    }

    public static WavHeader read(InputStream in) throws IOException {
        String fourcc;
        CountingInputStream cin = new CountingInputStream(in);
        String chunkId = StringReader.readString(cin, 4);
        int chunkSize = ReaderLE.readInt(cin);
        String format = StringReader.readString(cin, 4);
        FmtChunk fmt = null;
        if (!"RIFF".equals(chunkId) || !"WAVE".equals(format)) {
            return null;
        }
        int size = 0;
        block5: do {
            fourcc = StringReader.readString(cin, 4);
            size = ReaderLE.readInt(cin);
            if ("fmt ".equals(fourcc) && size >= 14 && size <= 0x100000) {
                switch (size) {
                    case 16: 
                    case 18: {
                        fmt = FmtChunk.read(cin);
                        StringReader.sureSkip(cin, 2L);
                        continue block5;
                    }
                    case 40: {
                        fmt = FmtChunkExtended.read(cin);
                        StringReader.sureSkip(cin, 12L);
                        continue block5;
                    }
                    case 28: {
                        fmt = FmtChunkExtended.read(cin);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle fmt size: " + size);
                    }
                }
            }
            if ("data".equals(fourcc)) continue;
            StringReader.sureRead(cin, size);
        } while (!"data".equals(fourcc));
        return new WavHeader(chunkId, chunkSize, format, fmt, cin.getCount(), size);
    }

    public static WavHeader multiChannelWav(List<File> wavs) throws IOException {
        return WavHeader.multiChannelWav(wavs.toArray(new File[0]));
    }

    public static WavHeader multiChannelWav(File ... wavs) throws IOException {
        WavHeader[] headers = new WavHeader[wavs.length];
        for (int i2 = 0; i2 < wavs.length; ++i2) {
            headers[i2] = WavHeader.read(wavs[i2]);
        }
        return WavHeader.multiChannelWav(headers);
    }

    public static WavHeader multiChannelWav(WavHeader ... wavs) {
        WavHeader w = WavHeader.emptyWavHeader();
        int totalSize = 0;
        for (WavHeader wavHeader : wavs) {
            totalSize = (int)((long)totalSize + wavHeader.dataSize);
        }
        w.dataSize = totalSize;
        FmtChunk fmt = wavs[0].fmt;
        short bitsPerSample = fmt.bitsPerSample;
        int bytesPerSample = bitsPerSample / 8;
        int sampleRate = fmt.sampleRate;
        w.fmt.bitsPerSample = bitsPerSample;
        w.fmt.blockAlign = (short)(wavs.length * bytesPerSample);
        w.fmt.byteRate = wavs.length * bytesPerSample * sampleRate;
        w.fmt.numChannels = (short)wavs.length;
        w.fmt.sampleRate = sampleRate;
        return w;
    }

    public void write(OutputStream out) throws IOException {
        long chunkSize = this.dataSize <= 0xFFFFFFFFL ? this.dataSize + 36L : 40L;
        out.write(JCodecUtil.asciiString("RIFF"));
        WriterLE.writeInt(out, (int)chunkSize);
        out.write(JCodecUtil.asciiString("WAVE"));
        out.write(JCodecUtil.asciiString("fmt "));
        WriterLE.writeInt(out, this.fmt.size());
        this.fmt.write(out);
        out.write(JCodecUtil.asciiString("data"));
        if (this.dataSize <= 0xFFFFFFFFL) {
            WriterLE.writeInt(out, (int)this.dataSize);
        } else {
            WriterLE.writeInt(out, 0);
        }
    }

    public void writeExtended(OutputStream out) throws IOException {
        long chunkSize = this.dataSize <= 0xFFFFFFFFL ? this.dataSize + 36L : 40L;
        out.write(JCodecUtil.asciiString("RIFF"));
        WriterLE.writeInt(out, (int)chunkSize);
        out.write(JCodecUtil.asciiString("WAVE"));
        out.write(JCodecUtil.asciiString("fmt "));
        WriterLE.writeInt(out, this.fmt.size());
        this.fmt.write(out);
        out.write(JCodecUtil.asciiString("data"));
        if (this.dataSize <= 0xFFFFFFFFL) {
            WriterLE.writeInt(out, (int)this.dataSize);
        } else {
            WriterLE.writeInt(out, 0);
        }
    }

    public static long calcDataSize(int numChannels, int bytesPerSample, long samples) {
        return samples * (long)numChannels * (long)bytesPerSample;
    }

    public static WavHeader create(AudioFormat af, int size) {
        WavHeader w = WavHeader.emptyWavHeader();
        w.dataSize = size;
        FmtChunk fmt = new FmtChunk();
        int bitsPerSample = af.getSampleSizeInBits();
        int bytesPerSample = bitsPerSample / 8;
        int sampleRate = (int)af.getSampleRate();
        w.fmt.bitsPerSample = (short)bitsPerSample;
        w.fmt.blockAlign = (short)af.getFrameSize();
        w.fmt.byteRate = (int)af.getFrameRate() * af.getFrameSize();
        w.fmt.numChannels = (short)af.getChannels();
        w.fmt.sampleRate = (int)af.getSampleRate();
        return w;
    }

    public ChannelLabel[] getChannelLabels() {
        if (this.fmt instanceof FmtChunkExtended) {
            return ((FmtChunkExtended)this.fmt).getLabels();
        }
        switch (this.fmt.numChannels) {
            case 1: {
                return new ChannelLabel[]{ChannelLabel.MONO};
            }
            case 2: {
                return new ChannelLabel[]{ChannelLabel.STEREO_LEFT, ChannelLabel.STEREO_RIGHT};
            }
            case 3: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.REAR_CENTER};
            }
            case 4: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT};
            }
            case 5: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT};
            }
            case 6: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.LFE, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT};
            }
            case 7: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.LFE, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT, ChannelLabel.REAR_CENTER};
            }
            case 8: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.LFE, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT};
            }
        }
        ChannelLabel[] labels = new ChannelLabel[this.fmt.numChannels];
        Arrays.fill((Object[])labels, (Object)ChannelLabel.MONO);
        return labels;
    }

    public static class FmtChunk {
        public short audioFormat;
        public short numChannels;
        public int sampleRate;
        public int byteRate;
        public short blockAlign;
        public short bitsPerSample;

        public FmtChunk() {
            this.audioFormat = 1;
        }

        public FmtChunk(short audioFormat, short numChannels, int sampleRate, int byteRate, short blockAlign, short bitsPerSample) {
            this.audioFormat = audioFormat;
            this.numChannels = numChannels;
            this.sampleRate = sampleRate;
            this.byteRate = byteRate;
            this.blockAlign = blockAlign;
            this.bitsPerSample = bitsPerSample;
        }

        public FmtChunk(FmtChunk other) {
            this(other.audioFormat, other.numChannels, other.sampleRate, other.byteRate, other.blockAlign, other.bitsPerSample);
        }

        public static FmtChunk read(InputStream input) throws IOException {
            return new FmtChunk(ReaderLE.readShort(input), ReaderLE.readShort(input), ReaderLE.readInt(input), ReaderLE.readInt(input), ReaderLE.readShort(input), ReaderLE.readShort(input));
        }

        public void write(OutputStream out) throws IOException {
            WriterLE.writeShort(out, this.audioFormat);
            WriterLE.writeShort(out, this.numChannels);
            WriterLE.writeInt(out, this.sampleRate);
            WriterLE.writeInt(out, this.byteRate);
            WriterLE.writeShort(out, this.blockAlign);
            WriterLE.writeShort(out, this.bitsPerSample);
        }

        public int size() {
            return 16;
        }
    }

    public static class FmtChunkExtended
    extends FmtChunk {
        short cbSize;
        short bitsPerCodedSample;
        int channelLayout;
        int guid;

        public FmtChunkExtended(FmtChunk fmtChunk, short cbSize, short bitsPerCodedSample, int channelLayout, int guid) {
            super(fmtChunk);
            this.cbSize = cbSize;
            this.bitsPerCodedSample = bitsPerCodedSample;
            this.channelLayout = channelLayout;
            this.guid = guid;
        }

        public static FmtChunk read(InputStream input) throws IOException {
            FmtChunk fmtChunk = FmtChunk.read(input);
            return new FmtChunkExtended(fmtChunk, ReaderLE.readShort(input), ReaderLE.readShort(input), ReaderLE.readInt(input), ReaderLE.readInt(input));
        }

        @Override
        public void write(OutputStream out) throws IOException {
            super.write(out);
            WriterLE.writeShort(out, this.cbSize);
            WriterLE.writeShort(out, this.bitsPerCodedSample);
            WriterLE.writeInt(out, this.channelLayout);
            WriterLE.writeInt(out, this.guid);
        }

        @Override
        public int size() {
            return super.size() + 12;
        }

        public ChannelLabel[] getLabels() {
            ArrayList<ChannelLabel> labels = new ArrayList<ChannelLabel>();
            for (int i2 = 0; i2 < mapping.length; ++i2) {
                if ((this.channelLayout & 1 << i2) == 0) continue;
                labels.add(mapping[i2]);
            }
            return labels.toArray(new ChannelLabel[0]);
        }
    }
}

