/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.raw;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class V210Decoder {
    private int width;
    private int height;

    public V210Decoder(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Picture decode(byte[] data) {
        IntBuffer dat = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        IntBuffer y = IntBuffer.wrap(new int[this.width * this.height]);
        IntBuffer cb = IntBuffer.wrap(new int[this.width * this.height / 2]);
        IntBuffer cr = IntBuffer.wrap(new int[this.width * this.height / 2]);
        while (dat.hasRemaining()) {
            int i2 = dat.get();
            cr.put(i2 >> 20);
            y.put(i2 >> 10 & 0x3FF);
            cb.put(i2 & 0x3FF);
            i2 = dat.get();
            y.put(i2 & 0x3FF);
            y.put(i2 >> 20);
            cb.put(i2 >> 10 & 0x3FF);
            i2 = dat.get();
            cb.put(i2 >> 20);
            y.put(i2 >> 10 & 0x3FF);
            cr.put(i2 & 0x3FF);
            i2 = dat.get();
            y.put(i2 & 0x3FF);
            y.put(i2 >> 20);
            cr.put(i2 >> 10 & 0x3FF);
        }
        return new Picture(this.width, this.height, new int[][]{y.array(), cb.array(), cr.array()}, ColorSpace.YUV422_10);
    }
}

