/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import org.jcodec.codecs.prores.ProresConsts;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.dct.IDCT2x2;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class ProresToThumb2x2
extends ProresDecoder {
    @Override
    protected int[] decodeOnePlane(BitReader bits, int blocksPerSlice, int[] qMat, int[] scan, int mbX, int mbY, int plane) {
        int[] out = new int[blocksPerSlice << 2];
        ProresToThumb2x2.readDCCoeffs(bits, qMat, out, blocksPerSlice, 4);
        ProresToThumb2x2.readACCoeffs(bits, qMat, out, blocksPerSlice, scan, 4, 2);
        for (int i2 = 0; i2 < blocksPerSlice; ++i2) {
            IDCT2x2.idct(out, i2 << 2);
        }
        return out;
    }

    @Override
    public Picture decodeFrame(ByteBuffer data, int[][] target) {
        ProresConsts.FrameHeader fh = ProresToThumb2x2.readFrameHeader(data);
        int codedWidth = (fh.width + 15 & 0xFFFFFFF0) >> 2;
        int codedHeight = (fh.height + 15 & 0xFFFFFFF0) >> 2;
        int lumaSize = codedWidth * codedHeight;
        int chromaSize = lumaSize >> 1;
        if (target == null || target[0].length < lumaSize || target[1].length < chromaSize || target[2].length < chromaSize) {
            throw new RuntimeException("Provided output picture won't fit into provided buffer");
        }
        if (fh.frameType == 0) {
            this.decodePicture(data, target, codedWidth, codedHeight, codedWidth >> 2, fh.qMatLuma, fh.qMatChroma, new int[]{0, 1, 2, 3}, 0);
        } else {
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 2, fh.qMatLuma, fh.qMatChroma, new int[]{0, 2, 1, 3}, fh.topFieldFirst ? 1 : 2);
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 2, fh.qMatLuma, fh.qMatChroma, new int[]{0, 2, 1, 3}, fh.topFieldFirst ? 2 : 1);
        }
        return new Picture(codedWidth, codedHeight, target, ColorSpace.YUV422_10);
    }

    @Override
    protected void putSlice(int[][] result, int lumaStride, int mbX, int mbY, int[] y, int[] u, int[] v, int dist, int shift) {
        int mbPerSlice = y.length >> 4;
        int chromaStride = lumaStride >> 1;
        this.putLuma(result[0], shift * lumaStride, lumaStride << dist, mbX, mbY, y, mbPerSlice, dist, shift);
        this.putChroma(result[1], shift * chromaStride, chromaStride << dist, mbX, mbY, u, mbPerSlice, dist, shift);
        this.putChroma(result[2], shift * chromaStride, chromaStride << dist, mbX, mbY, v, mbPerSlice, dist, shift);
    }

    private void putLuma(int[] y, int off, int stride, int mbX, int mbY, int[] luma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 2) + (mbY << 2) * stride;
        int tstride = stride * 3;
        int sOff = 0;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            y[off] = ProresToThumb2x2.clip(luma[sOff], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(luma[sOff + 1], 4, 1019);
            y[off + 2] = ProresToThumb2x2.clip(luma[sOff + 4], 4, 1019);
            y[off + 3] = ProresToThumb2x2.clip(luma[sOff + 5], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(luma[sOff + 2], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(luma[sOff + 3], 4, 1019);
            y[off + 2] = ProresToThumb2x2.clip(luma[sOff + 6], 4, 1019);
            y[off + 3] = ProresToThumb2x2.clip(luma[sOff + 7], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(luma[sOff + 8], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(luma[sOff + 9], 4, 1019);
            y[off + 2] = ProresToThumb2x2.clip(luma[sOff + 12], 4, 1019);
            y[off + 3] = ProresToThumb2x2.clip(luma[sOff + 13], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(luma[sOff + 10], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(luma[sOff + 11], 4, 1019);
            y[off + 2] = ProresToThumb2x2.clip(luma[sOff + 14], 4, 1019);
            y[off + 3] = ProresToThumb2x2.clip(luma[sOff + 15], 4, 1019);
            off += 4 - tstride;
            sOff += 16;
        }
    }

    private void putChroma(int[] y, int off, int stride, int mbX, int mbY, int[] chroma, int mbPerSlice, int dist, int shift) {
        int tstride = stride * 3;
        off += (mbX << 1) + (mbY << 2) * stride;
        int sOff = 0;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            y[off] = ProresToThumb2x2.clip(chroma[sOff], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(chroma[sOff + 1], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(chroma[sOff + 2], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(chroma[sOff + 3], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(chroma[sOff + 4], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(chroma[sOff + 5], 4, 1019);
            y[off += stride] = ProresToThumb2x2.clip(chroma[sOff + 6], 4, 1019);
            y[off + 1] = ProresToThumb2x2.clip(chroma[sOff + 7], 4, 1019);
            off += 2 - tstride;
            sOff += 8;
        }
    }
}

