/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodec.codecs.prores.Codebook;
import org.jcodec.codecs.prores.ProresConsts;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.dct.SimpleIDCT10Bit;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.tools.MathUtil;

public class ProresDecoder
implements VideoDecoder {
    static final int[] table = new int[]{7, 6, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] mask = new int[]{0, 0, 0, 0, 0, 0, 0, -1};

    public static final int nZeros(int check14Bit) {
        int low = table[check14Bit & 0x7F];
        int high = table[(check14Bit >>= 7) & 0x7F];
        return high + (mask[high & 7] & low);
    }

    public static final int readCodeword(BitReader reader, Codebook codebook) {
        int val;
        int q = ProresDecoder.nZeros(reader.checkNBit(14));
        if (q > codebook.switchBits) {
            int bits = codebook.expOrder - codebook.switchBits + (q << 1);
            val = reader.readNBit(bits);
            val -= 1 << codebook.expOrder;
            val += codebook.switchBits + 1 << codebook.riceOrder;
        } else if (codebook.riceOrder > 0) {
            reader.skip(q + 1);
            val = (q << codebook.riceOrder) + reader.readNBit(codebook.riceOrder);
        } else {
            reader.skip(q + 1);
            val = q;
        }
        return val;
    }

    public static final int golumbToSigned(int val) {
        return val >> 1 ^ ProresDecoder.golumbSign(val);
    }

    public static final int golumbSign(int val) {
        return -(val & 1);
    }

    public static final void readDCCoeffs(BitReader bits, int[] qMat, int[] out, int blocksPerSlice, int blkSize) {
        int c2 = ProresDecoder.readCodeword(bits, ProresConsts.firstDCCodebook);
        if (c2 < 0) {
            return;
        }
        int prevDc = ProresDecoder.golumbToSigned(c2);
        out[0] = 4096 + ProresDecoder.qScale(qMat, 0, prevDc);
        int code = 5;
        int sign = 0;
        int idx = blkSize;
        int i2 = 1;
        while (i2 < blocksPerSlice) {
            if ((code = ProresDecoder.readCodeword(bits, ProresConsts.dcCodebooks[Math.min(code, 6)])) < 0) {
                return;
            }
            sign = code != 0 ? (sign ^= ProresDecoder.golumbSign(code)) : 0;
            out[idx] = 4096 + ProresDecoder.qScale(qMat, 0, prevDc += MathUtil.toSigned(code + 1 >> 1, sign));
            ++i2;
            idx += blkSize;
        }
    }

    protected static final void readACCoeffs(BitReader bits, int[] qMat, int[] out, int blocksPerSlice, int[] scan, int max, int log2blkSize) {
        int run = 4;
        int level = 2;
        int blockMask = blocksPerSlice - 1;
        int log2BlocksPerSlice = MathUtil.log2(blocksPerSlice);
        int maxCoeffs = 64 << log2BlocksPerSlice;
        int pos = blockMask;
        while (bits.moreData()) {
            if ((run = ProresDecoder.readCodeword(bits, ProresConsts.runCodebooks[Math.min(run, 15)])) < 0 || run >= maxCoeffs - pos - 1) {
                return;
            }
            pos += run + 1;
            if ((level = ProresDecoder.readCodeword(bits, ProresConsts.levCodebooks[Math.min(level, 9)]) + 1) < 0 || level > 65535) {
                return;
            }
            int sign = -bits.read1Bit();
            int ind = pos >> log2BlocksPerSlice;
            if (ind >= max) break;
            out[((pos & blockMask) << log2blkSize) + scan[ind]] = ProresDecoder.qScale(qMat, ind, MathUtil.toSigned(level, sign));
        }
    }

    private static final int qScale(int[] qMat, int ind, int val) {
        return val * qMat[ind] >> 2;
    }

    protected int[] decodeOnePlane(BitReader bits, int blocksPerSlice, int[] qMat, int[] scan, int mbX, int mbY, int plane) {
        int[] out = new int[blocksPerSlice << 6];
        ProresDecoder.readDCCoeffs(bits, qMat, out, blocksPerSlice, 64);
        ProresDecoder.readACCoeffs(bits, qMat, out, blocksPerSlice, scan, 64, 6);
        for (int i2 = 0; i2 < blocksPerSlice; ++i2) {
            SimpleIDCT10Bit.idct10(out, i2 << 6);
        }
        return out;
    }

    @Override
    public Picture decodeFrame(ByteBuffer data, int[][] target) {
        ProresConsts.FrameHeader fh = ProresDecoder.readFrameHeader(data);
        int codedWidth = fh.width + 15 & 0xFFFFFFF0;
        int codedHeight = fh.height + 15 & 0xFFFFFFF0;
        int lumaSize = codedWidth * codedHeight;
        int chromaSize = lumaSize >> 1;
        if (target == null || target[0].length < lumaSize || target[1].length < chromaSize || target[2].length < chromaSize) {
            throw new RuntimeException("Provided output picture won't fit into provided buffer");
        }
        if (fh.frameType == 0) {
            this.decodePicture(data, target, fh.width, fh.height, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, 0);
        } else {
            this.decodePicture(data, target, fh.width, fh.height >> 1, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, fh.topFieldFirst ? 1 : 2);
            this.decodePicture(data, target, fh.width, fh.height >> 1, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, fh.topFieldFirst ? 2 : 1);
        }
        return new Picture(codedWidth, codedHeight, target, ColorSpace.YUV422_10);
    }

    public Picture[] decodeFields(ByteBuffer data, int[][][] target) {
        ProresConsts.FrameHeader fh = ProresDecoder.readFrameHeader(data);
        int codedWidth = fh.width + 15 & 0xFFFFFFF0;
        int codedHeight = fh.height + 15 & 0xFFFFFFF0;
        int lumaSize = codedWidth * codedHeight;
        int chromaSize = lumaSize >> 1;
        if (fh.frameType == 0) {
            if (target == null || target[0][0].length < lumaSize || target[0][1].length < chromaSize || target[0][2].length < chromaSize) {
                throw new RuntimeException("Provided output picture won't fit into provided buffer");
            }
            this.decodePicture(data, target[0], fh.width, fh.height, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, 0);
            return new Picture[]{new Picture(codedWidth, codedHeight, target[0], ColorSpace.YUV422_10)};
        }
        if (target == null || target[0][0].length < (lumaSize >>= 1) || target[0][1].length < (chromaSize >>= 1) || target[0][2].length < chromaSize || target[1][0].length < lumaSize || target[1][1].length < chromaSize || target[1][2].length < chromaSize) {
            throw new RuntimeException("Provided output picture won't fit into provided buffer");
        }
        this.decodePicture(data, target[fh.topFieldFirst ? 0 : 1], fh.width, fh.height >> 1, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, 0);
        this.decodePicture(data, target[fh.topFieldFirst ? 1 : 0], fh.width, fh.height >> 1, codedWidth >> 4, fh.qMatLuma, fh.qMatChroma, fh.scan, 0);
        return new Picture[]{new Picture(codedWidth, codedHeight >> 1, target[0], ColorSpace.YUV422_10), new Picture(codedWidth, codedHeight >> 1, target[1], ColorSpace.YUV422_10)};
    }

    public static ProresConsts.FrameHeader readFrameHeader(ByteBuffer inp) {
        int[] scan;
        int frameSize = inp.getInt();
        String sig = ProresDecoder.readSig(inp);
        if (!"icpf".equals(sig)) {
            throw new RuntimeException("Not a prores frame");
        }
        short hdrSize = inp.getShort();
        short version = inp.getShort();
        int res1 = inp.getInt();
        short width = inp.getShort();
        short height = inp.getShort();
        byte flags1 = inp.get();
        int frameType = flags1 >> 2 & 3;
        boolean topFieldFirst = false;
        if (frameType == 0) {
            scan = ProresConsts.progressive_scan;
        } else {
            scan = ProresConsts.interlaced_scan;
            if (frameType == 1) {
                topFieldFirst = true;
            }
        }
        byte res2 = inp.get();
        byte prim = inp.get();
        byte transFunc = inp.get();
        byte matrix = inp.get();
        byte pixFmt = inp.get();
        byte res3 = inp.get();
        int flags2 = inp.get() & 0xFF;
        int[] qMatLuma = new int[64];
        int[] qMatChroma = new int[64];
        if (ProresDecoder.hasQMatLuma(flags2)) {
            ProresDecoder.readQMat(inp, qMatLuma, scan);
        } else {
            Arrays.fill(qMatLuma, 4);
        }
        if (ProresDecoder.hasQMatChroma(flags2)) {
            ProresDecoder.readQMat(inp, qMatChroma, scan);
        } else {
            Arrays.fill(qMatChroma, 4);
        }
        inp.position(inp.position() + hdrSize - (20 + (ProresDecoder.hasQMatLuma(flags2) ? 64 : 0) + (ProresDecoder.hasQMatChroma(flags2) ? 64 : 0)));
        return new ProresConsts.FrameHeader(frameSize - hdrSize - 8, width, height, frameType, topFieldFirst, scan, qMatLuma, qMatChroma);
    }

    static final String readSig(ByteBuffer inp) {
        byte[] sig = new byte[4];
        inp.get(sig);
        return new String(sig);
    }

    protected void decodePicture(ByteBuffer data, int[][] result, int width, int height, int mbWidth, int[] qMatLuma, int[] qMatChroma, int[] scan, int pictureType) {
        ProresConsts.PictureHeader ph = ProresDecoder.readPictureHeader(data);
        int mbX = 0;
        int mbY = 0;
        int sliceMbCount = 1 << ph.log2SliceMbWidth;
        for (int i2 = 0; i2 < ph.sliceSizes.length; ++i2) {
            while (mbWidth - mbX < sliceMbCount) {
                sliceMbCount >>= 1;
            }
            this.decodeSlice(data, qMatLuma, qMatChroma, scan, sliceMbCount, mbX, mbY, ph.sliceSizes[i2], result, width, pictureType);
            if ((mbX += sliceMbCount) != mbWidth) continue;
            sliceMbCount = 1 << ph.log2SliceMbWidth;
            mbX = 0;
            ++mbY;
        }
    }

    public static ProresConsts.PictureHeader readPictureHeader(ByteBuffer inp) {
        int hdrSize = (inp.get() & 0xFF) >> 3;
        inp.getInt();
        int sliceCount = inp.getShort();
        int a2 = inp.get() & 0xFF;
        int log2SliceMbWidth = a2 >> 4;
        short[] sliceSizes = new short[sliceCount];
        for (int i2 = 0; i2 < sliceCount; ++i2) {
            sliceSizes[i2] = inp.getShort();
        }
        return new ProresConsts.PictureHeader(log2SliceMbWidth, sliceSizes);
    }

    private void decodeSlice(ByteBuffer data, int[] qMatLuma, int[] qMatChroma, int[] scan, int sliceMbCount, int mbX, int mbY, short sliceSize, int[][] result, int lumaStride, int pictureType) {
        int hdrSize = (data.get() & 0xFF) >> 3;
        int qScale = ProresDecoder.clip(data.get() & 0xFF, 1, 224);
        qScale = qScale > 128 ? qScale - 96 << 2 : qScale;
        short yDataSize = data.getShort();
        short uDataSize = data.getShort();
        int vDataSize = sliceSize - uDataSize - yDataSize - hdrSize;
        int[] y = this.decodeOnePlane(ProresDecoder.bitstream(data, yDataSize), sliceMbCount << 2, ProresDecoder.scaleMat(qMatLuma, qScale), scan, mbX, mbY, 0);
        int[] u = this.decodeOnePlane(ProresDecoder.bitstream(data, uDataSize), sliceMbCount << 1, ProresDecoder.scaleMat(qMatChroma, qScale), scan, mbX, mbY, 1);
        int[] v = this.decodeOnePlane(ProresDecoder.bitstream(data, vDataSize), sliceMbCount << 1, ProresDecoder.scaleMat(qMatChroma, qScale), scan, mbX, mbY, 2);
        this.putSlice(result, lumaStride, mbX, mbY, y, u, v, pictureType == 0 ? 0 : 1, pictureType == 2 ? 1 : 0);
    }

    public static final int[] scaleMat(int[] qMatLuma, int qScale) {
        int[] res = new int[qMatLuma.length];
        for (int i2 = 0; i2 < qMatLuma.length; ++i2) {
            res[i2] = qMatLuma[i2] * qScale;
        }
        return res;
    }

    static final BitReader bitstream(ByteBuffer data, int dataSize) {
        return new BitReader(NIOUtils.read(data, dataSize));
    }

    static final int clip(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    protected void putSlice(int[][] result, int lumaStride, int mbX, int mbY, int[] y, int[] u, int[] v, int dist, int shift) {
        int mbPerSlice = y.length >> 8;
        int chromaStride = lumaStride >> 1;
        this.putLuma(result[0], shift * lumaStride, lumaStride << dist, mbX, mbY, y, mbPerSlice, dist, shift);
        this.putChroma(result[1], shift * chromaStride, chromaStride << dist, mbX, mbY, u, mbPerSlice, dist, shift);
        this.putChroma(result[2], shift * chromaStride, chromaStride << dist, mbX, mbY, v, mbPerSlice, dist, shift);
    }

    private void putLuma(int[] y, int off, int stride, int mbX, int mbY, int[] luma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 4) + (mbY << 4) * stride;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            this.putBlock(y, off, stride, luma, k2 << 8, dist, shift);
            this.putBlock(y, off + 8, stride, luma, (k2 << 8) + 64, dist, shift);
            this.putBlock(y, off + 8 * stride, stride, luma, (k2 << 8) + 128, dist, shift);
            this.putBlock(y, off + 8 * stride + 8, stride, luma, (k2 << 8) + 192, dist, shift);
            off += 16;
        }
    }

    private void putChroma(int[] y, int off, int stride, int mbX, int mbY, int[] chroma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 3) + (mbY << 4) * stride;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            this.putBlock(y, off, stride, chroma, k2 << 7, dist, shift);
            this.putBlock(y, off + 8 * stride, stride, chroma, (k2 << 7) + 64, dist, shift);
            off += 8;
        }
    }

    private void putBlock(int[] square, int sqOff, int sqStride, int[] flat, int flOff, int dist, int shift) {
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                square[j2 + sqOff] = ProresDecoder.clip(flat[j2 + flOff], 4, 1019);
            }
            sqOff += sqStride;
            flOff += 8;
        }
    }

    static final boolean hasQMatChroma(int flags2) {
        return (flags2 & 1) != 0;
    }

    static final void readQMat(ByteBuffer inp, int[] qMatLuma, int[] scan) {
        byte[] b2 = new byte[64];
        inp.get(b2);
        for (int i2 = 0; i2 < 64; ++i2) {
            qMatLuma[i2] = b2[scan[i2]] & 0xFF;
        }
    }

    static final boolean hasQMatLuma(int flags2) {
        return (flags2 & 2) != 0;
    }

    public boolean isProgressive(ByteBuffer data) {
        return ((data.get(20) & 0xFF) >> 2 & 3) == 0;
    }

    @Override
    public int probe(ByteBuffer data) {
        if (data.get(4) == 105 && data.get(5) == 99 && data.get(6) == 112 && data.get(7) == 102) {
            return 100;
        }
        return 0;
    }
}

