/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import org.jcodec.codecs.mpeg12.MPEGConst;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.mpeg12.bitstream.GOPHeader;
import org.jcodec.codecs.mpeg12.bitstream.SequenceHeader;
import org.jcodec.codecs.prores.DCT2Prores;
import org.jcodec.codecs.prores.ProresEncoder;
import org.jcodec.common.dct.DCTRef;
import org.jcodec.common.dct.SimpleIDCT10Bit;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;

public class Mpeg2Prores
extends MPEGDecoder {
    private DCT2Prores dct2Prores;

    public Mpeg2Prores(SequenceHeader sh, GOPHeader gh, ProresEncoder.Profile profile) {
        super(sh, gh);
        this.dct2Prores = new DCT2Prores(profile);
    }

    protected void idctPut(int[] block, int[][] buf, int stride, int chromaFormat, int blkNo, int mbX, int mbY, int dctType) {
        int mbAddr = mbY * (stride >> 4) + mbX;
        int off = blkNo < 4 ? (mbAddr << 8) + (blkNo << 6) : (mbAddr << 5 + chromaFormat) + (blkNo - 4 >> 1 << 6);
        System.arraycopy(block, 0, buf[MPEGConst.BLOCK_TO_CC[blkNo]], off, 64);
        buf[3][mbAddr] = dctType;
    }

    public ByteBuffer transcode(ByteBuffer in, ByteBuffer _out) {
        ByteBuffer out = _out.slice();
        int width = this.sh.horizontal_size + 15 & 0xFFFFFFF0;
        int height = this.sh.vertical_size + 15 & 0xFFFFFFF0;
        int[][] buffer = new int[][]{new int[width * height], new int[width * height], new int[width * height], new int[(width >> 4) * (height >> 4)]};
        Picture dct = this.decodeFrame(in, buffer);
        Picture[] pic = this.convert(dct);
        if (pic.length == 1) {
            this.dct2Prores.encodeFrame(out, pic[0]);
        } else {
            this.dct2Prores.encodeFrame(out, pic[0], pic[1]);
        }
        out.flip();
        return out;
    }

    private Picture[] convert(Picture dct) {
        Picture[] result;
        int nInterlaced = 0;
        for (int i2 : dct.getPlaneData(3)) {
            nInterlaced += i2;
        }
        if (nInterlaced == 0) {
            this.upShift(dct);
            result = new Picture[]{this.colorCvt(dct)};
        } else {
            Picture[] field = this.interlaced(dct);
            result = new Picture[]{this.colorCvt(field[0]), this.colorCvt(field[1])};
        }
        System.out.println(nInterlaced);
        return result;
    }

    private void upShift(Picture dct) {
        for (int[] is : dct.getData()) {
            this.upShift(is, 0, is.length);
        }
    }

    private Picture[] interlaced(Picture dct) {
        int mbWidth = dct.getWidth() + 15 >> 4;
        int mbHeight = dct.getHeight() + 15 >> 4;
        Picture field1 = Picture.create(dct.getWidth(), dct.getHeight() >> 1, dct.getColor());
        Picture field2 = Picture.create(dct.getWidth(), dct.getHeight() >> 1, dct.getColor());
        this.splitY(mbWidth, mbHeight, dct.getPlaneData(0), field1.getPlaneData(0), field2.getPlaneData(0), dct.getPlaneData(3));
        this.splitCbCr(mbWidth, mbHeight, dct.getPlaneData(1), field1.getPlaneData(1), field2.getPlaneData(1), dct.getPlaneData(3));
        this.splitCbCr(mbWidth, mbHeight, dct.getPlaneData(2), field1.getPlaneData(2), field2.getPlaneData(2), dct.getPlaneData(3));
        return new Picture[]{field1, field2};
    }

    private final void splitY(int mbWidth, int mbHeight, int[] y, int[] y1, int[] y2, int[] dctTypes) {
        int dstOff = 0;
        int srcOff = 0;
        int i2 = 0;
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            int mbX = 0;
            while (mbX < mbWidth) {
                if (dctTypes[i2] == 0) {
                    SimpleIDCT10Bit.idct10(y, srcOff);
                    SimpleIDCT10Bit.idct10(y, srcOff + 64);
                    SimpleIDCT10Bit.idct10(y, srcOff + 128);
                    SimpleIDCT10Bit.idct10(y, srcOff + 192);
                    this.deinterleave(y, srcOff, srcOff + 128, y1, y2, dstOff);
                    this.deinterleave(y, srcOff + 64, srcOff + 192, y1, y2, dstOff + 64);
                    DCTRef.fdct(y1, dstOff);
                    DCTRef.fdct(y1, dstOff + 64);
                    DCTRef.fdct(y2, dstOff);
                    DCTRef.fdct(y2, dstOff + 64);
                } else {
                    this.copyShift(y, srcOff, y1, dstOff, 128);
                    this.copyShift(y, srcOff + 128, y2, dstOff, 128);
                }
                ++mbX;
                ++i2;
                dstOff += 256;
                srcOff += 256;
            }
            if ((mbY & 1) == 0) {
                dstOff -= (mbWidth << 8) - 128;
                continue;
            }
            dstOff -= 128;
        }
    }

    private final void copyShift(int[] src, int srcOff, int[] dst, int dstOff, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            src[srcOff++] = dst[dstOff++] << 2;
        }
    }

    private final void splitCbCr(int mbWidth, int mbHeight, int[] y, int[] y1, int[] y2, int[] dctTypes) {
        int dstOff = 0;
        int srcOff = 0;
        int i2 = 0;
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            int mbX = 0;
            while (mbX < mbWidth) {
                if (dctTypes[i2] == 0) {
                    SimpleIDCT10Bit.idct10(y, srcOff);
                    SimpleIDCT10Bit.idct10(y, srcOff + 64);
                    this.deinterleave(y, srcOff, srcOff + 64, y1, y2, dstOff);
                    DCTRef.fdct(y1, dstOff);
                    DCTRef.fdct(y2, dstOff);
                } else {
                    this.copyShift(y, srcOff, y1, dstOff, 64);
                    this.copyShift(y, srcOff + 64, y2, dstOff, 64);
                }
                ++mbX;
                ++i2;
                dstOff += 128;
                srcOff += 128;
            }
            if ((mbY & 1) == 0) {
                dstOff -= (mbWidth << 7) - 64;
                continue;
            }
            dstOff -= 64;
        }
    }

    private void deinterleave(int[] y, int topOff, int botOff, int[] y1, int[] y2, int blkOff) {
        this.copyLine(y, y1, topOff + 0, blkOff + 0);
        this.copyLine(y, y1, topOff + 16, blkOff + 8);
        this.copyLine(y, y1, topOff + 32, blkOff + 16);
        this.copyLine(y, y1, topOff + 48, blkOff + 24);
        this.copyLine(y, y1, botOff + 0, blkOff + 32);
        this.copyLine(y, y1, botOff + 16, blkOff + 40);
        this.copyLine(y, y1, botOff + 32, blkOff + 48);
        this.copyLine(y, y1, botOff + 48, blkOff + 56);
        this.copyLine(y, y2, topOff + 8, blkOff + 0);
        this.copyLine(y, y2, topOff + 24, blkOff + 8);
        this.copyLine(y, y2, topOff + 40, blkOff + 16);
        this.copyLine(y, y2, topOff + 56, blkOff + 24);
        this.copyLine(y, y2, botOff + 8, blkOff + 32);
        this.copyLine(y, y2, botOff + 24, blkOff + 40);
        this.copyLine(y, y2, botOff + 40, blkOff + 48);
        this.copyLine(y, y2, botOff + 56, blkOff + 56);
    }

    private Picture progressive(Picture dct) {
        this.progressiveY(dct.getPlaneData(0), dct.getPlaneData(3));
        this.progressiveCbCr(dct.getPlaneData(0), dct.getPlaneData(3));
        this.progressiveCbCr(dct.getPlaneData(0), dct.getPlaneData(3));
        return dct;
    }

    private void progressiveY(int[] y, int[] dctTypes) {
        for (int i2 = 0; i2 < dctTypes.length; ++i2) {
            if (dctTypes[i2] == 1) {
                SimpleIDCT10Bit.idct10(y, (i2 << 8) + 0);
                SimpleIDCT10Bit.idct10(y, (i2 << 8) + 64);
                SimpleIDCT10Bit.idct10(y, (i2 << 8) + 128);
                SimpleIDCT10Bit.idct10(y, (i2 << 8) + 192);
                this.interleave(y, (i2 << 8) + 0, (i2 << 8) + 128);
                this.interleave(y, (i2 << 8) + 64, (i2 << 8) + 192);
                DCTRef.fdct(y, (i2 << 8) + 0);
                DCTRef.fdct(y, (i2 << 8) + 64);
                DCTRef.fdct(y, (i2 << 8) + 128);
                DCTRef.fdct(y, (i2 << 8) + 192);
                continue;
            }
            this.upShift(y, i2 << 8, 256);
        }
    }

    private void upShift(int[] y, int off, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = off++;
            y[n2] = y[n2] << 2;
        }
    }

    private void progressiveCbCr(int[] y, int[] dctTypes) {
        for (int i2 = 0; i2 < dctTypes.length; ++i2) {
            if (dctTypes[i2] == 1) {
                SimpleIDCT10Bit.idct10(y, (i2 << 7) + 0);
                SimpleIDCT10Bit.idct10(y, (i2 << 7) + 64);
                this.interleave(y, (i2 << 7) + 0, (i2 << 7) + 64);
                DCTRef.fdct(y, (i2 << 7) + 0);
                DCTRef.fdct(y, (i2 << 7) + 64);
                continue;
            }
            this.upShift(y, i2 << 7, 128);
        }
    }

    private void interleave(int[] y, int off1, int off2) {
        int[] tmp = new int[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            tmp[i2] = y[off2 + i2];
        }
        this.copyLine(y, y, off1 + 56, off2 + 48);
        this.copyLine(y, y, off1 + 48, off2 + 32);
        this.copyLine(y, y, off1 + 40, off2 + 16);
        this.copyLine(y, y, off1 + 32, off2);
        this.copyLine(y, y, off1 + 24, off1 + 48);
        this.copyLine(y, y, off1 + 16, off1 + 32);
        this.copyLine(y, y, off1 + 8, off1 + 16);
        this.copyLine(tmp, y, 0, off1 + 8);
        this.copyLine(tmp, y, 8, off1 + 24);
        this.copyLine(tmp, y, 16, off1 + 40);
        this.copyLine(tmp, y, 24, off1 + 56);
        this.copyLine(tmp, y, 32, off2 + 8);
        this.copyLine(tmp, y, 40, off2 + 24);
        this.copyLine(tmp, y, 48, off2 + 40);
    }

    private final void copyLine(int[] from, int[] to, int offFrom, int offTo) {
        for (int i2 = 0; i2 < 8; ++i2) {
            to[offTo++] = from[offFrom++];
        }
    }

    private Picture colorCvt(Picture in) {
        Picture out;
        if (in.getColor() == ColorSpace.YUV422_10) {
            out = in;
        } else {
            Transform trans = ColorUtil.getTransform(in.getColor(), ColorSpace.YUV422_10);
            out = Picture.create(in.getWidth(), in.getHeight(), ColorSpace.YUV422_10);
            trans.transform(in, out);
        }
        return out;
    }
}

