/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12.bitstream;

import java.nio.ByteBuffer;
import org.jcodec.codecs.mpeg12.bitstream.SequenceDisplayExtension;
import org.jcodec.codecs.mpeg12.bitstream.SequenceExtension;
import org.jcodec.codecs.mpeg12.bitstream.SequenceScalableExtension;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class SequenceHeader {
    public static final int Sequence_Extension = 1;
    public static final int Sequence_Display_Extension = 2;
    public static final int Sequence_Scalable_Extension = 5;
    private static boolean hasExtensions;
    public int horizontal_size;
    public int vertical_size;
    public int aspect_ratio_information;
    public int frame_rate_code;
    public int bit_rate;
    public int marker_bit;
    public int vbv_buffer_size_value;
    public int constrained_parameters_flag;
    public int[] intra_quantiser_matrix;
    public int[] non_intra_quantiser_matrix;
    public SequenceExtension sequenceExtension;
    public SequenceScalableExtension sequenceScalableExtension;
    public SequenceDisplayExtension sequenceDisplayExtension;

    public static SequenceHeader read(ByteBuffer bb) {
        int i2;
        BitReader in = new BitReader(bb);
        SequenceHeader sh = new SequenceHeader();
        sh.horizontal_size = in.readNBit(12);
        sh.vertical_size = in.readNBit(12);
        sh.aspect_ratio_information = in.readNBit(4);
        sh.frame_rate_code = in.readNBit(4);
        sh.bit_rate = in.readNBit(18);
        sh.marker_bit = in.read1Bit();
        sh.vbv_buffer_size_value = in.readNBit(10);
        sh.constrained_parameters_flag = in.read1Bit();
        if (in.read1Bit() != 0) {
            sh.intra_quantiser_matrix = new int[64];
            for (i2 = 0; i2 < 64; ++i2) {
                sh.intra_quantiser_matrix[i2] = in.readNBit(8);
            }
        }
        if (in.read1Bit() != 0) {
            sh.non_intra_quantiser_matrix = new int[64];
            for (i2 = 0; i2 < 64; ++i2) {
                sh.non_intra_quantiser_matrix[i2] = in.readNBit(8);
            }
        }
        return sh;
    }

    public static void readExtension(ByteBuffer bb, SequenceHeader sh) {
        hasExtensions = true;
        BitReader in = new BitReader(bb);
        int extType = in.readNBit(4);
        switch (extType) {
            case 1: {
                sh.sequenceExtension = SequenceExtension.read(in);
                break;
            }
            case 5: {
                sh.sequenceScalableExtension = SequenceScalableExtension.read(in);
                break;
            }
            case 2: {
                sh.sequenceDisplayExtension = SequenceDisplayExtension.read(in);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported extension: " + extType);
            }
        }
    }

    public void write(ByteBuffer os) {
        int i2;
        BitWriter out = new BitWriter(os);
        out.writeNBit(this.horizontal_size, 12);
        out.writeNBit(this.vertical_size, 12);
        out.writeNBit(this.aspect_ratio_information, 4);
        out.writeNBit(this.frame_rate_code, 4);
        out.writeNBit(this.bit_rate, 18);
        out.write1Bit(this.marker_bit);
        out.writeNBit(this.vbv_buffer_size_value, 10);
        out.write1Bit(this.constrained_parameters_flag);
        out.write1Bit(this.intra_quantiser_matrix != null ? 1 : 0);
        if (this.intra_quantiser_matrix != null) {
            for (i2 = 0; i2 < 64; ++i2) {
                out.writeNBit(this.intra_quantiser_matrix[i2], 8);
            }
        }
        out.write1Bit(this.non_intra_quantiser_matrix != null ? 1 : 0);
        if (this.non_intra_quantiser_matrix != null) {
            for (i2 = 0; i2 < 64; ++i2) {
                out.writeNBit(this.non_intra_quantiser_matrix[i2], 8);
            }
        }
        this.writeExtensions(os);
    }

    private void writeExtensions(ByteBuffer out) {
        BitWriter os;
        if (this.sequenceExtension != null) {
            out.putInt(181);
            os = new BitWriter(out);
            os.writeNBit(1, 4);
            this.sequenceExtension.write(os);
        }
        if (this.sequenceScalableExtension != null) {
            out.putInt(181);
            os = new BitWriter(out);
            os.writeNBit(5, 4);
            this.sequenceScalableExtension.write(os);
        }
        if (this.sequenceDisplayExtension != null) {
            out.putInt(181);
            os = new BitWriter(out);
            os.writeNBit(2, 4);
            this.sequenceDisplayExtension.write(os);
        }
    }

    public boolean hasExtensions() {
        return hasExtensions;
    }

    public void copyExtensions(SequenceHeader sh) {
        this.sequenceExtension = sh.sequenceExtension;
        this.sequenceScalableExtension = sh.sequenceScalableExtension;
        this.sequenceDisplayExtension = sh.sequenceDisplayExtension;
    }
}

