/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12.bitstream;

import java.io.IOException;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class QuantMatrixExtension {
    public int[] intra_quantiser_matrix;
    public int[] non_intra_quantiser_matrix;
    public int[] chroma_intra_quantiser_matrix;
    public int[] chroma_non_intra_quantiser_matrix;

    public static QuantMatrixExtension read(BitReader in) {
        QuantMatrixExtension qme = new QuantMatrixExtension();
        if (in.read1Bit() != 0) {
            qme.intra_quantiser_matrix = QuantMatrixExtension.readQMat(in);
        }
        if (in.read1Bit() != 0) {
            qme.non_intra_quantiser_matrix = QuantMatrixExtension.readQMat(in);
        }
        if (in.read1Bit() != 0) {
            qme.chroma_intra_quantiser_matrix = QuantMatrixExtension.readQMat(in);
        }
        if (in.read1Bit() != 0) {
            qme.chroma_non_intra_quantiser_matrix = QuantMatrixExtension.readQMat(in);
        }
        return qme;
    }

    private static int[] readQMat(BitReader in) {
        int[] qmat = new int[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            qmat[i2] = in.readNBit(8);
        }
        return qmat;
    }

    public void write(BitWriter ob) throws IOException {
        ob.write1Bit(this.intra_quantiser_matrix != null ? 1 : 0);
        if (this.intra_quantiser_matrix != null) {
            this.writeQMat(this.intra_quantiser_matrix, ob);
        }
        ob.write1Bit(this.non_intra_quantiser_matrix != null ? 1 : 0);
        if (this.non_intra_quantiser_matrix != null) {
            this.writeQMat(this.non_intra_quantiser_matrix, ob);
        }
        ob.write1Bit(this.chroma_intra_quantiser_matrix != null ? 1 : 0);
        if (this.chroma_intra_quantiser_matrix != null) {
            this.writeQMat(this.chroma_intra_quantiser_matrix, ob);
        }
        ob.write1Bit(this.chroma_non_intra_quantiser_matrix != null ? 1 : 0);
        if (this.chroma_non_intra_quantiser_matrix != null) {
            this.writeQMat(this.chroma_non_intra_quantiser_matrix, ob);
        }
    }

    private void writeQMat(int[] matrix, BitWriter ob) throws IOException {
        for (int i2 = 0; i2 < 64; ++i2) {
            ob.writeNBit(matrix[i2], 8);
        }
    }
}

