/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jcodec.common.NIOUtils;

public class SegmentReader {
    private ReadableByteChannel channel;
    private ByteBuffer buf;
    protected int curMarker;
    private int fetchSize;
    private boolean done;
    private long pos;

    public SegmentReader(ReadableByteChannel channel) throws IOException {
        this(channel, 4096);
    }

    public SegmentReader(ReadableByteChannel channel, int fetchSize) throws IOException {
        this.channel = channel;
        this.fetchSize = fetchSize;
        this.buf = NIOUtils.fetchFrom(channel, 4);
        this.pos = this.buf.remaining();
        this.curMarker = this.buf.getInt();
    }

    public final boolean readToNextMarker(ByteBuffer out) throws IOException {
        if (this.done) {
            return false;
        }
        int n2 = 1;
        while (true) {
            if (this.buf.hasRemaining()) {
                if (this.curMarker >= 256 && this.curMarker <= 511) {
                    if (n2 == 0) {
                        return true;
                    }
                    --n2;
                }
                out.put((byte)(this.curMarker >>> 24));
                this.curMarker = this.curMarker << 8 | this.buf.get() & 0xFF;
                continue;
            }
            this.buf = NIOUtils.fetchFrom(this.channel, this.fetchSize);
            this.pos += (long)this.buf.remaining();
            if (!this.buf.hasRemaining()) break;
        }
        out.putInt(this.curMarker);
        this.done = true;
        return false;
    }

    public final boolean skipToMarker() throws IOException {
        if (this.done) {
            return false;
        }
        while (true) {
            if (this.buf.hasRemaining()) {
                if (this.curMarker >= 256 && this.curMarker <= 511) {
                    return true;
                }
                this.curMarker = this.curMarker << 8 | this.buf.get() & 0xFF;
                continue;
            }
            this.buf = NIOUtils.fetchFrom(this.channel, this.fetchSize);
            this.pos += (long)this.buf.remaining();
            if (!this.buf.hasRemaining()) break;
        }
        this.done = true;
        return false;
    }

    public final boolean read(ByteBuffer out, int length) throws IOException {
        if (this.done) {
            return false;
        }
        while (true) {
            if (this.buf.hasRemaining()) {
                if (length-- == 0) {
                    return true;
                }
                out.put((byte)(this.curMarker >>> 24));
                this.curMarker = this.curMarker << 8 | this.buf.get() & 0xFF;
                continue;
            }
            this.buf = NIOUtils.fetchFrom(this.channel, this.fetchSize);
            this.pos += (long)this.buf.remaining();
            if (!this.buf.hasRemaining()) break;
        }
        out.putInt(this.curMarker);
        this.done = true;
        return false;
    }

    public final long curPos() {
        return this.pos - (long)this.buf.remaining() - 4L;
    }
}

