/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodec.codecs.mpeg12.MPEGConst;
import org.jcodec.codecs.mpeg12.MPEGPred;
import org.jcodec.codecs.mpeg12.MPEGUtil;
import org.jcodec.codecs.mpeg12.bitstream.GOPHeader;
import org.jcodec.codecs.mpeg12.bitstream.PictureHeader;
import org.jcodec.codecs.mpeg12.bitstream.SequenceHeader;
import org.jcodec.common.Assert;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.dct.SparseIDCT;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.VLC;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;

public class MPEGDecoder
implements VideoDecoder {
    protected SequenceHeader sh;
    protected GOPHeader gh;
    private int maxCoeff;
    private Picture[] refFrames = new Picture[2];
    private Picture[] refFields = new Picture[2];

    public MPEGDecoder(SequenceHeader sh, GOPHeader gh) {
        this.sh = sh;
        this.gh = gh;
    }

    public MPEGDecoder() {
        this(64);
    }

    public MPEGDecoder(int maxCoeff) {
        this.maxCoeff = maxCoeff;
    }

    @Override
    public Picture decodeFrame(ByteBuffer ByteBuffer2, int[][] buf) {
        PictureHeader ph = this.readHeader(ByteBuffer2);
        if (this.refFrames[0] == null && ph.picture_coding_type > 1 || this.refFrames[1] == null && ph.picture_coding_type > 2) {
            throw new RuntimeException("Not enough references to decode " + (ph.picture_coding_type == 1 ? "P" : "B") + " frame");
        }
        Context context = this.initContext(this.sh, ph);
        Picture pic = new Picture(context.codedWidth, context.codedHeight, buf, context.color, new Rect(0, 0, this.sh.horizontal_size, this.sh.vertical_size));
        if (ph.pictureCodingExtension != null && ph.pictureCodingExtension.picture_structure != 3) {
            this.decodePicture(context, ph, ByteBuffer2, buf, ph.pictureCodingExtension.picture_structure - 1, 1);
            ph = this.readHeader(ByteBuffer2);
            context = this.initContext(this.sh, ph);
            this.decodePicture(context, ph, ByteBuffer2, buf, ph.pictureCodingExtension.picture_structure - 1, 1);
        } else {
            this.decodePicture(context, ph, ByteBuffer2, buf, 0, 0);
        }
        if (ph.picture_coding_type == 1 || ph.picture_coding_type == 2) {
            Picture unused = this.refFrames[1];
            this.refFrames[1] = this.refFrames[0];
            this.refFrames[0] = this.copyAndCreateIfNeeded(pic, unused);
        }
        return pic;
    }

    private Picture copyAndCreateIfNeeded(Picture src, Picture dst) {
        if (dst == null || !dst.compatible(src)) {
            dst = src.createCompatible();
        }
        dst.copyFrom(src);
        return dst;
    }

    private PictureHeader readHeader(ByteBuffer buffer) {
        ByteBuffer segment;
        PictureHeader ph = null;
        block7: while ((segment = MPEGUtil.nextSegment(buffer)) != null) {
            byte code = segment.get(3);
            segment.position(4);
            switch (code) {
                case 179: {
                    SequenceHeader newSh = SequenceHeader.read(segment);
                    if (this.sh != null) {
                        newSh.copyExtensions(this.sh);
                    }
                    this.sh = newSh;
                    continue block7;
                }
                case 184: {
                    this.gh = GOPHeader.read(segment);
                    continue block7;
                }
                case 0: {
                    ph = PictureHeader.read(segment);
                    continue block7;
                }
                case 181: {
                    int extType = segment.get(4) >> 4;
                    if (extType == 1 || extType == 5 || extType == 2) {
                        SequenceHeader.readExtension(segment, this.sh);
                        continue block7;
                    }
                    PictureHeader.readExtension(segment, ph, this.sh);
                    continue block7;
                }
                case 178: {
                    continue block7;
                }
            }
            buffer.reset();
        }
        return ph;
    }

    private Context initContext(SequenceHeader sh, PictureHeader ph) {
        Context context = new Context();
        context.codedWidth = sh.horizontal_size + 15 & 0xFFFFFFF0;
        context.codedHeight = MPEGDecoder.getCodedHeight(sh, ph);
        context.mbWidth = sh.horizontal_size + 15 >> 4;
        context.mbHeight = sh.vertical_size + 15 >> 4;
        int chromaFormat = 1;
        if (sh.sequenceExtension != null) {
            chromaFormat = sh.sequenceExtension.chroma_format;
        }
        context.color = this.getColor(chromaFormat);
        context.scan = MPEGConst.scan[ph.pictureCodingExtension == null ? 0 : ph.pictureCodingExtension.alternate_scan];
        int[] inter = sh.non_intra_quantiser_matrix == null ? this.zigzag(MPEGConst.defaultQMatInter, context.scan) : sh.non_intra_quantiser_matrix;
        int[] intra = sh.intra_quantiser_matrix == null ? this.zigzag(MPEGConst.defaultQMatIntra, context.scan) : sh.intra_quantiser_matrix;
        context.qMats = new int[][]{inter, inter, intra, intra};
        if (ph.quantMatrixExtension != null) {
            if (ph.quantMatrixExtension.non_intra_quantiser_matrix != null) {
                context.qMats[0] = ph.quantMatrixExtension.non_intra_quantiser_matrix;
            }
            if (ph.quantMatrixExtension.chroma_non_intra_quantiser_matrix != null) {
                context.qMats[1] = ph.quantMatrixExtension.chroma_non_intra_quantiser_matrix;
            }
            if (ph.quantMatrixExtension.intra_quantiser_matrix != null) {
                context.qMats[2] = ph.quantMatrixExtension.intra_quantiser_matrix;
            }
            if (ph.quantMatrixExtension.chroma_intra_quantiser_matrix != null) {
                context.qMats[3] = ph.quantMatrixExtension.chroma_intra_quantiser_matrix;
            }
        }
        return context;
    }

    private int[] zigzag(int[] array, int[] scan) {
        int[] result = new int[64];
        for (int i2 = 0; i2 < scan.length; ++i2) {
            result[i2] = array[scan[i2]];
        }
        return result;
    }

    public static int getCodedHeight(SequenceHeader sh, PictureHeader ph) {
        int field = ph.pictureCodingExtension != null && ph.pictureCodingExtension.picture_structure != 3 ? 1 : 0;
        return ((sh.vertical_size >> field) + 15 & 0xFFFFFFF0) << field;
    }

    public Picture decodePicture(Context context, PictureHeader ph, ByteBuffer buffer, int[][] buf, int vertOff, int vertStep) {
        int planeSize = context.codedWidth * context.codedHeight;
        if (buf.length < 3 || buf[0].length < planeSize || buf[1].length < planeSize || buf[2].length < planeSize) {
            throw new RuntimeException("ByteBuffer too small to hold output picture [" + context.codedWidth + "x" + context.codedHeight + "]");
        }
        try {
            ByteBuffer segment;
            while ((segment = MPEGUtil.nextSegment(buffer)) != null) {
                if (segment.get(3) >= 1 && segment.get(3) <= 175) {
                    segment.position(4);
                    try {
                        this.decodeSlice(ph, segment.get(3) & 0xFF, context, buf, new BitReader(segment), vertOff, vertStep);
                    }
                    catch (RuntimeException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                if (segment.get(3) >= 179 && segment.get(3) != 182 && segment.get(3) != 183) {
                    throw new RuntimeException("Unexpected start code " + segment.get(3));
                }
                if (segment.get(3) != 0) continue;
                buffer.reset();
                break;
            }
            Picture pic = new Picture(context.codedWidth, context.codedHeight, buf, context.color);
            if ((ph.picture_coding_type == 1 || ph.picture_coding_type == 2) && ph.pictureCodingExtension != null && ph.pictureCodingExtension.picture_structure != 3) {
                this.refFields[ph.pictureCodingExtension.picture_structure - 1] = this.copyAndCreateIfNeeded(pic, this.refFields[ph.pictureCodingExtension.picture_structure - 1]);
            }
            return pic;
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private ColorSpace getColor(int chromaFormat) {
        switch (chromaFormat) {
            case 1: {
                return ColorSpace.YUV420;
            }
            case 2: {
                return ColorSpace.YUV422;
            }
            case 3: {
                return ColorSpace.YUV444;
            }
        }
        return null;
    }

    public void decodeSlice(PictureHeader ph, int verticalPos, Context context, int[][] buf, BitReader in, int vertOff, int vertStep) throws IOException {
        Object object;
        int stride = context.codedWidth;
        this.resetDCPredictors(context, ph);
        int mbRow = verticalPos - 1;
        if (this.sh.vertical_size > 2800) {
            mbRow += in.readNBit(3) << 7;
        }
        if (this.sh.sequenceScalableExtension != null && this.sh.sequenceScalableExtension.scalable_mode == 0) {
            int priorityBreakpoint = in.readNBit(7);
        }
        int qScaleCode = in.readNBit(5);
        if (in.read1Bit() == 1) {
            int intraSlice = in.read1Bit();
            in.skip(7);
            while (in.read1Bit() == 1) {
                in.readNBit(8);
            }
        }
        if (ph.pictureCodingExtension != null) {
            object = ph.pictureCodingExtension.f_code;
        } else {
            int[][] nArrayArray = new int[2][];
            nArrayArray[0] = new int[]{ph.forward_f_code, ph.forward_f_code};
            object = nArrayArray;
            nArrayArray[1] = new int[]{ph.backward_f_code, ph.backward_f_code};
        }
        MPEGPred pred = new MPEGPred((int[][])object, this.sh.sequenceExtension != null ? this.sh.sequenceExtension.chroma_format : 1, ph.pictureCodingExtension == null || ph.pictureCodingExtension.top_field_first != 0);
        int[] ctx = new int[]{qScaleCode};
        int prevAddr = mbRow * context.mbWidth - 1;
        while (in.checkNBit(23) != 0) {
            prevAddr = this.decodeMacroblock(ph, context, prevAddr, ctx, buf, stride, in, vertOff, vertStep, pred);
            ++context.mbNo;
        }
    }

    private void resetDCPredictors(Context context, PictureHeader ph) {
        int rval = 128;
        if (ph.pictureCodingExtension != null) {
            rval = 1 << 7 + ph.pictureCodingExtension.intra_dc_precision;
        }
        context.intra_dc_predictor[1] = context.intra_dc_predictor[2] = rval;
        context.intra_dc_predictor[0] = context.intra_dc_predictor[2];
    }

    public int decodeMacroblock(PictureHeader ph, Context context, int prevAddr, int[] qScaleCode, int[][] buf, int stride, BitReader bits, int vertOff, int vertStep, MPEGPred pred) {
        int cbp;
        int[][] pp;
        Object object;
        int mbAddr = prevAddr;
        while (bits.checkNBit(11) == 8) {
            bits.skip(11);
            mbAddr += 33;
        }
        mbAddr += MPEGConst.vlcAddressIncrement.readVLC(bits) + 1;
        int chromaFormat = 1;
        if (this.sh.sequenceExtension != null) {
            chromaFormat = this.sh.sequenceExtension.chroma_format;
        }
        for (int i2 = prevAddr + 1; i2 < mbAddr; ++i2) {
            int[][] predFwd = new int[][]{new int[256], new int[1 << chromaFormat + 5], new int[1 << chromaFormat + 5]};
            int mbX = i2 % context.mbWidth;
            int mbY = i2 / context.mbWidth;
            if (ph.picture_coding_type == 2) {
                pred.reset();
            }
            this.mvZero(context, ph, pred, mbX, mbY, predFwd);
            this.put(predFwd, buf, stride, chromaFormat, mbX, mbY, context.codedWidth, context.codedHeight >> vertStep, vertOff, vertStep);
        }
        VLC vlcMBType = MPEGConst.vlcMBType(ph.picture_coding_type, this.sh.sequenceScalableExtension);
        MPEGConst.MBType[] mbTypeVal = MPEGConst.mbTypeVal(ph.picture_coding_type, this.sh.sequenceScalableExtension);
        MPEGConst.MBType mbType = mbTypeVal[vlcMBType.readVLC(bits)];
        if (mbType.macroblock_intra != 1 || mbAddr - prevAddr > 1) {
            this.resetDCPredictors(context, ph);
        }
        int spatial_temporal_weight_code = 0;
        if (mbType.spatial_temporal_weight_code_flag == 1 && ph.pictureSpatialScalableExtension != null && ph.pictureSpatialScalableExtension.spatial_temporal_weight_code_table_index != 0) {
            spatial_temporal_weight_code = bits.readNBit(2);
        }
        int motion_type = -1;
        if (mbType.macroblock_motion_forward != 0 || mbType.macroblock_motion_backward != 0) {
            motion_type = ph.pictureCodingExtension == null || ph.pictureCodingExtension.picture_structure == 3 && ph.pictureCodingExtension.frame_pred_frame_dct == 1 ? 2 : bits.readNBit(2);
        }
        int dctType = 0;
        if (ph.pictureCodingExtension != null && ph.pictureCodingExtension.picture_structure == 3 && ph.pictureCodingExtension.frame_pred_frame_dct == 0 && (mbType.macroblock_intra != 0 || mbType.macroblock_pattern != 0)) {
            dctType = bits.read1Bit();
        }
        if (mbType.macroblock_quant != 0) {
            qScaleCode[0] = bits.readNBit(5);
        }
        boolean concealmentMv = ph.pictureCodingExtension != null && ph.pictureCodingExtension.concealment_motion_vectors != 0;
        Object predFwd = null;
        int mbX = mbAddr % context.mbWidth;
        int mbY = mbAddr / context.mbWidth;
        if (mbType.macroblock_intra == 1) {
            if (!concealmentMv) {
                pred.reset();
            }
        } else if (mbType.macroblock_motion_forward != 0) {
            int refIdx = ph.picture_coding_type == 2 ? 0 : 1;
            predFwd = new int[][]{new int[256], new int[1 << chromaFormat + 5], new int[1 << chromaFormat + 5]};
            if (ph.pictureCodingExtension == null || ph.pictureCodingExtension.picture_structure == 3) {
                pred.predictInFrame(this.refFrames[refIdx], mbX << 4, mbY << 4, (int[][])predFwd, bits, motion_type, 0, spatial_temporal_weight_code);
            } else if (ph.picture_coding_type == 2) {
                pred.predictInField(this.refFields, mbX << 4, mbY << 4, (int[][])predFwd, bits, motion_type, 0, ph.pictureCodingExtension.picture_structure - 1);
            } else {
                pred.predictInField(new Picture[]{this.refFrames[refIdx], this.refFrames[refIdx]}, mbX << 4, mbY << 4, (int[][])predFwd, bits, motion_type, 0, ph.pictureCodingExtension.picture_structure - 1);
            }
        } else if (ph.picture_coding_type == 2) {
            predFwd = new int[][]{new int[256], new int[1 << chromaFormat + 5], new int[1 << chromaFormat + 5]};
            pred.reset();
            this.mvZero(context, ph, pred, mbX, mbY, (int[][])predFwd);
        }
        Object predBack = null;
        if (mbType.macroblock_motion_backward != 0) {
            predBack = new int[][]{new int[256], new int[1 << chromaFormat + 5], new int[1 << chromaFormat + 5]};
            if (ph.pictureCodingExtension == null || ph.pictureCodingExtension.picture_structure == 3) {
                pred.predictInFrame(this.refFrames[0], mbX << 4, mbY << 4, (int[][])predBack, bits, motion_type, 1, spatial_temporal_weight_code);
            } else {
                pred.predictInField(new Picture[]{this.refFrames[0], this.refFrames[0]}, mbX << 4, mbY << 4, (int[][])predBack, bits, motion_type, 1, ph.pictureCodingExtension.picture_structure - 1);
            }
        }
        context.lastPredB = mbType;
        if (mbType.macroblock_intra == 1) {
            int[][] nArrayArray = new int[3][];
            nArrayArray[0] = new int[256];
            nArrayArray[1] = new int[1 << chromaFormat + 5];
            object = nArrayArray;
            nArrayArray[2] = new int[1 << chromaFormat + 5];
        } else {
            object = pp = MPEGDecoder.buildPred(predFwd, predBack);
        }
        if (mbType.macroblock_intra != 0 && concealmentMv) {
            Assert.assertEquals(1, bits.read1Bit());
        }
        int n2 = cbp = mbType.macroblock_intra == 1 ? 4095 : 0;
        if (mbType.macroblock_pattern != 0) {
            cbp = this.readCbPattern(bits);
        }
        VLC vlcCoeff = MPEGConst.vlcCoeff0;
        if (ph.pictureCodingExtension != null && mbType.macroblock_intra == 1 && ph.pictureCodingExtension.intra_vlc_format == 1) {
            vlcCoeff = MPEGConst.vlcCoeff1;
        }
        int[] qScaleTab = ph.pictureCodingExtension != null && ph.pictureCodingExtension.q_scale_type == 1 ? MPEGConst.qScaleTab2 : MPEGConst.qScaleTab1;
        int qScale = qScaleTab[qScaleCode[0]];
        int intra_dc_mult = 8;
        if (ph.pictureCodingExtension != null) {
            intra_dc_mult = 8 >> ph.pictureCodingExtension.intra_dc_precision;
        }
        int blkCount = 6 + (chromaFormat == 1 ? 0 : (chromaFormat == 2 ? 2 : 6));
        int[] block = new int[64];
        int i3 = 0;
        int cbpMask = 1 << blkCount - 1;
        while (i3 < blkCount) {
            if ((cbp & cbpMask) != 0) {
                int[] qmat = context.qMats[(i3 >= 4 ? 1 : 0) + (mbType.macroblock_intra << 1)];
                if (mbType.macroblock_intra == 1) {
                    this.blockIntra(bits, vlcCoeff, pp[MPEGConst.BLOCK_TO_CC[i3]], context.intra_dc_predictor, i3, context.scan, this.sh.hasExtensions() || ph.hasExtensions() ? 12 : 8, intra_dc_mult, qScale, qmat);
                } else {
                    this.blockInter(bits, vlcCoeff, pp[MPEGConst.BLOCK_TO_CC[i3]], context.scan, this.sh.hasExtensions() || ph.hasExtensions() ? 12 : 8, qScale, qmat);
                }
                this.mapBlock(block, pp[MPEGConst.BLOCK_TO_CC[i3]], i3, dctType, chromaFormat);
            }
            ++i3;
            cbpMask >>= 1;
        }
        this.put(pp, buf, stride, chromaFormat, mbX, mbY, context.codedWidth, context.codedHeight >> vertStep, vertOff, vertStep);
        return mbAddr;
    }

    private void mapBlock(int[] block, int[] out, int blkIdx, int dctType, int chromaFormat) {
        int stepVert = chromaFormat == 1 && (blkIdx == 4 || blkIdx == 5) ? 0 : dctType;
        int log2stride = blkIdx < 4 ? 4 : 4 - MPEGConst.SQUEEZE_X[chromaFormat];
        int blkIdxExt = blkIdx + (dctType << 4);
        int x = MPEGConst.BLOCK_POS_X[blkIdxExt];
        int y = MPEGConst.BLOCK_POS_Y[blkIdxExt];
        int off = (y << log2stride) + x;
        int stride = 1 << log2stride + stepVert;
        int i2 = 0;
        int coeff = 0;
        while (i2 < 8) {
            int n2 = off;
            out[n2] = out[n2] + block[coeff];
            int n3 = off + 1;
            out[n3] = out[n3] + block[coeff + 1];
            int n4 = off + 2;
            out[n4] = out[n4] + block[coeff + 2];
            int n5 = off + 3;
            out[n5] = out[n5] + block[coeff + 3];
            int n6 = off + 4;
            out[n6] = out[n6] + block[coeff + 4];
            int n7 = off + 5;
            out[n7] = out[n7] + block[coeff + 5];
            int n8 = off + 6;
            out[n8] = out[n8] + block[coeff + 6];
            int n9 = off + 7;
            out[n9] = out[n9] + block[coeff + 7];
            off += stride;
            ++i2;
            coeff += 8;
        }
    }

    private static final int[][] buildPred(int[][] predFwd, int[][] predBack) {
        if (predFwd != null && predBack != null) {
            MPEGDecoder.avgPred(predFwd, predBack);
            return predFwd;
        }
        if (predFwd != null) {
            return predFwd;
        }
        if (predBack != null) {
            return predBack;
        }
        throw new RuntimeException("Omited pred in B-frames --> invalid");
    }

    private static final void avgPred(int[][] predFwd, int[][] predBack) {
        for (int i2 = 0; i2 < predFwd.length; ++i2) {
            for (int j2 = 0; j2 < predFwd[i2].length; j2 += 4) {
                predFwd[i2][j2] = predFwd[i2][j2] + predBack[i2][j2] + 1 >> 1;
                predFwd[i2][j2 + 1] = predFwd[i2][j2 + 1] + predBack[i2][j2 + 1] + 1 >> 1;
                predFwd[i2][j2 + 2] = predFwd[i2][j2 + 2] + predBack[i2][j2 + 2] + 1 >> 1;
                predFwd[i2][j2 + 3] = predFwd[i2][j2 + 3] + predBack[i2][j2 + 3] + 1 >> 1;
            }
        }
    }

    private void mvZero(Context context, PictureHeader ph, MPEGPred pred, int mbX, int mbY, int[][] mbPix) {
        if (ph.picture_coding_type == 2) {
            pred.predict16x16NoMV(this.refFrames[0], mbX << 4, mbY << 4, ph.pictureCodingExtension == null ? 3 : ph.pictureCodingExtension.picture_structure, 0, mbPix);
        } else {
            Object pp = mbPix;
            if (context.lastPredB.macroblock_motion_backward == 1) {
                pred.predict16x16NoMV(this.refFrames[0], mbX << 4, mbY << 4, ph.pictureCodingExtension == null ? 3 : ph.pictureCodingExtension.picture_structure, 1, (int[][])pp);
                pp = new int[][]{new int[mbPix[0].length], new int[mbPix[1].length], new int[mbPix[2].length]};
            }
            if (context.lastPredB.macroblock_motion_forward == 1) {
                pred.predict16x16NoMV(this.refFrames[1], mbX << 4, mbY << 4, ph.pictureCodingExtension == null ? 3 : ph.pictureCodingExtension.picture_structure, 0, (int[][])pp);
                if (mbPix != pp) {
                    MPEGDecoder.avgPred(mbPix, pp);
                }
            }
        }
    }

    protected void put(int[][] mbPix, int[][] buf, int stride, int chromaFormat, int mbX, int mbY, int width, int height, int vertOff, int vertStep) {
        int chromaStride = stride + (1 << MPEGConst.SQUEEZE_X[chromaFormat]) - 1 >> MPEGConst.SQUEEZE_X[chromaFormat];
        int chromaMBW = 4 - MPEGConst.SQUEEZE_X[chromaFormat];
        int chromaMBH = 4 - MPEGConst.SQUEEZE_Y[chromaFormat];
        this.putSub(buf[0], (mbY << 4) * (stride << vertStep) + vertOff * stride + (mbX << 4), stride << vertStep, mbPix[0], 4, 4);
        this.putSub(buf[1], (mbY << chromaMBH) * (chromaStride << vertStep) + vertOff * chromaStride + (mbX << chromaMBW), chromaStride << vertStep, mbPix[1], chromaMBW, chromaMBH);
        this.putSub(buf[2], (mbY << chromaMBH) * (chromaStride << vertStep) + vertOff * chromaStride + (mbX << chromaMBW), chromaStride << vertStep, mbPix[2], chromaMBW, chromaMBH);
    }

    private final void putSub(int[] big, int off, int stride, int[] block, int mbW, int mbH) {
        int blOff = 0;
        if (mbW == 3) {
            for (int i2 = 0; i2 < 1 << mbH; ++i2) {
                big[off] = MPEGDecoder.clip(block[blOff]);
                big[off + 1] = MPEGDecoder.clip(block[blOff + 1]);
                big[off + 2] = MPEGDecoder.clip(block[blOff + 2]);
                big[off + 3] = MPEGDecoder.clip(block[blOff + 3]);
                big[off + 4] = MPEGDecoder.clip(block[blOff + 4]);
                big[off + 5] = MPEGDecoder.clip(block[blOff + 5]);
                big[off + 6] = MPEGDecoder.clip(block[blOff + 6]);
                big[off + 7] = MPEGDecoder.clip(block[blOff + 7]);
                blOff += 8;
                off += stride;
            }
        } else {
            for (int i3 = 0; i3 < 1 << mbH; ++i3) {
                big[off] = MPEGDecoder.clip(block[blOff]);
                big[off + 1] = MPEGDecoder.clip(block[blOff + 1]);
                big[off + 2] = MPEGDecoder.clip(block[blOff + 2]);
                big[off + 3] = MPEGDecoder.clip(block[blOff + 3]);
                big[off + 4] = MPEGDecoder.clip(block[blOff + 4]);
                big[off + 5] = MPEGDecoder.clip(block[blOff + 5]);
                big[off + 6] = MPEGDecoder.clip(block[blOff + 6]);
                big[off + 7] = MPEGDecoder.clip(block[blOff + 7]);
                big[off + 8] = MPEGDecoder.clip(block[blOff + 8]);
                big[off + 9] = MPEGDecoder.clip(block[blOff + 9]);
                big[off + 10] = MPEGDecoder.clip(block[blOff + 10]);
                big[off + 11] = MPEGDecoder.clip(block[blOff + 11]);
                big[off + 12] = MPEGDecoder.clip(block[blOff + 12]);
                big[off + 13] = MPEGDecoder.clip(block[blOff + 13]);
                big[off + 14] = MPEGDecoder.clip(block[blOff + 14]);
                big[off + 15] = MPEGDecoder.clip(block[blOff + 15]);
                blOff += 16;
                off += stride;
            }
        }
    }

    private static final int clip(int val) {
        return val < 0 ? 0 : (val > 255 ? 255 : val);
    }

    private static final int quantInter(int level, int quant) {
        return ((level << 1) + 1) * quant >> 5;
    }

    private static final int quantInterSigned(int level, int quant) {
        return level >= 0 ? MPEGDecoder.quantInter(level, quant) : -MPEGDecoder.quantInter(-level, quant);
    }

    private final void blockIntra(BitReader bits, VLC vlcCoeff, int[] block, int[] intra_dc_predictor, int blkIdx, int[] scan, int escSize, int intra_dc_mult, int qScale, int[] qmat) {
        int cc = MPEGConst.BLOCK_TO_CC[blkIdx];
        int size = (cc == 0 ? MPEGConst.vlcDCSizeLuma : MPEGConst.vlcDCSizeChroma).readVLC(bits);
        int delta = size != 0 ? MPEGDecoder.mpegSigned(bits, size) : 0;
        intra_dc_predictor[cc] = intra_dc_predictor[cc] + delta;
        int dc = intra_dc_predictor[cc] * intra_dc_mult;
        SparseIDCT.start(block, dc);
        int idx = 0;
        while (idx < this.maxCoeff) {
            int level;
            int readVLC = vlcCoeff.readVLC(bits);
            if (readVLC >= 0) {
                level = MPEGDecoder.toSigned((readVLC & 0xFFF) * qScale * qmat[idx += (readVLC >> 12) + 1] >> 4, bits.read1Bit());
            } else {
                if (readVLC != -2) break;
                level = MPEGDecoder.twosSigned(bits, escSize) * qScale * qmat[idx += bits.readNBit(6) + 1];
                level = level >= 0 ? level >> 4 : -(-level >> 4);
            }
            SparseIDCT.coeff(block, scan[idx], level);
        }
        SparseIDCT.finish(block);
    }

    private final void blockInter(BitReader bits, VLC vlcCoeff, int[] block, int[] scan, int escSize, int qScale, int[] qmat) {
        int idx = -1;
        if (vlcCoeff == MPEGConst.vlcCoeff0 && bits.checkNBit(1) == 1) {
            bits.read1Bit();
            int dc = MPEGDecoder.toSigned(MPEGDecoder.quantInter(1, qScale * qmat[0]), bits.read1Bit());
            SparseIDCT.start(block, dc);
            ++idx;
        } else {
            SparseIDCT.start(block, 0);
        }
        while (idx < this.maxCoeff) {
            int ac;
            int readVLC = vlcCoeff.readVLC(bits);
            if (readVLC >= 0) {
                ac = MPEGDecoder.toSigned(MPEGDecoder.quantInter(readVLC & 0xFFF, qScale * qmat[idx += (readVLC >> 12) + 1]), bits.read1Bit());
            } else {
                if (readVLC != -2) break;
                ac = MPEGDecoder.quantInterSigned(MPEGDecoder.twosSigned(bits, escSize), qScale * qmat[idx += bits.readNBit(6) + 1]);
            }
            SparseIDCT.coeff(block, scan[idx], ac);
        }
        SparseIDCT.finish(block);
    }

    private static final int twosSigned(BitReader bits, int size) {
        int shift = 32 - size;
        return bits.readNBit(size) << shift >> shift;
    }

    private static final int mpegSigned(BitReader bits, int size) {
        int val = bits.readNBit(size);
        int sign = val >>> size - 1 ^ 1;
        return val + sign - (sign << size);
    }

    private static final int toSigned(int val, int s) {
        int sign = s << 31 >> 31;
        return (val ^ sign) - sign;
    }

    private final int readCbPattern(BitReader bits) {
        int cbp420 = MPEGConst.vlcCBP.readVLC(bits);
        if (this.sh.sequenceExtension == null || this.sh.sequenceExtension.chroma_format == 1) {
            return cbp420;
        }
        if (this.sh.sequenceExtension.chroma_format == 2) {
            return cbp420 << 2 | bits.readNBit(2);
        }
        if (this.sh.sequenceExtension.chroma_format == 3) {
            return cbp420 << 6 | bits.readNBit(6);
        }
        throw new RuntimeException("Unsupported chroma format: " + this.sh.sequenceExtension.chroma_format);
    }

    @Override
    public int probe(ByteBuffer data) {
        data = data.duplicate();
        data.order(ByteOrder.BIG_ENDIAN);
        for (int i2 = 0; i2 < 2 && MPEGUtil.gotoNextMarker(data) != null && data.hasRemaining(); ++i2) {
            int marker = data.getInt();
            if (marker == 256 || marker >= 432 && marker <= 440) {
                return 50 - i2 * 10;
            }
            if (marker <= 256 || marker >= 432) continue;
            return 20 - i2 * 10;
        }
        return 0;
    }

    public static Size getSize(ByteBuffer data) {
        SequenceHeader sh = MPEGDecoder.getSequenceHeader(data.duplicate());
        return new Size(sh.horizontal_size, sh.vertical_size);
    }

    private static SequenceHeader getSequenceHeader(ByteBuffer data) {
        ByteBuffer segment = MPEGUtil.nextSegment(data);
        while (segment != null) {
            int marker = segment.getInt();
            if (marker == 435) {
                return SequenceHeader.read(segment);
            }
            segment = MPEGUtil.nextSegment(data);
        }
        return null;
    }

    public class Context {
        int[] intra_dc_predictor = new int[3];
        public int mbWidth;
        int mbNo;
        public int codedWidth;
        public int codedHeight;
        public int mbHeight;
        public ColorSpace color;
        public MPEGConst.MBType lastPredB;
        public int[][] qMats;
        public int[] scan;
    }
}

