/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg.tools;

public class Asserts {
    public static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalStateException("assert failed: " + expected + " != " + actual);
        }
    }

    public static void assertInRange(String message, int low, int up, int val) {
        if (val < low || val > up) {
            throw new IllegalStateException(message);
        }
    }

    public static void assertEpsilonEquals(int[] expected, int[] actual, int eps) {
        if (expected.length != actual.length) {
            throw new IllegalStateException("arrays of different size");
        }
        for (int i2 = 0; i2 < expected.length; ++i2) {
            int e2 = expected[i2];
            int a2 = actual[i2];
            if (Math.abs(e2 - a2) <= eps) continue;
            throw new IllegalStateException("array element out of expected diff range");
        }
    }

    public static void assertEpsilonEquals(byte[] expected, byte[] actual, int eps) {
        if (expected.length != actual.length) {
            throw new IllegalStateException("arrays of different size");
        }
        for (int i2 = 0; i2 < expected.length; ++i2) {
            int e2 = expected[i2] & 0xFF;
            int a2 = actual[i2] & 0xFF;
            if (Math.abs(e2 - a2) <= eps) continue;
            throw new IllegalStateException("array element out of expected diff range: " + Math.abs(e2 - a2));
        }
    }
}

