/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.nio.IntBuffer;
import org.jcodec.codecs.mjpeg.FrameHeader;
import org.jcodec.codecs.mjpeg.tools.Asserts;

public class MCU {
    private boolean is420;
    private boolean is444;
    private boolean is422;
    Comp lum;
    Comp cb;
    Comp cr;
    int h;
    int v;
    private IntBuffer rgb24;
    private static final int[] zero = new int[64];

    public boolean is420() {
        return this.is420;
    }

    public boolean is444() {
        return this.is444;
    }

    public boolean is422() {
        return this.is422;
    }

    public int getMaxHorizComponents() {
        return this.h >>> 3;
    }

    public int getMaxVertComponents() {
        return this.v >>> 3;
    }

    public int getWidth() {
        return this.h;
    }

    public int getHeight() {
        return this.v;
    }

    public void clear() {
        this.lum.clear();
        this.cb.clear();
        this.cr.clear();
    }

    public static MCU create(FrameHeader frame) {
        Asserts.assertEquals(3, frame.components.length);
        MCU mcu = new MCU();
        FrameHeader.Component cLum = frame.components[0];
        FrameHeader.Component cCb = frame.components[1];
        FrameHeader.Component cCr = frame.components[2];
        mcu.lum = new Comp(cLum.h, cLum.v);
        mcu.cb = new Comp(cCb.h, cCb.v);
        mcu.cr = new Comp(cCr.h, cCr.v);
        mcu.h = frame.getHmax() * 8;
        mcu.v = frame.getVmax() * 8;
        mcu.is420 = mcu.lum.h == 2 && mcu.lum.v == 2 && mcu.cb.h == 1 && mcu.cb.v == 1 && mcu.cr.h == 1 && mcu.cr.v == 1;
        mcu.is444 = mcu.lum.h == 1 && mcu.lum.v == 1 && mcu.cb.h == 1 && mcu.cb.v == 1 && mcu.cr.h == 1 && mcu.cr.v == 1;
        mcu.is422 = mcu.lum.h == 2 && mcu.lum.v == 1 && mcu.cb.h == 1 && mcu.cb.v == 1 && mcu.cr.h == 1 && mcu.cr.v == 1;
        mcu.setRgb24(IntBuffer.allocate(mcu.getWidth() * mcu.getWidth()));
        return mcu;
    }

    void setRgb24(IntBuffer rgb24) {
        this.rgb24 = rgb24;
    }

    public IntBuffer getRgb24() {
        return this.rgb24.duplicate();
    }

    public static class Comp {
        final int[][] data;
        final int h;
        final int v;

        public Comp(int h2, int v) {
            this.h = h2;
            this.v = v;
            this.data = new int[h2 * v][64];
        }

        void clear() {
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                System.arraycopy(zero, 0, this.data[i2], 0, 64);
            }
        }
    }
}

