/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.jcodec.codecs.mjpeg.ByteStuffingInputStream;
import org.jcodec.codecs.mjpeg.CodedImage;
import org.jcodec.codecs.mjpeg.FrameHeader;
import org.jcodec.codecs.mjpeg.JpegConst;
import org.jcodec.codecs.mjpeg.JpegUtils;
import org.jcodec.codecs.mjpeg.Markers;
import org.jcodec.codecs.mjpeg.QuantTable;
import org.jcodec.codecs.mjpeg.ScanHeader;
import org.jcodec.codecs.mjpeg.tools.Asserts;
import org.jcodec.codecs.wav.StringReader;
import org.jcodec.common.CountingInputStream;
import org.jcodec.common.IOUtils;
import org.jcodec.common.io.VLCBuilder;
import org.jcodec.common.tools.Debug;

public class JpegParser {
    public CodedImage parse(InputStream is) throws IOException {
        CountingInputStream counter = new CountingInputStream(is);
        return this.parse(new PushbackInputStream(counter, 2), counter);
    }

    public CodedImage parse(PushbackInputStream is, CountingInputStream counter) throws IOException {
        int b2;
        CodedImage image = new CodedImage();
        int curQTable = 0;
        block10: while (true) {
            int marker;
            if ((marker = is.read()) == -1) {
                return image;
            }
            if (marker == 0) continue;
            if (marker != 255) {
                throw new RuntimeException("@" + Long.toHexString(counter.getCount()) + " Marker expected: 0x" + Integer.toHexString(marker));
            }
            b2 = is.read();
            Debug.trace("%s", Markers.toString(b2));
            switch (b2) {
                case 192: {
                    image.frame = FrameHeader.read(is);
                    Debug.trace("    %s", image.frame);
                    continue block10;
                }
                case 196: {
                    int len1 = this.readShort(is);
                    CountingInputStream cis = new CountingInputStream(is);
                    while (true) {
                        if (cis.getCount() >= len1 - 2) continue block10;
                        this.readHuffmanTable(cis, image);
                    }
                }
                case 219: {
                    int len4 = this.readShort(is);
                    CountingInputStream cis1 = new CountingInputStream(is);
                    while (true) {
                        if (cis1.getCount() >= len4 - 2) continue block10;
                        QuantTable quantTable = this.readQuantTable(cis1);
                        if (curQTable == 0) {
                            image.setQuantLum(quantTable);
                        } else {
                            image.setQuantChrom(quantTable);
                        }
                        ++curQTable;
                    }
                }
                case 218: {
                    if (image.scan != null) {
                        throw new IllegalStateException("unhandled - more than one scan header");
                    }
                    image.scan = ScanHeader.read(is);
                    Debug.trace("    %s", image.scan);
                    image.setData(this.readData(is));
                    continue block10;
                }
                case 216: {
                    continue block10;
                }
                case 217: {
                    return image;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    int len3 = this.readShort(is);
                    StringReader.sureSkip(is, len3 - 2);
                    continue block10;
                }
                case 221: {
                    int lr = this.readShort(is);
                    int ri = this.readShort(is);
                    Debug.trace("DRI Lr: %d Ri: %d", lr, ri);
                    Asserts.assertEquals(0, ri);
                    continue block10;
                }
            }
            break;
        }
        throw new IllegalStateException("unhandled marker " + Markers.toString(b2));
    }

    private void readHuffmanTable(InputStream is, CodedImage image) throws IOException {
        VLCBuilder builder = new VLCBuilder();
        int tableNo = is.read();
        byte[] levelSizes = new byte[16];
        is.read(levelSizes);
        int levelStart = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            int length = levelSizes[i2] & 0xFF;
            for (int c2 = 0; c2 < length; ++c2) {
                int val = is.read();
                int code = levelStart++;
                builder.set(code, i2 + 1, val);
            }
            levelStart <<= 1;
        }
        if (tableNo == JpegConst.Type.YDC.getValue()) {
            image.setYdc(builder.getVLC());
        } else if (tableNo == JpegConst.Type.CDC.getValue()) {
            image.setCdc(builder.getVLC());
        } else if (tableNo == JpegConst.Type.YAC.getValue()) {
            image.setYac(builder.getVLC());
        } else if (tableNo == JpegConst.Type.CAC.getValue()) {
            image.setCac(builder.getVLC());
        } else {
            throw new RuntimeException("Unsupported huffman table index: " + tableNo);
        }
    }

    private QuantTable readQuantTable(InputStream is) throws IOException {
        int ind = is.read();
        int[] result = new int[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            result[i2] = is.read();
        }
        return new QuantTable(ind, JpegUtils.zigzagDecode(result));
    }

    private byte[] readData(PushbackInputStream is) throws IOException {
        return IOUtils.toByteArray(new ByteStuffingInputStream(is));
    }

    private int readShort(InputStream is) throws IOException {
        int b1 = is.read();
        int b2 = is.read();
        return (b1 << 8) + b2;
    }
}

