/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import org.jcodec.codecs.mjpeg.CodedImage;
import org.jcodec.codecs.mjpeg.DecodedImage;
import org.jcodec.codecs.mjpeg.ImageConvert;
import org.jcodec.codecs.mjpeg.JPEGBitStream;
import org.jcodec.codecs.mjpeg.JpegParser;
import org.jcodec.codecs.mjpeg.JpegUtils;
import org.jcodec.codecs.mjpeg.MCU;
import org.jcodec.codecs.mjpeg.QuantTable;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.dct.DCT;
import org.jcodec.common.dct.IntDCT;

public class JpegDecoder {
    private static final byte[] JFIF = JCodecUtil.asciiString("JFIF");
    protected static DCT dct = new IntDCT();

    public static DecodedImage doIt(InputStream is) throws IOException {
        JpegDecoder decoder = new JpegDecoder();
        return decoder.decode(new JpegParser().parse(is));
    }

    private static final int align(int val, int align) {
        return align + (val - 1 & ~(align - 1));
    }

    public DecodedImage decode(CodedImage coded) throws IOException {
        return this.decode(coded, new DecodedImage(coded.getWidth(), coded.getHeight(), new int[coded.getWidth() * coded.getHeight()]));
    }

    public DecodedImage decode(CodedImage coded, DecodedImage decoded) throws IOException {
        int bx;
        int by;
        IntBuffer result = IntBuffer.wrap(decoded.getPixels());
        JPEGBitStream jbs = new JPEGBitStream(coded);
        int blockH = coded.frame.getHmax() << 3;
        int blockV = coded.frame.getVmax() << 3;
        int width = coded.getWidth();
        int height = coded.getHeight();
        int alignedWidth = JpegDecoder.align(width, blockH);
        int alignedHeight = JpegDecoder.align(height, blockV);
        int xBlocks = alignedWidth / blockH;
        int xxBlocks = width / blockH;
        int yBlocks = alignedHeight / blockV;
        int yyBlocks = height / blockV;
        int dWidth = alignedWidth - width;
        int dHeight = alignedHeight - height;
        MCU block = MCU.create(coded.frame);
        for (by = 0; by < yyBlocks; ++by) {
            for (bx = 0; bx < xxBlocks; ++bx) {
                JpegDecoder.readAndDecode(coded, jbs, block);
                JpegDecoder.putBlock(result, width, block, bx, by);
            }
            for (bx = xxBlocks; bx < xBlocks; ++bx) {
                JpegDecoder.readAndDecode(coded, jbs, block);
                JpegDecoder.putBlock(result, width, block, bx, by, blockH - dWidth, blockV);
            }
        }
        for (by = yyBlocks; by < yBlocks; ++by) {
            for (bx = 0; bx < xxBlocks; ++bx) {
                JpegDecoder.readAndDecode(coded, jbs, block);
                JpegDecoder.putBlock(result, width, block, bx, by, blockH, blockV - dHeight);
            }
            for (bx = xxBlocks; bx < xBlocks; ++bx) {
                JpegDecoder.readAndDecode(coded, jbs, block);
                JpegDecoder.putBlock(result, width, block, bx, by, blockH - dWidth, blockV - dHeight);
            }
        }
        return decoded;
    }

    private static void putBlock(IntBuffer result, int width, MCU block, int bx, int by) {
        int blockH = block.h;
        int blockV = block.v;
        IntBuffer rgb = block.getRgb24();
        int bY = by * blockV * width;
        int bX = bx * blockH;
        int blockPtr = bY + bX;
        for (int j2 = 0; j2 < blockV; ++j2) {
            result.position(blockPtr);
            for (int i2 = 0; i2 < blockH; ++i2) {
                result.put(rgb.get());
            }
            blockPtr += width;
        }
    }

    private static void putBlock(IntBuffer result, int width, MCU block, int bx, int by, int blockH, int blockV) {
        IntBuffer rgb = block.getRgb24();
        int bY = by * block.v * width;
        int bX = bx * block.h;
        int blockPtr = bY + bX;
        for (int j2 = 0; j2 < blockV; ++j2) {
            result.position(blockPtr);
            for (int i2 = 0; i2 < blockH; ++i2) {
                result.put(rgb.get());
            }
            rgb.position(rgb.position() + (block.h - blockH));
            blockPtr += width;
        }
    }

    private static void readAndDecode(CodedImage coded, JPEGBitStream jbs, MCU block) throws IOException {
        jbs.readBlock(block);
        JpegDecoder.decodeBlock(block, coded.getQuantLum(), coded.getQuantChrom());
    }

    private static void decodeBlock(MCU block, QuantTable qLum, QuantTable qChrom) {
        JpegUtils.zigzagDecodeAll(block.lum.data);
        JpegUtils.zigzagDecodeAll(block.cb.data);
        JpegUtils.zigzagDecodeAll(block.cr.data);
        JpegDecoder.dequantAll(block.lum.data, qLum);
        JpegDecoder.dequantAll(block.cb.data, qChrom);
        JpegDecoder.dequantAll(block.cr.data, qChrom);
        dct.decodeAll(block.lum.data);
        dct.decodeAll(block.cb.data);
        dct.decodeAll(block.cr.data);
        IntBuffer rgb = block.getRgb24();
        IntBuffer Cb = IntBuffer.wrap(block.cb.data[0]);
        IntBuffer Cr = IntBuffer.wrap(block.cr.data[0]);
        if (block.is420()) {
            int j2;
            IntBuffer y00 = IntBuffer.wrap(block.lum.data[0]);
            IntBuffer y01 = IntBuffer.wrap(block.lum.data[1]);
            IntBuffer y10 = IntBuffer.wrap(block.lum.data[2]);
            IntBuffer y11 = IntBuffer.wrap(block.lum.data[3]);
            for (j2 = 0; j2 < 8; ++j2) {
                Cb.position((j2 & 0xFFFFFFFE) << 2);
                Cr.position((j2 & 0xFFFFFFFE) << 2);
                JpegDecoder.lineToRgb(y00, Cb, Cr, rgb);
                JpegDecoder.lineToRgb(y01, Cb, Cr, rgb);
            }
            for (j2 = 8; j2 < 16; ++j2) {
                Cb.position((j2 & 0xFFFFFFFE) << 2);
                Cr.position((j2 & 0xFFFFFFFE) << 2);
                JpegDecoder.lineToRgb(y10, Cb, Cr, rgb);
                JpegDecoder.lineToRgb(y11, Cb, Cr, rgb);
            }
        } else if (block.is422()) {
            IntBuffer y00 = IntBuffer.wrap(block.lum.data[0]);
            IntBuffer y01 = IntBuffer.wrap(block.lum.data[1]);
            for (int j3 = 0; j3 < 8; ++j3) {
                Cb.position(j3 << 3);
                Cr.position(j3 << 3);
                JpegDecoder.lineToRgb(y00, Cb, Cr, rgb);
                JpegDecoder.lineToRgb(y01, Cb, Cr, rgb);
            }
        } else if (block.is444()) {
            IntBuffer Y = IntBuffer.wrap(block.lum.data[0]);
            while (rgb.hasRemaining()) {
                rgb.put(ImageConvert.ycbcr_to_rgb24(Y.get(), Cb.get(), Cr.get()));
            }
        } else {
            throw new IllegalStateException("unsupported MCU");
        }
    }

    private static void lineToRgb(IntBuffer Y, IntBuffer Cb, IntBuffer Cr, IntBuffer rgb) {
        for (int i2 = 0; i2 < 8; ++i2) {
            Cb.position(Cb.position() - (i2 & 1));
            Cr.position(Cr.position() - (i2 & 1));
            int y = Y.get();
            int cb = Cb.get();
            int cr = Cr.get();
            rgb.put(ImageConvert.ycbcr_to_rgb24(y, cb, cr));
        }
    }

    private static void dequantAll(int[][] src, QuantTable quantTable) {
        for (int i2 = 0; i2 < src.length; ++i2) {
            JpegDecoder.dequant(src[i2], quantTable);
        }
    }

    private static void dequant(int[] src, QuantTable quantTable) {
        for (int i2 = 0; i2 < 64; ++i2) {
            src[i2] = quantTable.getValues()[i2] * src[i2];
        }
    }
}

