/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.write;

import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.RefPicMarking;
import org.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.ColorSpace;

public class SliceHeaderWriter {
    private SeqParameterSet sps;
    private PictureParameterSet pps;

    public SliceHeaderWriter(SeqParameterSet sps, PictureParameterSet pps) {
        this.sps = sps;
        this.pps = pps;
    }

    public void write(SliceHeader sliceHeader, boolean idrSlice, int nalRefIdc, BitWriter writer) {
        CAVLCWriter.writeUE(writer, sliceHeader.first_mb_in_slice, "SH: first_mb_in_slice");
        CAVLCWriter.writeUE(writer, sliceHeader.slice_type.ordinal() + (sliceHeader.slice_type_restr ? 5 : 0), "SH: slice_type");
        CAVLCWriter.writeUE(writer, sliceHeader.pic_parameter_set_id, "SH: pic_parameter_set_id");
        CAVLCWriter.writeU(writer, sliceHeader.frame_num, this.sps.log2_max_frame_num_minus4 + 4);
        if (!this.sps.frame_mbs_only_flag) {
            CAVLCWriter.writeBool(writer, sliceHeader.field_pic_flag, "SH: field_pic_flag");
            if (sliceHeader.field_pic_flag) {
                CAVLCWriter.writeBool(writer, sliceHeader.bottom_field_flag, "SH: bottom_field_flag");
            }
        }
        if (idrSlice) {
            CAVLCWriter.writeUE(writer, sliceHeader.idr_pic_id, "SH: idr_pic_id");
        }
        if (this.sps.pic_order_cnt_type == 0) {
            CAVLCWriter.writeU(writer, sliceHeader.pic_order_cnt_lsb, this.sps.log2_max_pic_order_cnt_lsb_minus4 + 4);
            if (this.pps.pic_order_present_flag && !this.sps.field_pic_flag) {
                CAVLCWriter.writeSE(writer, sliceHeader.delta_pic_order_cnt_bottom, "SH: delta_pic_order_cnt_bottom");
            }
        }
        if (this.sps.pic_order_cnt_type == 1 && !this.sps.delta_pic_order_always_zero_flag) {
            CAVLCWriter.writeSE(writer, sliceHeader.delta_pic_order_cnt[0], "SH: delta_pic_order_cnt");
            if (this.pps.pic_order_present_flag && !this.sps.field_pic_flag) {
                CAVLCWriter.writeSE(writer, sliceHeader.delta_pic_order_cnt[1], "SH: delta_pic_order_cnt");
            }
        }
        if (this.pps.redundant_pic_cnt_present_flag) {
            CAVLCWriter.writeUE(writer, sliceHeader.redundant_pic_cnt, "SH: redundant_pic_cnt");
        }
        if (sliceHeader.slice_type == SliceType.B) {
            CAVLCWriter.writeBool(writer, sliceHeader.direct_spatial_mv_pred_flag, "SH: direct_spatial_mv_pred_flag");
        }
        if (sliceHeader.slice_type == SliceType.P || sliceHeader.slice_type == SliceType.SP || sliceHeader.slice_type == SliceType.B) {
            CAVLCWriter.writeBool(writer, sliceHeader.num_ref_idx_active_override_flag, "SH: num_ref_idx_active_override_flag");
            if (sliceHeader.num_ref_idx_active_override_flag) {
                CAVLCWriter.writeUE(writer, sliceHeader.num_ref_idx_active_minus1[0], "SH: num_ref_idx_l0_active_minus1");
                if (sliceHeader.slice_type == SliceType.B) {
                    CAVLCWriter.writeUE(writer, sliceHeader.num_ref_idx_active_minus1[1], "SH: num_ref_idx_l1_active_minus1");
                }
            }
        }
        this.writeRefPicListReordering(sliceHeader, writer);
        if (this.pps.weighted_pred_flag && (sliceHeader.slice_type == SliceType.P || sliceHeader.slice_type == SliceType.SP) || this.pps.weighted_bipred_idc == 1 && sliceHeader.slice_type == SliceType.B) {
            this.writePredWeightTable(sliceHeader, writer);
        }
        if (nalRefIdc != 0) {
            this.writeDecRefPicMarking(sliceHeader, idrSlice, writer);
        }
        if (this.pps.entropy_coding_mode_flag && sliceHeader.slice_type.isInter()) {
            CAVLCWriter.writeUE(writer, sliceHeader.cabac_init_idc, "SH: cabac_init_idc");
        }
        CAVLCWriter.writeSE(writer, sliceHeader.slice_qp_delta, "SH: slice_qp_delta");
        if (sliceHeader.slice_type == SliceType.SP || sliceHeader.slice_type == SliceType.SI) {
            if (sliceHeader.slice_type == SliceType.SP) {
                CAVLCWriter.writeBool(writer, sliceHeader.sp_for_switch_flag, "SH: sp_for_switch_flag");
            }
            CAVLCWriter.writeSE(writer, sliceHeader.slice_qs_delta, "SH: slice_qs_delta");
        }
        if (this.pps.deblocking_filter_control_present_flag) {
            CAVLCWriter.writeUE(writer, sliceHeader.disable_deblocking_filter_idc, "SH: disable_deblocking_filter_idc");
            if (sliceHeader.disable_deblocking_filter_idc != 1) {
                CAVLCWriter.writeSE(writer, sliceHeader.slice_alpha_c0_offset_div2, "SH: slice_alpha_c0_offset_div2");
                CAVLCWriter.writeSE(writer, sliceHeader.slice_beta_offset_div2, "SH: slice_beta_offset_div2");
            }
        }
        if (this.pps.num_slice_groups_minus1 > 0 && this.pps.slice_group_map_type >= 3 && this.pps.slice_group_map_type <= 5) {
            int len = (this.sps.pic_height_in_map_units_minus1 + 1) * (this.sps.pic_width_in_mbs_minus1 + 1) / (this.pps.slice_group_change_rate_minus1 + 1);
            if ((this.sps.pic_height_in_map_units_minus1 + 1) * (this.sps.pic_width_in_mbs_minus1 + 1) % (this.pps.slice_group_change_rate_minus1 + 1) > 0) {
                ++len;
            }
            len = SliceHeaderWriter.CeilLog2(len + 1);
            CAVLCWriter.writeU(writer, sliceHeader.slice_group_change_cycle, len);
        }
    }

    private static int CeilLog2(int uiVal) {
        int uiTmp = uiVal - 1;
        int uiRet = 0;
        while (uiTmp != 0) {
            uiTmp >>= 1;
            ++uiRet;
        }
        return uiRet;
    }

    private void writeDecRefPicMarking(SliceHeader sliceHeader, boolean idrSlice, BitWriter writer) {
        if (idrSlice) {
            RefPicMarkingIDR drpmidr = sliceHeader.refPicMarkingIDR;
            CAVLCWriter.writeBool(writer, drpmidr.isDiscardDecodedPics(), "SH: no_output_of_prior_pics_flag");
            CAVLCWriter.writeBool(writer, drpmidr.isUseForlongTerm(), "SH: long_term_reference_flag");
        } else {
            CAVLCWriter.writeBool(writer, sliceHeader.refPicMarkingNonIDR != null, "SH: adaptive_ref_pic_marking_mode_flag");
            if (sliceHeader.refPicMarkingNonIDR != null) {
                RefPicMarking drpmidr = sliceHeader.refPicMarkingNonIDR;
                block8: for (RefPicMarking.Instruction mmop : drpmidr.getInstructions()) {
                    switch (mmop.getType()) {
                        case REMOVE_SHORT: {
                            CAVLCWriter.writeUE(writer, 1, "SH: memory_management_control_operation");
                            CAVLCWriter.writeUE(writer, mmop.getArg1() - 1, "SH: difference_of_pic_nums_minus1");
                            continue block8;
                        }
                        case REMOVE_LONG: {
                            CAVLCWriter.writeUE(writer, 2, "SH: memory_management_control_operation");
                            CAVLCWriter.writeUE(writer, mmop.getArg1(), "SH: long_term_pic_num");
                            continue block8;
                        }
                        case CONVERT_INTO_LONG: {
                            CAVLCWriter.writeUE(writer, 3, "SH: memory_management_control_operation");
                            CAVLCWriter.writeUE(writer, mmop.getArg1() - 1, "SH: difference_of_pic_nums_minus1");
                            CAVLCWriter.writeUE(writer, mmop.getArg2(), "SH: long_term_frame_idx");
                            continue block8;
                        }
                        case TRUNK_LONG: {
                            CAVLCWriter.writeUE(writer, 4, "SH: memory_management_control_operation");
                            CAVLCWriter.writeUE(writer, mmop.getArg1() + 1, "SH: max_long_term_frame_idx_plus1");
                            continue block8;
                        }
                        case CLEAR: {
                            CAVLCWriter.writeUE(writer, 5, "SH: memory_management_control_operation");
                            continue block8;
                        }
                        case MARK_LONG: {
                            CAVLCWriter.writeUE(writer, 6, "SH: memory_management_control_operation");
                            CAVLCWriter.writeUE(writer, mmop.getArg1(), "SH: long_term_frame_idx");
                        }
                    }
                }
                CAVLCWriter.writeUE(writer, 0, "SH: memory_management_control_operation");
            }
        }
    }

    private void writePredWeightTable(SliceHeader sliceHeader, BitWriter writer) {
        CAVLCWriter.writeUE(writer, sliceHeader.pred_weight_table.luma_log2_weight_denom, "SH: luma_log2_weight_denom");
        if (this.sps.chroma_format_idc != ColorSpace.MONO) {
            CAVLCWriter.writeUE(writer, sliceHeader.pred_weight_table.chroma_log2_weight_denom, "SH: chroma_log2_weight_denom");
        }
        this.writeOffsetWeight(sliceHeader, writer, 0);
        if (sliceHeader.slice_type == SliceType.B) {
            this.writeOffsetWeight(sliceHeader, writer, 1);
        }
    }

    private void writeOffsetWeight(SliceHeader sliceHeader, BitWriter writer, int list) {
        for (int i2 = 0; i2 < sliceHeader.pred_weight_table.luma_weight[list].length; ++i2) {
            boolean flagLuma = sliceHeader.pred_weight_table.luma_weight[list][i2] == 128 && sliceHeader.pred_weight_table.luma_offset[list][i2] == 0;
            CAVLCWriter.writeBool(writer, flagLuma, "SH: luma_weight_l0_flag");
            if (flagLuma) {
                CAVLCWriter.writeSE(writer, sliceHeader.pred_weight_table.luma_weight[list][i2], "SH: ");
                CAVLCWriter.writeSE(writer, sliceHeader.pred_weight_table.luma_offset[list][i2], "SH: ");
            }
            if (this.sps.chroma_format_idc == ColorSpace.MONO) continue;
            boolean flagChroma = sliceHeader.pred_weight_table.chroma_weight[list][0][i2] == 128 && sliceHeader.pred_weight_table.chroma_offset[list][0][i2] == 0 && sliceHeader.pred_weight_table.chroma_weight[list][1][i2] == 128 && sliceHeader.pred_weight_table.chroma_offset[list][1][i2] == 0;
            CAVLCWriter.writeBool(writer, flagChroma, "SH: chroma_weight_l0_flag");
            if (!flagChroma) continue;
            for (int j2 = 0; j2 < 2; ++j2) {
                CAVLCWriter.writeSE(writer, sliceHeader.pred_weight_table.chroma_weight[list][i2][j2], "SH: ");
                CAVLCWriter.writeSE(writer, sliceHeader.pred_weight_table.chroma_offset[list][i2][j2], "SH: ");
            }
        }
    }

    private void writeRefPicListReordering(SliceHeader sliceHeader, BitWriter writer) {
        if (sliceHeader.slice_type.isInter()) {
            CAVLCWriter.writeBool(writer, sliceHeader.refPicReordering[0] != null, "SH: ref_pic_list_reordering_flag_l0");
            this.writeReorderingList(sliceHeader.refPicReordering[0], writer);
        }
        if (sliceHeader.slice_type == SliceType.B) {
            CAVLCWriter.writeBool(writer, sliceHeader.refPicReordering[1] != null, "SH: ref_pic_list_reordering_flag_l1");
            this.writeReorderingList(sliceHeader.refPicReordering[1], writer);
        }
    }

    private void writeReorderingList(int[][] reordering, BitWriter writer) {
        if (reordering == null) {
            return;
        }
        for (int i2 = 0; i2 < reordering.length; ++i2) {
            CAVLCWriter.writeUE(writer, reordering[0][i2], "SH: reordering_of_pic_nums_idc");
            CAVLCWriter.writeUE(writer, reordering[1][i2], "SH: abs_diff_pic_num_minus1");
        }
        CAVLCWriter.writeUE(writer, 3, "SH: reordering_of_pic_nums_idc");
    }
}

