/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode.aso;

import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.decode.aso.FlatMBlockMapper;
import org.jcodec.codecs.h264.decode.aso.MBToSliceGroupMap;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.decode.aso.PrebuiltMBlockMapper;
import org.jcodec.codecs.h264.decode.aso.SliceGroupMapBuilder;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;

public class MapManager {
    private SeqParameterSet sps;
    private PictureParameterSet pps;
    private MBToSliceGroupMap mbToSliceGroupMap;
    private int prevSliceGroupChangeCycle;

    public MapManager(SeqParameterSet sps, PictureParameterSet pps) {
        this.sps = sps;
        this.pps = pps;
        this.mbToSliceGroupMap = this.buildMap(sps, pps);
    }

    private MBToSliceGroupMap buildMap(SeqParameterSet sps, PictureParameterSet pps) {
        int numGroups = pps.num_slice_groups_minus1 + 1;
        if (numGroups > 1) {
            int[] map;
            int picWidthInMbs = sps.pic_width_in_mbs_minus1 + 1;
            int picHeightInMbs = H264Utils.getPicHeightInMbs(sps);
            if (pps.slice_group_map_type == 0) {
                int[] runLength = new int[numGroups];
                for (int i2 = 0; i2 < numGroups; ++i2) {
                    runLength[i2] = pps.run_length_minus1[i2] + 1;
                }
                map = SliceGroupMapBuilder.buildInterleavedMap(picWidthInMbs, picHeightInMbs, runLength);
            } else if (pps.slice_group_map_type == 1) {
                map = SliceGroupMapBuilder.buildDispersedMap(picWidthInMbs, picHeightInMbs, numGroups);
            } else if (pps.slice_group_map_type == 2) {
                map = SliceGroupMapBuilder.buildForegroundMap(picWidthInMbs, picHeightInMbs, numGroups, pps.top_left, pps.bottom_right);
            } else {
                if (pps.slice_group_map_type >= 3 && pps.slice_group_map_type <= 5) {
                    return null;
                }
                if (pps.slice_group_map_type == 6) {
                    map = pps.slice_group_id;
                } else {
                    throw new RuntimeException("Unsupported slice group map type");
                }
            }
            return this.buildMapIndices(map, numGroups);
        }
        return null;
    }

    private MBToSliceGroupMap buildMapIndices(int[] map, int numGroups) {
        int i2;
        int[] ind = new int[numGroups];
        int[] indices = new int[map.length];
        for (int i3 = 0; i3 < map.length; ++i3) {
            int n2 = map[i3];
            ind[n2] = ind[n2] + 1;
        }
        int[][] inverse = new int[numGroups][];
        for (i2 = 0; i2 < numGroups; ++i2) {
            inverse[i2] = new int[ind[i2]];
        }
        ind = new int[numGroups];
        i2 = 0;
        while (i2 < map.length) {
            int sliceGroup;
            int n3 = sliceGroup = map[i2];
            int n4 = ind[n3];
            ind[n3] = n4 + 1;
            inverse[sliceGroup][n4] = i2++;
        }
        return new MBToSliceGroupMap(map, indices, inverse);
    }

    private void updateMap(SliceHeader sh) {
        int mapType = this.pps.slice_group_map_type;
        int numGroups = this.pps.num_slice_groups_minus1 + 1;
        if (numGroups > 1 && mapType >= 3 && mapType <= 5 && (sh.slice_group_change_cycle != this.prevSliceGroupChangeCycle || this.mbToSliceGroupMap == null)) {
            int sizeOfUpperLeftGroup;
            this.prevSliceGroupChangeCycle = sh.slice_group_change_cycle;
            int mapUnitsInSliceGroup0 = sh.slice_group_change_cycle * (this.pps.slice_group_change_rate_minus1 + 1);
            int picWidthInMbs = this.sps.pic_width_in_mbs_minus1 + 1;
            int picHeightInMbs = H264Utils.getPicHeightInMbs(this.sps);
            int picSizeInMapUnits = picWidthInMbs * picHeightInMbs;
            mapUnitsInSliceGroup0 = mapUnitsInSliceGroup0 > picSizeInMapUnits ? picSizeInMapUnits : mapUnitsInSliceGroup0;
            int n2 = sizeOfUpperLeftGroup = this.pps.slice_group_change_direction_flag ? picSizeInMapUnits - mapUnitsInSliceGroup0 : mapUnitsInSliceGroup0;
            int[] map = mapType == 3 ? SliceGroupMapBuilder.buildBoxOutMap(picWidthInMbs, picHeightInMbs, this.pps.slice_group_change_direction_flag, mapUnitsInSliceGroup0) : (mapType == 4 ? SliceGroupMapBuilder.buildRasterScanMap(picWidthInMbs, picHeightInMbs, sizeOfUpperLeftGroup, this.pps.slice_group_change_direction_flag) : SliceGroupMapBuilder.buildWipeMap(picWidthInMbs, picHeightInMbs, sizeOfUpperLeftGroup, this.pps.slice_group_change_direction_flag));
            this.mbToSliceGroupMap = this.buildMapIndices(map, numGroups);
        }
    }

    public Mapper getMapper(SliceHeader sh) {
        this.updateMap(sh);
        int firstMBInSlice = sh.first_mb_in_slice;
        if (this.pps.num_slice_groups_minus1 > 0) {
            return new PrebuiltMBlockMapper(this.mbToSliceGroupMap, firstMBInSlice, this.sps.pic_width_in_mbs_minus1 + 1);
        }
        return new FlatMBlockMapper(this.sps.pic_width_in_mbs_minus1 + 1, firstMBInSlice);
    }
}

