/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.jcodec.codecs.common.biari.MDecoder;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.BlockInterpolator;
import org.jcodec.codecs.h264.decode.CAVLCReader;
import org.jcodec.codecs.h264.decode.ChromaPredictionBuilder;
import org.jcodec.codecs.h264.decode.CoeffTransformer;
import org.jcodec.codecs.h264.decode.Intra16x16PredictionBuilder;
import org.jcodec.codecs.h264.decode.Intra4x4PredictionBuilder;
import org.jcodec.codecs.h264.decode.Intra8x8PredictionBuilder;
import org.jcodec.codecs.h264.decode.Prediction;
import org.jcodec.codecs.h264.decode.SliceHeaderReader;
import org.jcodec.codecs.h264.decode.aso.MapManager;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.CABAC;
import org.jcodec.codecs.h264.io.CAVLC;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.tools.MathUtil;

public class SliceDecoder {
    private static final int[] NULL_VECTOR = new int[]{0, 0, -1};
    private SliceHeader sh;
    private CAVLC[] cavlc;
    private CABAC cabac;
    private Mapper mapper;
    private int[] chromaQpOffset;
    private int qp;
    private int[][] leftRow;
    private int[][] topLine;
    private int[][] topLeft;
    private int[] i4x4PredTop;
    private int[] i4x4PredLeft;
    private MBType[] topMBType;
    private MBType leftMBType;
    private ColorSpace chromaFormat;
    private boolean transform8x8;
    private int[][][] mvTop;
    private int[][][] mvLeft;
    private int[][] mvTopLeft;
    private SeqParameterSet activeSps;
    private PictureParameterSet activePps;
    private int[][] nCoeff;
    private int[][][][] mvs;
    private MBType[] mbTypes;
    private int[][] mbQps;
    private Frame thisFrame;
    private Frame[] sRefs;
    private IntObjectMap<Frame> lRefs;
    private MDecoder mDecoder;
    private SliceHeader[] shs;
    private int leftCBPLuma;
    private int[] topCBPLuma;
    private int leftCBPChroma;
    private int[] topCBPChroma;
    private int[] numRef;
    private boolean tf8x8Left;
    private boolean[] tf8x8Top;
    private H264Const.PartPred[] predModeLeft;
    private H264Const.PartPred[] predModeTop;
    private boolean[] tr8x8Used;
    private Frame[][][] refsUsed;
    private Prediction prediction;
    private boolean debug;

    public SliceDecoder(SeqParameterSet activeSps, PictureParameterSet activePps, int[][] nCoeff, int[][][][] mvs, MBType[] mbTypes, int[][] mbQps, SliceHeader[] shs, boolean[] tr8x8Used, Frame[][][] refsUsed, Frame result, Frame[] sRefs, IntObjectMap<Frame> lRefs) {
        this.activeSps = activeSps;
        this.activePps = activePps;
        this.nCoeff = nCoeff;
        this.mvs = mvs;
        this.mbTypes = mbTypes;
        this.mbQps = mbQps;
        this.shs = shs;
        this.thisFrame = result;
        this.sRefs = sRefs;
        this.lRefs = lRefs;
        this.tr8x8Used = tr8x8Used;
        this.refsUsed = refsUsed;
    }

    public void decode(ByteBuffer segment, NALUnit nalUnit) {
        BitReader in = new BitReader(segment);
        SliceHeaderReader shr = new SliceHeaderReader();
        this.sh = shr.readPart1(in);
        this.sh.sps = this.activeSps;
        this.sh.pps = this.activePps;
        this.cavlc = new CAVLC[]{new CAVLC(this.sh.sps, this.sh.pps, 2, 2), new CAVLC(this.sh.sps, this.sh.pps, 1, 1), new CAVLC(this.sh.sps, this.sh.pps, 1, 1)};
        int mbWidth = this.sh.sps.pic_width_in_mbs_minus1 + 1;
        this.cabac = new CABAC(mbWidth);
        this.chromaQpOffset = new int[]{this.sh.pps.chroma_qp_index_offset, this.sh.pps.extended != null ? this.sh.pps.extended.second_chroma_qp_index_offset : this.sh.pps.chroma_qp_index_offset};
        this.chromaFormat = this.sh.sps.chroma_format_idc;
        this.transform8x8 = this.sh.pps.extended == null ? false : this.sh.pps.extended.transform_8x8_mode_flag;
        this.i4x4PredLeft = new int[4];
        this.i4x4PredTop = new int[mbWidth << 2];
        this.topMBType = new MBType[mbWidth];
        this.topCBPLuma = new int[mbWidth];
        this.topCBPChroma = new int[mbWidth];
        this.mvTop = new int[2][(mbWidth << 2) + 1][3];
        this.mvLeft = new int[2][4][3];
        this.mvTopLeft = new int[2][3];
        this.leftRow = new int[3][16];
        this.topLeft = new int[3][4];
        this.topLine = new int[3][mbWidth << 4];
        this.predModeLeft = new H264Const.PartPred[2];
        this.predModeTop = new H264Const.PartPred[mbWidth << 1];
        this.tf8x8Top = new boolean[mbWidth];
        shr.readPart2(this.sh, nalUnit, this.sh.sps, this.sh.pps, in);
        this.prediction = new Prediction(this.sh);
        this.qp = this.sh.pps.pic_init_qp_minus26 + 26 + this.sh.slice_qp_delta;
        if (this.activePps.entropy_coding_mode_flag) {
            in.terminate();
            int[][] cm = new int[2][1024];
            this.cabac.initModels(cm, this.sh.slice_type, this.sh.cabac_init_idc, this.qp);
            this.mDecoder = new MDecoder(segment, cm);
        }
        this.numRef = this.sh.num_ref_idx_active_override_flag ? new int[]{this.sh.num_ref_idx_active_minus1[0] + 1, this.sh.num_ref_idx_active_minus1[1] + 1} : new int[]{this.activePps.num_ref_idx_active_minus1[0] + 1, this.activePps.num_ref_idx_active_minus1[1] + 1};
        this.debugPrint("============" + this.thisFrame.getPOC() + "============= " + this.sh.slice_type.name());
        Frame[][] refList = null;
        if (this.sh.slice_type == SliceType.P) {
            refList = new Frame[][]{this.buildRefListP(), null};
        } else if (this.sh.slice_type == SliceType.B) {
            refList = this.buildRefListB();
        }
        this.mapper = new MapManager(this.sh.sps, this.sh.pps).getMapper(this.sh);
        Picture mb = Picture.create(16, 16, this.sh.sps.chroma_format_idc);
        boolean mbaffFrameFlag = this.sh.sps.mb_adaptive_frame_field_flag && !this.sh.field_pic_flag;
        boolean prevMbSkipped = false;
        MBType prevMBType = null;
        int i2 = 0;
        while (true) {
            if (this.sh.slice_type.isInter() && !this.activePps.entropy_coding_mode_flag) {
                int mbSkipRun = CAVLCReader.readUE(in, "mb_skip_run");
                int j2 = 0;
                while (j2 < mbSkipRun) {
                    int mbAddr = this.mapper.getAddress(i2);
                    this.debugPrint("---------------------- MB (" + mbAddr % mbWidth + "," + mbAddr / mbWidth + ") ---------------------");
                    this.decodeSkip(refList, i2, mb, this.sh.slice_type);
                    this.shs[mbAddr] = this.sh;
                    this.refsUsed[mbAddr] = refList;
                    this.put(this.thisFrame, mb, this.mapper.getMbX(i2), this.mapper.getMbY(i2));
                    this.wipe(mb);
                    ++j2;
                    ++i2;
                }
                prevMbSkipped = mbSkipRun > 0;
                prevMBType = null;
                if (!CAVLCReader.moreRBSPData(in)) break;
            }
            int mbAddr = this.mapper.getAddress(i2);
            this.shs[mbAddr] = this.sh;
            this.refsUsed[mbAddr] = refList;
            int mbX = mbAddr % mbWidth;
            int mbY = mbAddr / mbWidth;
            this.debugPrint("---------------------- MB (" + mbX + "," + mbY + ") ---------------------");
            if (this.sh.slice_type.isIntra() || !this.activePps.entropy_coding_mode_flag || !this.cabac.readMBSkipFlag(this.mDecoder, this.sh.slice_type, this.mapper.leftAvailable(i2), this.mapper.topAvailable(i2), mbX)) {
                boolean mb_field_decoding_flag = false;
                if (mbaffFrameFlag && (i2 % 2 == 0 || i2 % 2 == 1 && prevMbSkipped)) {
                    mb_field_decoding_flag = CAVLCReader.readBool(in, "mb_field_decoding_flag");
                }
                prevMBType = this.decode(this.sh.slice_type, i2, in, mb_field_decoding_flag, prevMBType, mb, refList);
            } else {
                this.decodeSkip(refList, i2, mb, this.sh.slice_type);
                prevMBType = null;
            }
            this.put(this.thisFrame, mb, mbX, mbY);
            if (this.activePps.entropy_coding_mode_flag && this.mDecoder.decodeFinalBin() == 1 || !this.activePps.entropy_coding_mode_flag && !CAVLCReader.moreRBSPData(in)) break;
            this.wipe(mb);
            ++i2;
        }
    }

    private Frame[] buildRefListP() {
        int frame_num = this.sh.frame_num;
        int maxFrames = 1 << this.sh.sps.log2_max_frame_num_minus4 + 4;
        Picture[] result = new Frame[this.numRef[0]];
        int refs = 0;
        for (int i2 = frame_num - 1; i2 >= frame_num - maxFrames && refs < this.numRef[0]; --i2) {
            int fn;
            int n2 = fn = i2 < 0 ? i2 + maxFrames : i2;
            if (this.sRefs[fn] == null) continue;
            result[refs] = this.sRefs[fn] == H264Const.NO_PIC ? null : this.sRefs[fn];
            ++refs;
        }
        int[] keys = this.lRefs.keys();
        Arrays.sort(keys);
        for (int i3 = 0; i3 < keys.length && refs < this.numRef[0]; ++i3) {
            result[refs++] = this.lRefs.get(keys[i3]);
        }
        this.reorder(result, 0);
        return result;
    }

    private Frame[][] buildRefListB() {
        Object[] l1;
        Object[] l0 = this.buildList(Frame.POCDesc, Frame.POCAsc);
        if (Arrays.equals(l0, l1 = this.buildList(Frame.POCAsc, Frame.POCDesc)) && this.count((Frame[])l1) > 1) {
            Object frame = l1[1];
            l1[1] = l1[0];
            l1[0] = frame;
        }
        Frame[][] result = new Frame[][]{(Frame[])Arrays.copyOf(l0, this.numRef[0]), (Frame[])Arrays.copyOf(l1, this.numRef[1])};
        this.reorder(result[0], 0);
        this.reorder(result[1], 1);
        return result;
    }

    private Frame[] buildList(Comparator<Frame> cmpFwd, Comparator<Frame> cmpInv) {
        Frame[] refs = new Frame[this.sRefs.length + this.lRefs.size()];
        Frame[] fwd = this.copySort(cmpFwd, this.thisFrame);
        Frame[] inv = this.copySort(cmpInv, this.thisFrame);
        int nFwd = this.count(fwd);
        int nInv = this.count(inv);
        int ref = 0;
        int i2 = 0;
        while (i2 < nFwd) {
            refs[ref] = fwd[i2];
            ++i2;
            ++ref;
        }
        i2 = 0;
        while (i2 < nInv) {
            refs[ref] = inv[i2];
            ++i2;
            ++ref;
        }
        int[] keys = this.lRefs.keys();
        Arrays.sort(keys);
        int i3 = 0;
        while (i3 < keys.length) {
            refs[ref] = this.lRefs.get(keys[i3]);
            ++i3;
            ++ref;
        }
        return refs;
    }

    private int count(Frame[] arr) {
        for (int nn = 0; nn < arr.length; ++nn) {
            if (arr[nn] != null) continue;
            return nn;
        }
        return arr.length;
    }

    private Frame[] copySort(Comparator<Frame> fwd, Frame dummy) {
        Frame[] copyOf = Arrays.copyOf(this.sRefs, this.sRefs.length);
        for (int i2 = 0; i2 < copyOf.length; ++i2) {
            if (fwd.compare(dummy, copyOf[i2]) <= 0) continue;
            copyOf[i2] = null;
        }
        Arrays.sort(copyOf, fwd);
        return copyOf;
    }

    private void reorder(Picture[] result, int list) {
        if (this.sh.refPicReordering[list] == null) {
            return;
        }
        int predict = this.sh.frame_num;
        int maxFrames = 1 << this.sh.sps.log2_max_frame_num_minus4 + 4;
        for (int ind = 0; ind < this.sh.refPicReordering[list][0].length; ++ind) {
            int i2;
            switch (this.sh.refPicReordering[list][0][ind]) {
                case 0: {
                    predict = MathUtil.wrap(predict - this.sh.refPicReordering[list][1][ind] - 1, maxFrames);
                    break;
                }
                case 1: {
                    predict = MathUtil.wrap(predict + this.sh.refPicReordering[list][1][ind] + 1, maxFrames);
                    break;
                }
                case 2: {
                    throw new RuntimeException("long term");
                }
            }
            for (i2 = this.numRef[list] - 1; i2 > ind; --i2) {
                result[i2] = result[i2 - 1];
            }
            result[ind] = this.sRefs[predict];
            int j2 = i2 = ind + 1;
            while (i2 < this.numRef[list] && result[i2] != null) {
                if (result[i2] != this.sRefs[predict]) {
                    result[j2++] = result[i2];
                }
                ++i2;
            }
        }
    }

    private void wipe(Picture mb) {
        Arrays.fill(mb.getPlaneData(0), 0);
        Arrays.fill(mb.getPlaneData(1), 0);
        Arrays.fill(mb.getPlaneData(2), 0);
    }

    private void collectPredictors(Picture outMB, int mbX) {
        this.topLeft[0][0] = this.topLine[0][(mbX << 4) + 15];
        this.topLeft[0][1] = outMB.getPlaneData(0)[63];
        this.topLeft[0][2] = outMB.getPlaneData(0)[127];
        this.topLeft[0][3] = outMB.getPlaneData(0)[191];
        System.arraycopy(outMB.getPlaneData(0), 240, this.topLine[0], mbX << 4, 16);
        this.copyCol(outMB.getPlaneData(0), 16, 15, 16, this.leftRow[0]);
        this.collectChromaPredictors(outMB, mbX);
    }

    private void collectChromaPredictors(Picture outMB, int mbX) {
        this.topLeft[1][0] = this.topLine[1][(mbX << 3) + 7];
        this.topLeft[2][0] = this.topLine[2][(mbX << 3) + 7];
        System.arraycopy(outMB.getPlaneData(1), 56, this.topLine[1], mbX << 3, 8);
        System.arraycopy(outMB.getPlaneData(2), 56, this.topLine[2], mbX << 3, 8);
        this.copyCol(outMB.getPlaneData(1), 8, 7, 8, this.leftRow[1]);
        this.copyCol(outMB.getPlaneData(2), 8, 7, 8, this.leftRow[2]);
    }

    private void copyCol(int[] planeData, int n2, int off, int stride, int[] out) {
        int i2 = 0;
        while (i2 < n2) {
            out[i2] = planeData[off];
            ++i2;
            off += stride;
        }
    }

    public MBType decode(SliceType sliceType, int mbAddr, BitReader reader, boolean field, MBType prevMbType, Picture mb, Frame[][] references) {
        if (sliceType == SliceType.I) {
            return this.decodeMBlockI(mbAddr, reader, field, prevMbType, mb);
        }
        if (sliceType == SliceType.P) {
            return this.decodeMBlockP(mbAddr, reader, field, prevMbType, mb, references);
        }
        return this.decodeMBlockB(mbAddr, reader, field, prevMbType, mb, references);
    }

    private MBType decodeMBlockI(int mbIdx, BitReader reader, boolean field, MBType prevMbType, Picture mb) {
        int mbType = !this.activePps.entropy_coding_mode_flag ? CAVLCReader.readUE(reader, "MB: mb_type") : this.cabac.readMBTypeI(this.mDecoder, this.leftMBType, this.topMBType[this.mapper.getMbX(mbIdx)], this.mapper.leftAvailable(mbIdx), this.mapper.topAvailable(mbIdx));
        return this.decodeMBlockIInt(mbType, mbIdx, reader, field, prevMbType, mb);
    }

    private MBType decodeMBlockIInt(int mbType, int mbIdx, BitReader reader, boolean field, MBType prevMbType, Picture mb) {
        MBType mbt;
        if (mbType == 0) {
            this.decodeMBlockIntraNxN(reader, mbIdx, prevMbType, mb);
            mbt = MBType.I_NxN;
        } else if (mbType >= 1 && mbType <= 24) {
            this.decodeMBlockIntra16x16(reader, --mbType, mbIdx, prevMbType, mb);
            mbt = MBType.I_16x16;
        } else {
            System.out.println("IPCM!!!");
            this.decodeMBlockIPCM(reader, mbIdx, mb);
            mbt = MBType.I_PCM;
        }
        int xx = this.mapper.getMbX(mbIdx) << 2;
        this.copyVect(this.mvTopLeft[0], this.mvTop[0][xx + 3]);
        this.copyVect(this.mvTopLeft[1], this.mvTop[1][xx + 3]);
        this.saveVect(this.mvTop[0], xx, xx + 4, 0, 0, -1);
        this.saveVect(this.mvLeft[0], 0, 4, 0, 0, -1);
        this.saveVect(this.mvTop[1], xx, xx + 4, 0, 0, -1);
        this.saveVect(this.mvLeft[1], 0, 4, 0, 0, -1);
        return mbt;
    }

    private MBType decodeMBlockP(int mbIdx, BitReader reader, boolean field, MBType prevMbType, Picture mb, Frame[][] references) {
        int mbType = !this.activePps.entropy_coding_mode_flag ? CAVLCReader.readUE(reader, "MB: mb_type") : this.cabac.readMBTypeP(this.mDecoder);
        switch (mbType) {
            case 0: {
                this.decodeInter16x16(reader, mb, references, mbIdx, prevMbType, H264Const.PartPred.L0, MBType.P_16x16);
                return MBType.P_16x16;
            }
            case 1: {
                this.decodeInter16x8(reader, mb, references, mbIdx, prevMbType, H264Const.PartPred.L0, H264Const.PartPred.L0, MBType.P_16x8);
                return MBType.P_16x8;
            }
            case 2: {
                this.decodeInter8x16(reader, mb, references, mbIdx, prevMbType, H264Const.PartPred.L0, H264Const.PartPred.L0, MBType.P_8x16);
                return MBType.P_8x16;
            }
            case 3: {
                this.decodeMBInter8x8(reader, mbType, references, mb, SliceType.P, mbIdx, field, prevMbType, false);
                return MBType.P_8x8;
            }
            case 4: {
                this.decodeMBInter8x8(reader, mbType, references, mb, SliceType.P, mbIdx, field, prevMbType, true);
                return MBType.P_8x8ref0;
            }
        }
        return this.decodeMBlockIInt(mbType - 5, mbIdx, reader, field, prevMbType, mb);
    }

    private MBType decodeMBlockB(int mbIdx, BitReader reader, boolean field, MBType prevMbType, Picture mb, Frame[][] references) {
        int mbType = !this.activePps.entropy_coding_mode_flag ? CAVLCReader.readUE(reader, "MB: mb_type") : this.cabac.readMBTypeB(this.mDecoder, this.leftMBType, this.topMBType[this.mapper.getMbX(mbIdx)], this.mapper.leftAvailable(mbIdx), this.mapper.topAvailable(mbIdx));
        if (mbType >= 23) {
            return this.decodeMBlockIInt(mbType - 23, mbIdx, reader, field, prevMbType, mb);
        }
        MBType curMBType = H264Const.bMbTypes[mbType];
        if (mbType == 0) {
            this.decodeMBBiDirect(mbIdx, reader, field, prevMbType, mb, references);
        } else if (mbType <= 3) {
            this.decodeInter16x16(reader, mb, references, mbIdx, prevMbType, H264Const.bPredModes[mbType][0], curMBType);
        } else if (mbType == 22) {
            this.decodeMBInter8x8(reader, mbType, references, mb, SliceType.B, mbIdx, field, prevMbType, false);
        } else if ((mbType & 1) == 0) {
            this.decodeInter16x8(reader, mb, references, mbIdx, prevMbType, H264Const.bPredModes[mbType][0], H264Const.bPredModes[mbType][1], curMBType);
        } else {
            this.decodeInter8x16(reader, mb, references, mbIdx, prevMbType, H264Const.bPredModes[mbType][0], H264Const.bPredModes[mbType][1], curMBType);
        }
        return curMBType;
    }

    public void put(Picture tgt, Picture decoded, int mbX, int mbY) {
        int i2;
        int[] luma = tgt.getPlaneData(0);
        int stride = tgt.getPlaneWidth(0);
        int[] cb = tgt.getPlaneData(1);
        int[] cr = tgt.getPlaneData(2);
        int strideChroma = tgt.getPlaneWidth(1);
        int dOff = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            System.arraycopy(decoded.getPlaneData(0), dOff, luma, (mbY * 16 + i2) * stride + mbX * 16, 16);
            dOff += 16;
        }
        for (i2 = 0; i2 < 8; ++i2) {
            System.arraycopy(decoded.getPlaneData(1), i2 * 8, cb, (mbY * 8 + i2) * strideChroma + mbX * 8, 8);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            System.arraycopy(decoded.getPlaneData(2), i2 * 8, cr, (mbY * 8 + i2) * strideChroma + mbX * 8, 8);
        }
    }

    public void decodeMBlockIntra16x16(BitReader reader, int mbType, int mbIndex, MBType prevMbType, Picture mb) {
        int mbX = this.mapper.getMbX(mbIndex);
        int mbY = this.mapper.getMbY(mbIndex);
        int address = this.mapper.getAddress(mbIndex);
        int cbpChroma = mbType / 4 % 3;
        int cbpLuma = mbType / 12 * 15;
        boolean leftAvailable = this.mapper.leftAvailable(mbIndex);
        boolean topAvailable = this.mapper.topAvailable(mbIndex);
        int chromaPredictionMode = this.readChromaPredMode(reader, mbX, leftAvailable, topAvailable);
        int mbQPDelta = this.readMBQpDelta(reader, prevMbType);
        this.mbQps[0][address] = this.qp = (this.qp + mbQPDelta + 52) % 52;
        this.residualLumaI16x16(reader, leftAvailable, topAvailable, mbX, mbY, mb, cbpLuma);
        Intra16x16PredictionBuilder.predictWithMode(mbType % 4, mb.getPlaneData(0), leftAvailable, topAvailable, this.leftRow[0], this.topLine[0], this.topLeft[0], mbX << 4);
        this.decodeChroma(reader, cbpChroma, chromaPredictionMode, mbX, mbY, leftAvailable, topAvailable, mb, this.qp, MBType.I_16x16);
        this.topMBType[mbX] = this.leftMBType = MBType.I_16x16;
        this.mbTypes[address] = this.leftMBType;
        this.topCBPLuma[mbX] = this.leftCBPLuma = cbpLuma;
        this.topCBPChroma[mbX] = this.leftCBPChroma = cbpChroma;
        this.tf8x8Top[mbX] = false;
        this.tf8x8Left = false;
        this.collectPredictors(mb, mbX);
        this.saveMvsIntra(mbX, mbY);
    }

    private int readMBQpDelta(BitReader reader, MBType prevMbType) {
        int mbQPDelta = !this.activePps.entropy_coding_mode_flag ? CAVLCReader.readSE(reader, "mb_qp_delta") : this.cabac.readMBQpDelta(this.mDecoder, prevMbType);
        return mbQPDelta;
    }

    private int readChromaPredMode(BitReader reader, int mbX, boolean leftAvailable, boolean topAvailable) {
        int chromaPredictionMode = !this.activePps.entropy_coding_mode_flag ? CAVLCReader.readUE(reader, "MBP: intra_chroma_pred_mode") : this.cabac.readIntraChromaPredMode(this.mDecoder, mbX, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable);
        return chromaPredictionMode;
    }

    private void residualLumaI16x16(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int cbpLuma) {
        int[] dc = new int[16];
        if (!this.activePps.entropy_coding_mode_flag) {
            this.cavlc[0].readLumaDCBlock(reader, dc, mbX, leftAvailable, this.leftMBType, topAvailable, this.topMBType[mbX], CoeffTransformer.zigzag4x4);
        } else if (this.cabac.readCodedBlockFlagLumaDC(this.mDecoder, mbX, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable, MBType.I_16x16) == 1) {
            this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.LUMA_16_DC, dc, 0, 16, CoeffTransformer.zigzag4x4, H264Const.identityMapping16, H264Const.identityMapping16);
        }
        CoeffTransformer.invDC4x4(dc);
        CoeffTransformer.dequantizeDC4x4(dc, this.qp);
        CoeffTransformer.reorderDC4x4(dc);
        for (int i2 = 0; i2 < 16; ++i2) {
            int[] ac = new int[16];
            int blkOffLeft = H264Const.MB_BLK_OFF_LEFT[i2];
            int blkOffTop = H264Const.MB_BLK_OFF_TOP[i2];
            int blkX = (mbX << 2) + blkOffLeft;
            int blkY = (mbY << 2) + blkOffTop;
            if ((cbpLuma & 1 << (i2 >> 2)) != 0) {
                if (!this.activePps.entropy_coding_mode_flag) {
                    this.nCoeff[blkY][blkX] = this.cavlc[0].readACBlock(reader, ac, blkX, blkOffTop, blkOffLeft != 0 || leftAvailable, blkOffLeft == 0 ? this.leftMBType : MBType.I_16x16, blkOffTop != 0 || topAvailable, blkOffTop == 0 ? this.topMBType[mbX] : MBType.I_16x16, 1, 15, CoeffTransformer.zigzag4x4);
                } else if (this.cabac.readCodedBlockFlagLumaAC(this.mDecoder, CABAC.BlockType.LUMA_15_AC, blkX, blkOffTop, 0, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable, this.leftCBPLuma, this.topCBPLuma[mbX], cbpLuma, MBType.I_16x16) == 1) {
                    this.nCoeff[blkY][blkX] = this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.LUMA_15_AC, ac, 1, 15, CoeffTransformer.zigzag4x4, H264Const.identityMapping16, H264Const.identityMapping16);
                }
                CoeffTransformer.dequantizeAC(ac, this.qp);
            } else if (!this.activePps.entropy_coding_mode_flag) {
                this.cavlc[0].setZeroCoeff(blkX, blkOffTop);
            }
            ac[0] = dc[i2];
            CoeffTransformer.idct4x4(ac);
            this.putBlk(mb.getPlaneData(0), ac, 4, blkOffLeft << 2, blkOffTop << 2);
        }
    }

    private void putBlk(int[] planeData, int[] block, int log2stride, int blkX, int blkY) {
        int stride = 1 << log2stride;
        int srcOff = 0;
        int dstOff = (blkY << log2stride) + blkX;
        for (int line = 0; line < 4; ++line) {
            planeData[dstOff] = block[srcOff];
            planeData[dstOff + 1] = block[srcOff + 1];
            planeData[dstOff + 2] = block[srcOff + 2];
            planeData[dstOff + 3] = block[srcOff + 3];
            srcOff += 4;
            dstOff += stride;
        }
    }

    private void putBlk8x8(int[] planeData, int[] block, int log2stride, int blkX, int blkY) {
        int stride = 1 << log2stride;
        int srcOff = 0;
        int dstOff = (blkY << log2stride) + blkX;
        for (int line = 0; line < 8; ++line) {
            for (int row = 0; row < 8; ++row) {
                planeData[dstOff + row] = block[srcOff + row];
            }
            srcOff += 8;
            dstOff += stride;
        }
    }

    public void decodeChroma(BitReader reader, int pattern, int chromaMode, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, Picture mb, int qp, MBType curMbType) {
        if (this.chromaFormat == ColorSpace.MONO) {
            Arrays.fill(mb.getPlaneData(1), 128);
            Arrays.fill(mb.getPlaneData(2), 128);
            return;
        }
        int qp1 = this.calcQpChroma(qp, this.chromaQpOffset[0]);
        int qp2 = this.calcQpChroma(qp, this.chromaQpOffset[1]);
        if (pattern != 0) {
            this.decodeChromaResidual(reader, leftAvailable, topAvailable, mbX, mbY, pattern, mb, qp1, qp2, curMbType);
        } else if (!this.activePps.entropy_coding_mode_flag) {
            this.cavlc[1].setZeroCoeff(mbX << 1, 0);
            this.cavlc[1].setZeroCoeff((mbX << 1) + 1, 1);
            this.cavlc[2].setZeroCoeff(mbX << 1, 0);
            this.cavlc[2].setZeroCoeff((mbX << 1) + 1, 1);
        }
        int addr = mbY * (this.activeSps.pic_width_in_mbs_minus1 + 1) + mbX;
        this.mbQps[1][addr] = qp1;
        this.mbQps[2][addr] = qp2;
        ChromaPredictionBuilder.predictWithMode(mb.getPlaneData(1), chromaMode, mbX, leftAvailable, topAvailable, this.leftRow[1], this.topLine[1], this.topLeft[1]);
        ChromaPredictionBuilder.predictWithMode(mb.getPlaneData(2), chromaMode, mbX, leftAvailable, topAvailable, this.leftRow[2], this.topLine[2], this.topLeft[2]);
    }

    private void decodeChromaResidual(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, int pattern, Picture mb, int crQp1, int crQp2, MBType curMbType) {
        int[] dc1 = new int[16 >> this.chromaFormat.compWidth[1] >> this.chromaFormat.compHeight[1]];
        int[] dc2 = new int[16 >> this.chromaFormat.compWidth[2] >> this.chromaFormat.compHeight[2]];
        if ((pattern & 3) > 0) {
            this.chromaDC(reader, mbX, leftAvailable, topAvailable, dc1, 1, crQp1, curMbType);
            this.chromaDC(reader, mbX, leftAvailable, topAvailable, dc2, 2, crQp2, curMbType);
        }
        this.chromaAC(reader, leftAvailable, topAvailable, mbX, mbY, mb, dc1, 1, crQp1, curMbType, (pattern & 2) > 0);
        this.chromaAC(reader, leftAvailable, topAvailable, mbX, mbY, mb, dc2, 2, crQp2, curMbType, (pattern & 2) > 0);
    }

    private void chromaDC(BitReader reader, int mbX, boolean leftAvailable, boolean topAvailable, int[] dc, int comp, int crQp, MBType curMbType) {
        if (!this.activePps.entropy_coding_mode_flag) {
            this.cavlc[comp].readChromaDCBlock(reader, dc, leftAvailable, topAvailable);
        } else if (this.cabac.readCodedBlockFlagChromaDC(this.mDecoder, mbX, comp, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable, this.leftCBPChroma, this.topCBPChroma[mbX], curMbType) == 1) {
            this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.CHROMA_DC, dc, 0, 4, H264Const.identityMapping16, H264Const.identityMapping16, H264Const.identityMapping16);
        }
        CoeffTransformer.invDC2x2(dc);
        CoeffTransformer.dequantizeDC2x2(dc, crQp);
    }

    private void chromaAC(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int[] dc, int comp, int crQp, MBType curMbType, boolean codedAC) {
        for (int i2 = 0; i2 < dc.length; ++i2) {
            int[] ac = new int[16];
            int blkOffLeft = H264Const.MB_BLK_OFF_LEFT[i2];
            int blkOffTop = H264Const.MB_BLK_OFF_TOP[i2];
            int blkX = (mbX << 1) + blkOffLeft;
            int blkY = (mbY << 1) + blkOffTop;
            if (codedAC) {
                if (!this.activePps.entropy_coding_mode_flag) {
                    this.cavlc[comp].readACBlock(reader, ac, blkX, blkOffTop, blkOffLeft != 0 || leftAvailable, blkOffLeft == 0 ? this.leftMBType : curMbType, blkOffTop != 0 || topAvailable, blkOffTop == 0 ? this.topMBType[mbX] : curMbType, 1, 15, CoeffTransformer.zigzag4x4);
                } else if (this.cabac.readCodedBlockFlagChromaAC(this.mDecoder, blkX, blkOffTop, comp, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable, this.leftCBPChroma, this.topCBPChroma[mbX], curMbType) == 1) {
                    this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.CHROMA_AC, ac, 1, 15, CoeffTransformer.zigzag4x4, H264Const.identityMapping16, H264Const.identityMapping16);
                }
                CoeffTransformer.dequantizeAC(ac, crQp);
            } else if (!this.activePps.entropy_coding_mode_flag) {
                this.cavlc[comp].setZeroCoeff(blkX, blkOffTop);
            }
            ac[0] = dc[i2];
            CoeffTransformer.idct4x4(ac);
            this.putBlk(mb.getPlaneData(comp), ac, 3, blkOffLeft << 2, blkOffTop << 2);
        }
    }

    private int calcQpChroma(int qp, int crQpOffset) {
        return H264Const.QP_SCALE_CR[MathUtil.clip(qp + crQpOffset, 0, 51)];
    }

    public void decodeMBlockIntraNxN(BitReader reader, int mbIndex, MBType prevMbType, Picture mb) {
        int blkY;
        int blkX;
        int i2;
        int[] lumaModes;
        int mbX = this.mapper.getMbX(mbIndex);
        int mbY = this.mapper.getMbY(mbIndex);
        int mbAddr = this.mapper.getAddress(mbIndex);
        boolean leftAvailable = this.mapper.leftAvailable(mbIndex);
        boolean topAvailable = this.mapper.topAvailable(mbIndex);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mbIndex);
        boolean topRightAvailable = this.mapper.topRightAvailable(mbIndex);
        boolean transform8x8Used = false;
        if (this.transform8x8) {
            transform8x8Used = this.readTransform8x8Flag(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.tf8x8Left, this.tf8x8Top[mbX]);
        }
        if (!transform8x8Used) {
            lumaModes = new int[16];
            for (i2 = 0; i2 < 16; ++i2) {
                blkX = H264Const.MB_BLK_OFF_LEFT[i2];
                blkY = H264Const.MB_BLK_OFF_TOP[i2];
                lumaModes[i2] = this.readPredictionI4x4Block(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], blkX, blkY, mbX);
            }
        } else {
            lumaModes = new int[4];
            for (i2 = 0; i2 < 4; ++i2) {
                blkX = (i2 & 1) << 1;
                blkY = i2 & 2;
                lumaModes[i2] = this.readPredictionI4x4Block(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], blkX, blkY, mbX);
                this.i4x4PredLeft[blkY + 1] = this.i4x4PredLeft[blkY];
                this.i4x4PredTop[(mbX << 2) + blkX + 1] = this.i4x4PredTop[(mbX << 2) + blkX];
            }
        }
        int chromaMode = this.readChromaPredMode(reader, mbX, leftAvailable, topAvailable);
        int codedBlockPattern = this.readCodedBlockPatternIntra(reader, leftAvailable, topAvailable, this.leftCBPLuma | this.leftCBPChroma << 4, this.topCBPLuma[mbX] | this.topCBPChroma[mbX] << 4, this.leftMBType, this.topMBType[mbX]);
        int cbpLuma = codedBlockPattern & 0xF;
        int cbpChroma = codedBlockPattern >> 4;
        if (cbpLuma > 0 || cbpChroma > 0) {
            this.qp = (this.qp + this.readMBQpDelta(reader, prevMbType) + 52) % 52;
        }
        this.mbQps[0][mbAddr] = this.qp;
        this.residualLuma(reader, leftAvailable, topAvailable, mbX, mbY, mb, codedBlockPattern, MBType.I_NxN, transform8x8Used, this.tf8x8Left, this.tf8x8Top[mbX]);
        if (!transform8x8Used) {
            for (int i3 = 0; i3 < 16; ++i3) {
                int blkX2 = (i3 & 3) << 2;
                int blkY2 = i3 & 0xFFFFFFFC;
                int bi = H264Const.BLK_INV_MAP[i3];
                boolean trAvailable = (bi == 0 || bi == 1 || bi == 4) && topAvailable || bi == 5 && topRightAvailable || bi == 2 || bi == 6 || bi == 8 || bi == 9 || bi == 10 || bi == 12 || bi == 14;
                Intra4x4PredictionBuilder.predictWithMode(lumaModes[bi], mb.getPlaneData(0), blkX2 == 0 ? leftAvailable : true, blkY2 == 0 ? topAvailable : true, trAvailable, this.leftRow[0], this.topLine[0], this.topLeft[0], mbX << 4, blkX2, blkY2);
            }
        } else {
            for (int i4 = 0; i4 < 4; ++i4) {
                boolean trAvailable;
                int blkX3 = (i4 & 1) << 1;
                int blkY3 = i4 & 2;
                boolean bl = trAvailable = i4 == 0 && topAvailable || i4 == 1 && topRightAvailable || i4 == 2;
                boolean tlAvailable = i4 == 0 ? topLeftAvailable : (i4 == 1 ? topAvailable : (i4 == 2 ? leftAvailable : true));
                Intra8x8PredictionBuilder.predictWithMode(lumaModes[i4], mb.getPlaneData(0), blkX3 == 0 ? leftAvailable : true, blkY3 == 0 ? topAvailable : true, tlAvailable, trAvailable, this.leftRow[0], this.topLine[0], this.topLeft[0], mbX << 4, blkX3 << 2, blkY3 << 2);
            }
        }
        this.decodeChroma(reader, cbpChroma, chromaMode, mbX, mbY, leftAvailable, topAvailable, mb, this.qp, MBType.I_NxN);
        this.topMBType[mbX] = this.leftMBType = MBType.I_NxN;
        this.mbTypes[mbAddr] = this.leftMBType;
        this.topCBPLuma[mbX] = this.leftCBPLuma = cbpLuma;
        this.topCBPChroma[mbX] = this.leftCBPChroma = cbpChroma;
        this.tf8x8Left = this.tf8x8Top[mbX] = transform8x8Used;
        this.tr8x8Used[mbAddr] = transform8x8Used;
        this.collectChromaPredictors(mb, mbX);
        this.saveMvsIntra(mbX, mbY);
    }

    private void saveMvsIntra(int mbX, int mbY) {
        int j2 = 0;
        int blkOffY = mbY << 2;
        int blkInd = 0;
        while (j2 < 4) {
            int i2 = 0;
            int blkOffX = mbX << 2;
            while (i2 < 4) {
                this.mvs[0][blkOffY][blkOffX] = NULL_VECTOR;
                this.mvs[1][blkOffY][blkOffX] = NULL_VECTOR;
                ++i2;
                ++blkOffX;
                ++blkInd;
            }
            ++j2;
            ++blkOffY;
        }
    }

    private void residualLuma(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int codedBlockPattern, MBType mbType, boolean transform8x8Used, boolean is8x8Left, boolean is8x8Top) {
        if (!transform8x8Used) {
            this.residualLuma(reader, leftAvailable, topAvailable, mbX, mbY, mb, codedBlockPattern, mbType);
        } else if (this.activePps.entropy_coding_mode_flag) {
            this.residualLuma8x8CABAC(reader, leftAvailable, topAvailable, mbX, mbY, mb, codedBlockPattern, mbType, is8x8Left, is8x8Top);
        } else {
            this.residualLuma8x8CAVLC(reader, leftAvailable, topAvailable, mbX, mbY, mb, codedBlockPattern, mbType);
        }
    }

    private boolean readTransform8x8Flag(BitReader reader, boolean leftAvailable, boolean topAvailable, MBType leftType, MBType topType, boolean is8x8Left, boolean is8x8Top) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readBool(reader, "transform_size_8x8_flag");
        }
        return this.cabac.readTransform8x8Flag(this.mDecoder, leftAvailable, topAvailable, leftType, topType, is8x8Left, is8x8Top);
    }

    protected int readCodedBlockPatternIntra(BitReader reader, boolean leftAvailable, boolean topAvailable, int leftCBP, int topCBP, MBType leftMB, MBType topMB) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return H264Const.CODED_BLOCK_PATTERN_INTRA_COLOR[CAVLCReader.readUE(reader, "coded_block_pattern")];
        }
        return this.cabac.codedBlockPatternIntra(this.mDecoder, leftAvailable, topAvailable, leftCBP, topCBP, leftMB, topMB);
    }

    protected int readCodedBlockPatternInter(BitReader reader, boolean leftAvailable, boolean topAvailable, int leftCBP, int topCBP, MBType leftMB, MBType topMB) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return H264Const.CODED_BLOCK_PATTERN_INTER_COLOR[CAVLCReader.readUE(reader, "coded_block_pattern")];
        }
        return this.cabac.codedBlockPatternIntra(this.mDecoder, leftAvailable, topAvailable, leftCBP, topCBP, leftMB, topMB);
    }

    private void residualLuma(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int codedBlockPattern, MBType curMbType) {
        int cbpLuma = codedBlockPattern & 0xF;
        for (int i2 = 0; i2 < 16; ++i2) {
            int blkOffLeft = H264Const.MB_BLK_OFF_LEFT[i2];
            int blkOffTop = H264Const.MB_BLK_OFF_TOP[i2];
            int blkX = (mbX << 2) + blkOffLeft;
            int blkY = (mbY << 2) + blkOffTop;
            if ((cbpLuma & 1 << (i2 >> 2)) == 0) {
                if (this.activePps.entropy_coding_mode_flag) continue;
                this.cavlc[0].setZeroCoeff(blkX, blkOffTop);
                continue;
            }
            int[] ac = new int[16];
            if (!this.activePps.entropy_coding_mode_flag) {
                this.nCoeff[blkY][blkX] = this.cavlc[0].readACBlock(reader, ac, blkX, blkOffTop, blkOffLeft != 0 || leftAvailable, blkOffLeft == 0 ? this.leftMBType : curMbType, blkOffTop != 0 || topAvailable, blkOffTop == 0 ? this.topMBType[mbX] : curMbType, 0, 16, CoeffTransformer.zigzag4x4);
            } else if (this.cabac.readCodedBlockFlagLumaAC(this.mDecoder, CABAC.BlockType.LUMA_16, blkX, blkOffTop, 0, this.leftMBType, this.topMBType[mbX], leftAvailable, topAvailable, this.leftCBPLuma, this.topCBPLuma[mbX], cbpLuma, curMbType) == 1) {
                this.nCoeff[blkY][blkX] = this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.LUMA_16, ac, 0, 16, CoeffTransformer.zigzag4x4, H264Const.identityMapping16, H264Const.identityMapping16);
            }
            CoeffTransformer.dequantizeAC(ac, this.qp);
            CoeffTransformer.idct4x4(ac);
            this.putBlk(mb.getPlaneData(0), ac, 4, blkOffLeft << 2, blkOffTop << 2);
        }
        if (this.activePps.entropy_coding_mode_flag) {
            this.cabac.setPrevCBP(codedBlockPattern);
        }
    }

    private void residualLuma8x8CABAC(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int codedBlockPattern, MBType curMbType, boolean is8x8Left, boolean is8x8Top) {
        int cbpLuma = codedBlockPattern & 0xF;
        for (int i2 = 0; i2 < 4; ++i2) {
            int blkOffLeft = (i2 & 1) << 1;
            int blkOffTop = i2 & 2;
            int blkX = (mbX << 2) + blkOffLeft;
            int blkY = (mbY << 2) + blkOffTop;
            if ((cbpLuma & 1 << i2) == 0) continue;
            int[] ac = new int[64];
            int n2 = this.cabac.readCoeffs(this.mDecoder, CABAC.BlockType.LUMA_64, ac, 0, 64, CoeffTransformer.zigzag8x8, H264Const.sig_coeff_map_8x8, H264Const.last_sig_coeff_map_8x8);
            this.nCoeff[blkY + 1][blkX + 1] = n2;
            this.nCoeff[blkY + 1][blkX] = n2;
            this.nCoeff[blkY][blkX + 1] = n2;
            this.nCoeff[blkY][blkX] = n2;
            this.cabac.setCodedBlock(blkX, blkY);
            this.cabac.setCodedBlock(blkX + 1, blkY);
            this.cabac.setCodedBlock(blkX, blkY + 1);
            this.cabac.setCodedBlock(blkX + 1, blkY + 1);
            CoeffTransformer.dequantizeAC8x8(ac, this.qp);
            CoeffTransformer.idct8x8(ac);
            this.putBlk8x8(mb.getPlaneData(0), ac, 4, blkOffLeft << 2, blkOffTop << 2);
        }
        this.cabac.setPrevCBP(codedBlockPattern);
    }

    private void residualLuma8x8CAVLC(BitReader reader, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, Picture mb, int codedBlockPattern, MBType curMbType) {
        int cbpLuma = codedBlockPattern & 0xF;
        for (int i2 = 0; i2 < 4; ++i2) {
            int blk8x8OffLeft = (i2 & 1) << 1;
            int blk8x8OffTop = i2 & 2;
            int blkX = (mbX << 2) + blk8x8OffLeft;
            int blkY = (mbY << 2) + blk8x8OffTop;
            if ((cbpLuma & 1 << i2) == 0) {
                this.cavlc[0].setZeroCoeff(blkX, blk8x8OffTop);
                this.cavlc[0].setZeroCoeff(blkX + 1, blk8x8OffTop);
                this.cavlc[0].setZeroCoeff(blkX, blk8x8OffTop + 1);
                this.cavlc[0].setZeroCoeff(blkX + 1, blk8x8OffTop + 1);
                continue;
            }
            int[] ac64 = new int[64];
            int coeffs = 0;
            for (int j2 = 0; j2 < 4; ++j2) {
                int[] ac16 = new int[16];
                int blkOffLeft = blk8x8OffLeft + (j2 & 1);
                int blkOffTop = blk8x8OffTop + (j2 >> 1);
                coeffs += this.cavlc[0].readACBlock(reader, ac16, blkX + (j2 & 1), blkOffTop, blkOffLeft != 0 || leftAvailable, blkOffLeft == 0 ? this.leftMBType : curMbType, blkOffTop != 0 || topAvailable, blkOffTop == 0 ? this.topMBType[mbX] : curMbType, 0, 16, H264Const.identityMapping16);
                for (int k2 = 0; k2 < 16; ++k2) {
                    ac64[CoeffTransformer.zigzag8x8[(k2 << 2) + j2]] = ac16[k2];
                }
            }
            int n2 = coeffs;
            this.nCoeff[blkY + 1][blkX + 1] = n2;
            this.nCoeff[blkY + 1][blkX] = n2;
            this.nCoeff[blkY][blkX + 1] = n2;
            this.nCoeff[blkY][blkX] = n2;
            CoeffTransformer.dequantizeAC8x8(ac64, this.qp);
            CoeffTransformer.idct8x8(ac64);
            this.putBlk8x8(mb.getPlaneData(0), ac64, 4, blk8x8OffLeft << 2, blk8x8OffTop << 2);
        }
    }

    private int readPredictionI4x4Block(BitReader reader, boolean leftAvailable, boolean topAvailable, MBType leftMBType, MBType topMBType, int blkX, int blkY, int mbX) {
        int mode = 2;
        if ((leftAvailable || blkX > 0) && (topAvailable || blkY > 0)) {
            int predModeB = topMBType == MBType.I_NxN || blkY > 0 ? this.i4x4PredTop[(mbX << 2) + blkX] : 2;
            int predModeA = leftMBType == MBType.I_NxN || blkX > 0 ? this.i4x4PredLeft[blkY] : 2;
            mode = Math.min(predModeB, predModeA);
        }
        if (!this.prev4x4PredMode(reader)) {
            int rem_intra4x4_pred_mode;
            mode = rem_intra4x4_pred_mode + ((rem_intra4x4_pred_mode = this.rem4x4PredMode(reader)) < mode ? 0 : 1);
        }
        this.i4x4PredTop[(mbX << 2) + blkX] = this.i4x4PredLeft[blkY] = mode;
        return mode;
    }

    private int rem4x4PredMode(BitReader reader) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readNBit(reader, 3, "MB: rem_intra4x4_pred_mode");
        }
        return this.cabac.rem4x4PredMode(this.mDecoder);
    }

    private boolean prev4x4PredMode(BitReader reader) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readBool(reader, "MBP: prev_intra4x4_pred_mode_flag");
        }
        return this.cabac.prev4x4PredModeFlag(this.mDecoder);
    }

    private void decodeInter16x8(BitReader reader, Picture mb, Frame[][] refs, int mbIdx, MBType prevMbType, H264Const.PartPred p0, H264Const.PartPred p1, MBType curMBType) {
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mbIdx);
        int address = this.mapper.getAddress(mbIdx);
        int xx = mbX << 2;
        int[] refIdx1 = new int[]{0, 0};
        int[] refIdx2 = new int[]{0, 0};
        int[][][] x = new int[2][][];
        for (int list = 0; list < 2; ++list) {
            if (p0.usesList(list) && this.numRef[list] > 1) {
                refIdx1[list] = this.readRefIdx(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[mbX << 1], p0, mbX, 0, 0, 4, 2, list);
            }
            if (!p1.usesList(list) || this.numRef[list] <= 1) continue;
            refIdx2[list] = this.readRefIdx(reader, leftAvailable, true, this.leftMBType, curMBType, this.predModeLeft[1], p0, p1, mbX, 0, 2, 4, 2, list);
        }
        Picture[] mbb = new Picture[]{Picture.create(16, 16, this.chromaFormat), Picture.create(16, 16, this.chromaFormat)};
        for (int list = 0; list < 2; ++list) {
            this.predictInter16x8(reader, mbb[list], refs, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, xx, refIdx1, refIdx2, x, p0, p1, list);
        }
        this.prediction.mergePrediction(x[0][0][2], x[1][0][2], p0, 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), 0, 16, 16, 8, mb.getPlaneData(0), refs, this.thisFrame);
        this.prediction.mergePrediction(x[0][8][2], x[1][8][2], p1, 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), 128, 16, 16, 8, mb.getPlaneData(0), refs, this.thisFrame);
        this.predModeLeft[0] = p0;
        H264Const.PartPred partPred = p1;
        this.predModeTop[(mbX << 1) + 1] = partPred;
        this.predModeTop[mbX << 1] = partPred;
        this.predModeLeft[1] = partPred;
        this.residualInter(reader, mb, refs, leftAvailable, topAvailable, mbX, mbY, x, new H264Const.PartPred[]{p0, p0, p1, p1}, this.mapper.getAddress(mbIdx), prevMbType, curMBType);
        this.collectPredictors(mb, mbX);
        this.topMBType[mbX] = this.leftMBType = curMBType;
        this.mbTypes[address] = this.leftMBType;
    }

    private void predictInter16x8(BitReader reader, Picture mb, Picture[][] references, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean trAvailable, int xx, int[] refIdx1, int[] refIdx2, int[][][] x, H264Const.PartPred p0, H264Const.PartPred p1, int list) {
        int blk8x8X = mbX << 1;
        int mvX1 = 0;
        int mvY1 = 0;
        int mvX2 = 0;
        int mvY2 = 0;
        int r1 = -1;
        int r2 = -1;
        if (p0.usesList(list)) {
            int mvdX1 = this.readMVD(reader, 0, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], p0, mbX, 0, 0, 4, 2, list);
            int mvdY1 = this.readMVD(reader, 1, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], p0, mbX, 0, 0, 4, 2, list);
            int mvpX1 = this.calcMVPrediction16x8Top(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 4], this.mvTopLeft[list], leftAvailable, topAvailable, trAvailable, tlAvailable, refIdx1[list], 0);
            int mvpY1 = this.calcMVPrediction16x8Top(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 4], this.mvTopLeft[list], leftAvailable, topAvailable, trAvailable, tlAvailable, refIdx1[list], 1);
            mvX1 = mvdX1 + mvpX1;
            mvY1 = mvdY1 + mvpY1;
            this.debugPrint("MVP: (" + mvpX1 + ", " + mvpY1 + "), MVD: (" + mvdX1 + ", " + mvdY1 + "), MV: (" + mvX1 + "," + mvY1 + "," + refIdx1[list] + ")");
            BlockInterpolator.getBlockLuma(references[list][refIdx1[list]], mb, 0, (mbX << 6) + mvX1, (mbY << 6) + mvY1, 16, 8);
            r1 = refIdx1[list];
        }
        int[] v1 = new int[]{mvX1, mvY1, r1};
        if (p1.usesList(list)) {
            int mvdX2 = this.readMVD(reader, 0, leftAvailable, true, this.leftMBType, MBType.P_16x8, this.predModeLeft[1], p0, p1, mbX, 0, 2, 4, 2, list);
            int mvdY2 = this.readMVD(reader, 1, leftAvailable, true, this.leftMBType, MBType.P_16x8, this.predModeLeft[1], p0, p1, mbX, 0, 2, 4, 2, list);
            int mvpX2 = this.calcMVPrediction16x8Bottom(this.mvLeft[list][2], v1, null, this.mvLeft[list][1], leftAvailable, true, false, leftAvailable, refIdx2[list], 0);
            int mvpY2 = this.calcMVPrediction16x8Bottom(this.mvLeft[list][2], v1, null, this.mvLeft[list][1], leftAvailable, true, false, leftAvailable, refIdx2[list], 1);
            mvX2 = mvdX2 + mvpX2;
            mvY2 = mvdY2 + mvpY2;
            this.debugPrint("MVP: (" + mvpX2 + ", " + mvpY2 + "), MVD: (" + mvdX2 + ", " + mvdY2 + "), MV: (" + mvX2 + "," + mvY2 + "," + refIdx2[list] + ")");
            BlockInterpolator.getBlockLuma(references[list][refIdx2[list]], mb, 128, (mbX << 6) + mvX2, (mbY << 6) + 32 + mvY2, 16, 8);
            r2 = refIdx2[list];
        }
        int[] v2 = new int[]{mvX2, mvY2, r2};
        this.copyVect(this.mvTopLeft[list], this.mvTop[list][xx + 3]);
        this.saveVect(this.mvLeft[list], 0, 2, mvX1, mvY1, r1);
        this.saveVect(this.mvLeft[list], 2, 4, mvX2, mvY2, r2);
        this.saveVect(this.mvTop[list], xx, xx + 4, mvX2, mvY2, r2);
        x[list] = new int[][]{v1, v1, v1, v1, v1, v1, v1, v1, v2, v2, v2, v2, v2, v2, v2, v2};
    }

    private void residualInter(BitReader reader, Picture mb, Frame[][] refs, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, int[][][] x, H264Const.PartPred[] pp, int mbAddr, MBType prevMbType, MBType curMbType) {
        int codedBlockPattern = this.readCodedBlockPatternInter(reader, leftAvailable, topAvailable, this.leftCBPLuma | this.leftCBPChroma << 4, this.topCBPLuma[mbX] | this.topCBPChroma[mbX] << 4, this.leftMBType, this.topMBType[mbX]);
        int cbpLuma = codedBlockPattern & 0xF;
        int cbpChroma = codedBlockPattern >> 4;
        Picture mb1 = Picture.create(16, 16, this.chromaFormat);
        boolean transform8x8Used = false;
        if (cbpLuma > 0 && this.transform8x8) {
            transform8x8Used = this.readTransform8x8Flag(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.tf8x8Left, this.tf8x8Top[mbX]);
        }
        if (cbpLuma > 0 || cbpChroma > 0) {
            int mbQpDelta = this.readMBQpDelta(reader, prevMbType);
            this.qp = (this.qp + mbQpDelta + 52) % 52;
        }
        this.mbQps[0][mbAddr] = this.qp;
        this.residualLuma(reader, leftAvailable, topAvailable, mbX, mbY, mb1, codedBlockPattern, curMbType, transform8x8Used, this.tf8x8Left, this.tf8x8Top[mbX]);
        this.saveMvs(x, mbX, mbY);
        if (this.chromaFormat == ColorSpace.MONO) {
            Arrays.fill(mb.getPlaneData(1), 128);
            Arrays.fill(mb.getPlaneData(2), 128);
        } else {
            this.decodeChromaInter(reader, cbpChroma, refs, x, pp, leftAvailable, topAvailable, mbX, mbY, mbAddr, this.qp, mb, mb1);
        }
        this.mergeResidual(mb, mb1);
        this.topCBPLuma[mbX] = this.leftCBPLuma = cbpLuma;
        this.topCBPChroma[mbX] = this.leftCBPChroma = cbpChroma;
        this.tf8x8Left = this.tf8x8Top[mbX] = transform8x8Used;
        this.tr8x8Used[mbAddr] = transform8x8Used;
    }

    private void mergeResidual(Picture mb, Picture mb1) {
        for (int j2 = 0; j2 < 3; ++j2) {
            int[] to = mb.getPlaneData(j2);
            int[] from = mb1.getPlaneData(j2);
            for (int i2 = 0; i2 < to.length; ++i2) {
                to[i2] = MathUtil.clip(to[i2] + from[i2], 0, 255);
            }
        }
    }

    private void decodeInter8x16(BitReader reader, Picture mb, Frame[][] refs, int mbIdx, MBType prevMbType, H264Const.PartPred p0, H264Const.PartPred p1, MBType curMBType) {
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mbIdx);
        int address = this.mapper.getAddress(mbIdx);
        int[][][] x = new int[2][][];
        int[] refIdx1 = new int[]{0, 0};
        int[] refIdx2 = new int[]{0, 0};
        for (int list = 0; list < 2; ++list) {
            if (p0.usesList(list) && this.numRef[list] > 1) {
                refIdx1[list] = this.readRefIdx(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[mbX << 1], p0, mbX, 0, 0, 2, 4, list);
            }
            if (!p1.usesList(list) || this.numRef[list] <= 1) continue;
            refIdx2[list] = this.readRefIdx(reader, true, topAvailable, curMBType, this.topMBType[mbX], p0, this.predModeTop[(mbX << 1) + 1], p1, mbX, 2, 0, 2, 4, list);
        }
        Picture[] mbb = new Picture[]{Picture.create(16, 16, this.chromaFormat), Picture.create(16, 16, this.chromaFormat)};
        for (int list = 0; list < 2; ++list) {
            this.predictInter8x16(reader, mbb[list], refs, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, refIdx1, refIdx2, list, p0, p1);
        }
        this.prediction.mergePrediction(x[0][0][2], x[1][0][2], p0, 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), 0, 16, 8, 16, mb.getPlaneData(0), refs, this.thisFrame);
        this.prediction.mergePrediction(x[0][2][2], x[1][2][2], p1, 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), 8, 16, 8, 16, mb.getPlaneData(0), refs, this.thisFrame);
        this.predModeTop[mbX << 1] = p0;
        this.predModeLeft[0] = this.predModeLeft[1] = p1;
        this.predModeTop[(mbX << 1) + 1] = this.predModeLeft[1];
        this.residualInter(reader, mb, refs, leftAvailable, topAvailable, mbX, mbY, x, new H264Const.PartPred[]{p0, p1, p0, p1}, this.mapper.getAddress(mbIdx), prevMbType, curMBType);
        this.collectPredictors(mb, mbX);
        this.topMBType[mbX] = this.leftMBType = curMBType;
        this.mbTypes[address] = this.leftMBType;
    }

    private void predictInter8x16(BitReader reader, Picture mb, Picture[][] references, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean trAvailable, int[][][] x, int[] refIdx1, int[] refIdx2, int list, H264Const.PartPred p0, H264Const.PartPred p1) {
        int xx = mbX << 2;
        int blk8x8X = mbX << 1;
        int mvX1 = 0;
        int mvY1 = 0;
        int r1 = -1;
        int mvX2 = 0;
        int mvY2 = 0;
        int r2 = -1;
        if (p0.usesList(list)) {
            int mvdX1 = this.readMVD(reader, 0, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], p0, mbX, 0, 0, 2, 4, list);
            int mvdY1 = this.readMVD(reader, 1, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], p0, mbX, 0, 0, 2, 4, list);
            int mvpX1 = this.calcMVPrediction8x16Left(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 2], this.mvTopLeft[list], leftAvailable, topAvailable, topAvailable, tlAvailable, refIdx1[list], 0);
            int mvpY1 = this.calcMVPrediction8x16Left(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 2], this.mvTopLeft[list], leftAvailable, topAvailable, topAvailable, tlAvailable, refIdx1[list], 1);
            mvX1 = mvdX1 + mvpX1;
            mvY1 = mvdY1 + mvpY1;
            this.debugPrint("MVP: (" + mvpX1 + ", " + mvpY1 + "), MVD: (" + mvdX1 + ", " + mvdY1 + "), MV: (" + mvX1 + "," + mvY1 + "," + refIdx1[list] + ")");
            BlockInterpolator.getBlockLuma(references[list][refIdx1[list]], mb, 0, (mbX << 6) + mvX1, (mbY << 6) + mvY1, 8, 16);
            r1 = refIdx1[list];
        }
        int[] v1 = new int[]{mvX1, mvY1, r1};
        if (p1.usesList(list)) {
            int mvdX2 = this.readMVD(reader, 0, true, topAvailable, MBType.P_8x16, this.topMBType[mbX], p0, this.predModeTop[blk8x8X + 1], p1, mbX, 2, 0, 2, 4, list);
            int mvdY2 = this.readMVD(reader, 1, true, topAvailable, MBType.P_8x16, this.topMBType[mbX], p0, this.predModeTop[blk8x8X + 1], p1, mbX, 2, 0, 2, 4, list);
            int mvpX2 = this.calcMVPrediction8x16Right(v1, this.mvTop[list][(mbX << 2) + 2], this.mvTop[list][(mbX << 2) + 4], this.mvTop[list][(mbX << 2) + 1], true, topAvailable, trAvailable, topAvailable, refIdx2[list], 0);
            int mvpY2 = this.calcMVPrediction8x16Right(v1, this.mvTop[list][(mbX << 2) + 2], this.mvTop[list][(mbX << 2) + 4], this.mvTop[list][(mbX << 2) + 1], true, topAvailable, trAvailable, topAvailable, refIdx2[list], 1);
            mvX2 = mvdX2 + mvpX2;
            mvY2 = mvdY2 + mvpY2;
            this.debugPrint("MVP: (" + mvpX2 + ", " + mvpY2 + "), MVD: (" + mvdX2 + ", " + mvdY2 + "), MV: (" + mvX2 + "," + mvY2 + "," + refIdx2[list] + ")");
            BlockInterpolator.getBlockLuma(references[list][refIdx2[list]], mb, 8, (mbX << 6) + 32 + mvX2, (mbY << 6) + mvY2, 8, 16);
            r2 = refIdx2[list];
        }
        int[] v2 = new int[]{mvX2, mvY2, r2};
        this.copyVect(this.mvTopLeft[list], this.mvTop[list][xx + 3]);
        this.saveVect(this.mvTop[list], xx, xx + 2, mvX1, mvY1, r1);
        this.saveVect(this.mvTop[list], xx + 2, xx + 4, mvX2, mvY2, r2);
        this.saveVect(this.mvLeft[list], 0, 4, mvX2, mvY2, r2);
        x[list] = new int[][]{v1, v1, v2, v2, v1, v1, v2, v2, v1, v1, v2, v2, v1, v1, v2, v2};
    }

    private void decodeInter16x16(BitReader reader, Picture mb, Frame[][] refs, int mbIdx, MBType prevMbType, H264Const.PartPred p0, MBType curMBType) {
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mbIdx);
        int address = this.mapper.getAddress(mbIdx);
        int[][][] x = new int[2][][];
        int xx = mbX << 2;
        int[] refIdx = new int[]{0, 0};
        for (int list = 0; list < 2; ++list) {
            if (!p0.usesList(list) || this.numRef[list] <= 1) continue;
            refIdx[list] = this.readRefIdx(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[mbX << 1], p0, mbX, 0, 0, 4, 4, list);
        }
        Picture[] mbb = new Picture[]{Picture.create(16, 16, this.chromaFormat), Picture.create(16, 16, this.chromaFormat)};
        for (int list = 0; list < 2; ++list) {
            this.predictInter16x16(reader, mbb[list], refs, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, xx, refIdx, list, p0);
        }
        this.prediction.mergePrediction(x[0][0][2], x[1][0][2], p0, 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), 0, 16, 16, 16, mb.getPlaneData(0), refs, this.thisFrame);
        H264Const.PartPred partPred = p0;
        this.predModeTop[(mbX << 1) + 1] = partPred;
        this.predModeTop[mbX << 1] = partPred;
        this.predModeLeft[1] = partPred;
        this.predModeLeft[0] = partPred;
        this.residualInter(reader, mb, refs, leftAvailable, topAvailable, mbX, mbY, x, new H264Const.PartPred[]{p0, p0, p0, p0}, this.mapper.getAddress(mbIdx), prevMbType, curMBType);
        this.collectPredictors(mb, mbX);
        this.topMBType[mbX] = this.leftMBType = curMBType;
        this.mbTypes[address] = this.leftMBType;
    }

    private void predictInter16x16(BitReader reader, Picture mb, Picture[][] references, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean trAvailable, int[][][] x, int xx, int[] refIdx, int list, H264Const.PartPred curPred) {
        int blk8x8X = mbX << 1;
        int mvX = 0;
        int mvY = 0;
        int r = -1;
        if (curPred.usesList(list)) {
            int mvpX = this.calcMVPredictionMedian(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 4], this.mvTopLeft[list], leftAvailable, topAvailable, trAvailable, tlAvailable, refIdx[list], 0);
            int mvpY = this.calcMVPredictionMedian(this.mvLeft[list][0], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 4], this.mvTopLeft[list], leftAvailable, topAvailable, trAvailable, tlAvailable, refIdx[list], 1);
            int mvdX = this.readMVD(reader, 0, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], curPred, mbX, 0, 0, 4, 4, list);
            int mvdY = this.readMVD(reader, 1, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[blk8x8X], curPred, mbX, 0, 0, 4, 4, list);
            mvX = mvdX + mvpX;
            mvY = mvdY + mvpY;
            this.debugPrint("MVP: (" + mvpX + ", " + mvpY + "), MVD: (" + mvdX + ", " + mvdY + "), MV: (" + mvX + "," + mvY + "," + refIdx[list] + ")");
            r = refIdx[list];
            BlockInterpolator.getBlockLuma(references[list][r], mb, 0, (mbX << 6) + mvX, (mbY << 6) + mvY, 16, 16);
        }
        this.copyVect(this.mvTopLeft[list], this.mvTop[list][xx + 3]);
        this.saveVect(this.mvTop[list], xx, xx + 4, mvX, mvY, r);
        this.saveVect(this.mvLeft[list], 0, 4, mvX, mvY, r);
        int[] v = new int[]{mvX, mvY, r};
        x[list] = new int[][]{v, v, v, v, v, v, v, v, v, v, v, v, v, v, v, v};
    }

    private int readRefIdx(BitReader reader, boolean leftAvailable, boolean topAvailable, MBType leftType, MBType topType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred curPred, int mbX, int partX, int partY, int partW, int partH, int list) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readTE(reader, this.numRef[list] - 1);
        }
        return this.cabac.readRefIdx(this.mDecoder, leftAvailable, topAvailable, leftType, topType, leftPred, topPred, curPred, mbX, partX, partY, partW, partH, list);
    }

    private void saveVect(int[][] mv, int from, int to, int x, int y, int r) {
        for (int i2 = from; i2 < to; ++i2) {
            mv[i2][0] = x;
            mv[i2][1] = y;
            mv[i2][2] = r;
        }
    }

    public int calcMVPredictionMedian(int[] a2, int[] b2, int[] c2, int[] d2, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb, int ref, int comp) {
        if (!cAvb) {
            c2 = d2;
            cAvb = dAvb;
        }
        if (aAvb && !bAvb && !cAvb) {
            c2 = a2;
            b2 = a2;
            bAvb = cAvb = aAvb;
        }
        a2 = aAvb ? a2 : NULL_VECTOR;
        b2 = bAvb ? b2 : NULL_VECTOR;
        int[] nArray = c2 = cAvb ? c2 : NULL_VECTOR;
        if (a2[2] == ref && b2[2] != ref && c2[2] != ref) {
            return a2[comp];
        }
        if (b2[2] == ref && a2[2] != ref && c2[2] != ref) {
            return b2[comp];
        }
        if (c2[2] == ref && a2[2] != ref && b2[2] != ref) {
            return c2[comp];
        }
        return a2[comp] + b2[comp] + c2[comp] - this.min(a2[comp], b2[comp], c2[comp]) - this.max(a2[comp], b2[comp], c2[comp]);
    }

    private int max(int x, int x2, int x3) {
        return x > x2 ? (x > x3 ? x : x3) : (x2 > x3 ? x2 : x3);
    }

    private int min(int x, int x2, int x3) {
        return x < x2 ? (x < x3 ? x : x3) : (x2 < x3 ? x2 : x3);
    }

    public int calcMVPrediction16x8Top(int[] a2, int[] b2, int[] c2, int[] d2, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb, int refIdx, int comp) {
        if (bAvb && b2[2] == refIdx) {
            return b2[comp];
        }
        return this.calcMVPredictionMedian(a2, b2, c2, d2, aAvb, bAvb, cAvb, dAvb, refIdx, comp);
    }

    public int calcMVPrediction16x8Bottom(int[] a2, int[] b2, int[] c2, int[] d2, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb, int refIdx, int comp) {
        if (aAvb && a2[2] == refIdx) {
            return a2[comp];
        }
        return this.calcMVPredictionMedian(a2, b2, c2, d2, aAvb, bAvb, cAvb, dAvb, refIdx, comp);
    }

    public int calcMVPrediction8x16Left(int[] a2, int[] b2, int[] c2, int[] d2, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb, int refIdx, int comp) {
        if (aAvb && a2[2] == refIdx) {
            return a2[comp];
        }
        return this.calcMVPredictionMedian(a2, b2, c2, d2, aAvb, bAvb, cAvb, dAvb, refIdx, comp);
    }

    public int calcMVPrediction8x16Right(int[] a2, int[] b2, int[] c2, int[] d2, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb, int refIdx, int comp) {
        int[] lc;
        int[] nArray = cAvb ? c2 : (lc = dAvb ? d2 : NULL_VECTOR);
        if (lc[2] == refIdx) {
            return lc[comp];
        }
        return this.calcMVPredictionMedian(a2, b2, c2, d2, aAvb, bAvb, cAvb, dAvb, refIdx, comp);
    }

    public void decodeMBInter8x8(BitReader reader, int mb_type, Frame[][] references, Picture mb, SliceType sliceType, int mbIdx, boolean mb_field_decoding_flag, MBType prevMbType, boolean ref0) {
        MBType curMBType;
        boolean noSubMBLessThen8x8;
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        int mbAddr = this.mapper.getAddress(mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mbIdx);
        int[][][] x = new int[2][16][3];
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        for (int i2 = 0; i2 < 16; ++i2) {
            x[1][i2][2] = -1;
            x[0][i2][2] = -1;
        }
        Picture mb1 = Picture.create(16, 16, this.chromaFormat);
        if (sliceType == SliceType.P) {
            noSubMBLessThen8x8 = this.predict8x8P(reader, references[0], mb1, ref0, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, pp);
            curMBType = MBType.P_8x8;
        } else {
            noSubMBLessThen8x8 = this.predict8x8B(reader, references, mb1, ref0, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, pp);
            curMBType = MBType.B_8x8;
        }
        int codedBlockPattern = this.readCodedBlockPatternInter(reader, leftAvailable, topAvailable, this.leftCBPLuma | this.leftCBPChroma << 4, this.topCBPLuma[mbX] | this.topCBPChroma[mbX] << 4, this.leftMBType, this.topMBType[mbX]);
        int cbpLuma = codedBlockPattern & 0xF;
        int cbpChroma = codedBlockPattern >> 4;
        boolean transform8x8Used = false;
        if (this.transform8x8 && cbpLuma != 0 && noSubMBLessThen8x8) {
            transform8x8Used = this.readTransform8x8Flag(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.tf8x8Left, this.tf8x8Top[mbX]);
        }
        if (cbpLuma > 0 || cbpChroma > 0) {
            this.qp = (this.qp + this.readMBQpDelta(reader, prevMbType) + 52) % 52;
        }
        this.mbQps[0][mbAddr] = this.qp;
        this.residualLuma(reader, leftAvailable, topAvailable, mbX, mbY, mb, codedBlockPattern, curMBType, transform8x8Used, this.tf8x8Left, this.tf8x8Top[mbX]);
        this.saveMvs(x, mbX, mbY);
        this.decodeChromaInter(reader, codedBlockPattern >> 4, references, x, pp, leftAvailable, topAvailable, mbX, mbY, mbAddr, this.qp, mb, mb1);
        this.mergeResidual(mb, mb1);
        this.collectPredictors(mb, mbX);
        this.topMBType[mbX] = this.leftMBType = curMBType;
        this.mbTypes[mbAddr] = this.leftMBType;
        this.topCBPLuma[mbX] = this.leftCBPLuma = cbpLuma;
        this.topCBPChroma[mbX] = this.leftCBPChroma = cbpChroma;
        this.tf8x8Left = this.tf8x8Top[mbX] = transform8x8Used;
        this.tr8x8Used[mbAddr] = transform8x8Used;
    }

    private boolean predict8x8P(BitReader reader, Picture[] references, Picture mb, boolean ref0, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean topRightAvailable, int[][][] x, H264Const.PartPred[] pp) {
        int[] subMbTypes = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            subMbTypes[i2] = this.readSubMBTypeP(reader);
        }
        Arrays.fill((Object[])pp, (Object)H264Const.PartPred.L0);
        int blk8x8X = mbX << 1;
        int[] refIdx = new int[4];
        if (this.numRef[0] > 1 && !ref0) {
            refIdx[0] = this.readRefIdx(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, mbX, 0, 0, 2, 2, 0);
            refIdx[1] = this.readRefIdx(reader, true, topAvailable, MBType.P_8x8, this.topMBType[mbX], H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, mbX, 2, 0, 2, 2, 0);
            refIdx[2] = this.readRefIdx(reader, leftAvailable, true, this.leftMBType, MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, mbX, 0, 2, 2, 2, 0);
            refIdx[3] = this.readRefIdx(reader, true, true, MBType.P_8x8, MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, mbX, 2, 2, 2, 2, 0);
        }
        this.decodeSubMb8x8(reader, subMbTypes[0], references, mbX << 6, mbY << 6, x[0], this.mvTopLeft[0], this.mvTop[0][mbX << 2], this.mvTop[0][(mbX << 2) + 1], this.mvTop[0][(mbX << 2) + 2], this.mvLeft[0][0], this.mvLeft[0][1], tlAvailable, topAvailable, topAvailable, leftAvailable, x[0][0], x[0][1], x[0][4], x[0][5], refIdx[0], mb, 0, 0, 0, mbX, this.leftMBType, this.topMBType[mbX], MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, 0);
        this.decodeSubMb8x8(reader, subMbTypes[1], references, (mbX << 6) + 32, mbY << 6, x[0], this.mvTop[0][(mbX << 2) + 1], this.mvTop[0][(mbX << 2) + 2], this.mvTop[0][(mbX << 2) + 3], this.mvTop[0][(mbX << 2) + 4], x[0][1], x[0][5], topAvailable, topAvailable, topRightAvailable, true, x[0][2], x[0][3], x[0][6], x[0][7], refIdx[1], mb, 8, 2, 0, mbX, MBType.P_8x8, this.topMBType[mbX], MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, 0);
        this.decodeSubMb8x8(reader, subMbTypes[2], references, mbX << 6, (mbY << 6) + 32, x[0], this.mvLeft[0][1], x[0][4], x[0][5], x[0][6], this.mvLeft[0][2], this.mvLeft[0][3], leftAvailable, true, true, leftAvailable, x[0][8], x[0][9], x[0][12], x[0][13], refIdx[2], mb, 128, 0, 2, mbX, this.leftMBType, MBType.P_8x8, MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, 0);
        this.decodeSubMb8x8(reader, subMbTypes[3], references, (mbX << 6) + 32, (mbY << 6) + 32, x[0], x[0][5], x[0][6], x[0][7], null, x[0][9], x[0][13], true, true, false, true, x[0][10], x[0][11], x[0][14], x[0][15], refIdx[3], mb, 136, 2, 2, mbX, MBType.P_8x8, MBType.P_8x8, MBType.P_8x8, H264Const.PartPred.L0, H264Const.PartPred.L0, H264Const.PartPred.L0, 0);
        this.savePrediction8x8(mbX, x[0], 0);
        H264Const.PartPred partPred = H264Const.PartPred.L0;
        this.predModeTop[blk8x8X + 1] = partPred;
        this.predModeTop[blk8x8X] = partPred;
        this.predModeLeft[1] = partPred;
        this.predModeLeft[0] = partPred;
        return subMbTypes[0] == 0 && subMbTypes[1] == 0 && subMbTypes[2] == 0 && subMbTypes[3] == 0;
    }

    private boolean predict8x8B(BitReader reader, Frame[][] refs, Picture mb, boolean ref0, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean topRightAvailable, int[][][] x, H264Const.PartPred[] p) {
        int i2;
        int[] subMbTypes = new int[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            subMbTypes[i3] = this.readSubMBTypeB(reader);
            p[i3] = H264Const.bPartPredModes[subMbTypes[i3]];
        }
        int[][] refIdx = new int[2][4];
        for (int list = 0; list < 2; ++list) {
            if (this.numRef[list] <= 1) continue;
            if (p[0].usesList(list)) {
                refIdx[list][0] = this.readRefIdx(reader, leftAvailable, topAvailable, this.leftMBType, this.topMBType[mbX], this.predModeLeft[0], this.predModeTop[mbX << 1], p[0], mbX, 0, 0, 2, 2, list);
            }
            if (p[1].usesList(list)) {
                refIdx[list][1] = this.readRefIdx(reader, true, topAvailable, MBType.B_8x8, this.topMBType[mbX], p[0], this.predModeTop[(mbX << 1) + 1], p[1], mbX, 2, 0, 2, 2, list);
            }
            if (p[2].usesList(list)) {
                refIdx[list][2] = this.readRefIdx(reader, leftAvailable, true, this.leftMBType, MBType.B_8x8, this.predModeLeft[1], p[0], p[2], mbX, 0, 2, 2, 2, list);
            }
            if (!p[3].usesList(list)) continue;
            refIdx[list][3] = this.readRefIdx(reader, true, true, MBType.B_8x8, MBType.B_8x8, p[2], p[1], p[3], mbX, 2, 2, 2, 2, list);
        }
        Picture[] mbb = new Picture[]{Picture.create(16, 16, this.chromaFormat), Picture.create(16, 16, this.chromaFormat)};
        H264Const.PartPred[] _pp = new H264Const.PartPred[4];
        for (int i4 = 0; i4 < 4; ++i4) {
            if (p[i4] != H264Const.PartPred.Direct) continue;
            this.predictBDirect(refs, mbX, mbY, leftAvailable, topAvailable, tlAvailable, topRightAvailable, x, _pp, mb, H264Const.ARRAY[i4]);
        }
        int blk8x8X = mbX << 1;
        for (int list = 0; list < 2; ++list) {
            if (p[0].usesList(list)) {
                this.decodeSubMb8x8(reader, H264Const.bSubMbTypes[subMbTypes[0]], refs[list], mbX << 6, mbY << 6, x[list], this.mvTopLeft[list], this.mvTop[list][mbX << 2], this.mvTop[list][(mbX << 2) + 1], this.mvTop[list][(mbX << 2) + 2], this.mvLeft[list][0], this.mvLeft[list][1], tlAvailable, topAvailable, topAvailable, leftAvailable, x[list][0], x[list][1], x[list][4], x[list][5], refIdx[list][0], mbb[list], 0, 0, 0, mbX, this.leftMBType, this.topMBType[mbX], MBType.B_8x8, this.predModeLeft[0], this.predModeTop[blk8x8X], p[0], list);
            }
            if (p[1].usesList(list)) {
                this.decodeSubMb8x8(reader, H264Const.bSubMbTypes[subMbTypes[1]], refs[list], (mbX << 6) + 32, mbY << 6, x[list], this.mvTop[list][(mbX << 2) + 1], this.mvTop[list][(mbX << 2) + 2], this.mvTop[list][(mbX << 2) + 3], this.mvTop[list][(mbX << 2) + 4], x[list][1], x[list][5], topAvailable, topAvailable, topRightAvailable, true, x[list][2], x[list][3], x[list][6], x[list][7], refIdx[list][1], mbb[list], 8, 2, 0, mbX, MBType.B_8x8, this.topMBType[mbX], MBType.B_8x8, p[0], this.predModeTop[blk8x8X + 1], p[1], list);
            }
            if (p[2].usesList(list)) {
                this.decodeSubMb8x8(reader, H264Const.bSubMbTypes[subMbTypes[2]], refs[list], mbX << 6, (mbY << 6) + 32, x[list], this.mvLeft[list][1], x[list][4], x[list][5], x[list][6], this.mvLeft[list][2], this.mvLeft[list][3], leftAvailable, true, true, leftAvailable, x[list][8], x[list][9], x[list][12], x[list][13], refIdx[list][2], mbb[list], 128, 0, 2, mbX, this.leftMBType, MBType.B_8x8, MBType.B_8x8, this.predModeLeft[1], p[0], p[2], list);
            }
            if (!p[3].usesList(list)) continue;
            this.decodeSubMb8x8(reader, H264Const.bSubMbTypes[subMbTypes[3]], refs[list], (mbX << 6) + 32, (mbY << 6) + 32, x[list], x[list][5], x[list][6], x[list][7], null, x[list][9], x[list][13], true, true, false, true, x[list][10], x[list][11], x[list][14], x[list][15], refIdx[list][3], mbb[list], 136, 2, 2, mbX, MBType.B_8x8, MBType.B_8x8, MBType.B_8x8, p[2], p[1], p[3], list);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            int blk4x4 = H264Const.BLK8x8_BLOCKS[i2][0];
            this.prediction.mergePrediction(x[0][blk4x4][2], x[1][blk4x4][2], p[i2], 0, mbb[0].getPlaneData(0), mbb[1].getPlaneData(0), H264Const.BLK_8x8_MB_OFF_LUMA[i2], 16, 8, 8, mb.getPlaneData(0), refs, this.thisFrame);
        }
        this.predModeLeft[0] = p[1];
        this.predModeTop[blk8x8X] = p[2];
        H264Const.PartPred partPred = p[3];
        this.predModeTop[blk8x8X + 1] = partPred;
        this.predModeLeft[1] = partPred;
        this.savePrediction8x8(mbX, x[0], 0);
        this.savePrediction8x8(mbX, x[1], 1);
        for (i2 = 0; i2 < 4; ++i2) {
            if (p[i2] != H264Const.PartPred.Direct) continue;
            p[i2] = _pp[i2];
        }
        return H264Const.bSubMbTypes[subMbTypes[0]] == 0 && H264Const.bSubMbTypes[subMbTypes[1]] == 0 && H264Const.bSubMbTypes[subMbTypes[2]] == 0 && H264Const.bSubMbTypes[subMbTypes[3]] == 0;
    }

    private void decodeMBBiDirect(int mbIdx, BitReader reader, boolean field, MBType prevMbType, Picture mb, Frame[][] references) {
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        int mbAddr = this.mapper.getAddress(mbIdx);
        boolean lAvb = this.mapper.leftAvailable(mbIdx);
        boolean tAvb = this.mapper.topAvailable(mbIdx);
        boolean tlAvb = this.mapper.topLeftAvailable(mbIdx);
        boolean trAvb = this.mapper.topRightAvailable(mbIdx);
        int[][][] x = new int[2][16][3];
        for (int i2 = 0; i2 < 16; ++i2) {
            x[1][i2][2] = -1;
            x[0][i2][2] = -1;
        }
        Picture mb1 = Picture.create(16, 16, this.chromaFormat);
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        this.predictBDirect(references, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb1, H264Const.identityMapping4);
        int codedBlockPattern = this.readCodedBlockPatternInter(reader, lAvb, tAvb, this.leftCBPLuma | this.leftCBPChroma << 4, this.topCBPLuma[mbX] | this.topCBPChroma[mbX] << 4, this.leftMBType, this.topMBType[mbX]);
        int cbpLuma = codedBlockPattern & 0xF;
        int cbpChroma = codedBlockPattern >> 4;
        boolean transform8x8Used = false;
        if (this.transform8x8) {
            transform8x8Used = this.readTransform8x8Flag(reader, lAvb, tAvb, this.leftMBType, this.topMBType[mbX], this.tf8x8Left, this.tf8x8Top[mbX]);
        }
        if (cbpLuma > 0 || cbpChroma > 0) {
            this.qp = (this.qp + this.readMBQpDelta(reader, prevMbType) + 52) % 52;
        }
        this.mbQps[0][mbAddr] = this.qp;
        this.residualLuma(reader, lAvb, tAvb, mbX, mbY, mb, codedBlockPattern, MBType.P_8x8, transform8x8Used, this.tf8x8Left, this.tf8x8Top[mbX]);
        this.savePrediction8x8(mbX, x[0], 0);
        this.savePrediction8x8(mbX, x[1], 1);
        this.saveMvs(x, mbX, mbY);
        this.decodeChromaInter(reader, codedBlockPattern >> 4, references, x, pp, lAvb, tAvb, mbX, mbY, mbAddr, this.qp, mb, mb1);
        this.mergeResidual(mb, mb1);
        this.collectPredictors(mb, mbX);
        this.topMBType[mbX] = this.leftMBType = MBType.B_Direct_16x16;
        this.mbTypes[mbAddr] = this.leftMBType;
        this.topCBPLuma[mbX] = this.leftCBPLuma = cbpLuma;
        this.topCBPChroma[mbX] = this.leftCBPChroma = cbpChroma;
        this.tf8x8Left = this.tf8x8Top[mbX] = transform8x8Used;
        this.tr8x8Used[mbAddr] = transform8x8Used;
        this.predModeLeft[0] = this.predModeLeft[1] = H264Const.PartPred.Direct;
        this.predModeTop[(mbX << 1) + 1] = this.predModeLeft[1];
        this.predModeTop[mbX << 1] = this.predModeLeft[1];
    }

    private int readSubMBTypeP(BitReader reader) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readUE(reader, "SUB: sub_mb_type");
        }
        return this.cabac.readSubMbTypeP(this.mDecoder);
    }

    private int readSubMBTypeB(BitReader reader) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readUE(reader, "SUB: sub_mb_type");
        }
        return this.cabac.readSubMbTypeB(this.mDecoder);
    }

    private void savePrediction8x8(int mbX, int[][] x, int list) {
        this.copyVect(this.mvTopLeft[list], this.mvTop[list][(mbX << 2) + 3]);
        this.copyVect(this.mvLeft[list][0], x[3]);
        this.copyVect(this.mvLeft[list][1], x[7]);
        this.copyVect(this.mvLeft[list][2], x[11]);
        this.copyVect(this.mvLeft[list][3], x[15]);
        this.copyVect(this.mvTop[list][mbX << 2], x[12]);
        this.copyVect(this.mvTop[list][(mbX << 2) + 1], x[13]);
        this.copyVect(this.mvTop[list][(mbX << 2) + 2], x[14]);
        this.copyVect(this.mvTop[list][(mbX << 2) + 3], x[15]);
    }

    private void copyVect(int[] to, int[] from) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    private void decodeSubMb8x8(BitReader reader, int subMbType, Picture[] references, int offX, int offY, int[][] x, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture mb, int off, int blk8x8X, int blk8x8Y, int mbX, MBType leftMBType, MBType topMBType, MBType curMBType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred partPred, int list) {
        x10[2] = x11[2] = refIdx;
        x01[2] = x11[2];
        x00[2] = x11[2];
        switch (subMbType) {
            case 3: {
                this.decodeSub4x4(reader, references, offX, offY, tl, t0, t1, tr, l0, l1, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, blk8x8X, blk8x8Y, mbX, leftMBType, topMBType, curMBType, leftPred, topPred, partPred, list);
                break;
            }
            case 2: {
                this.decodeSub4x8(reader, references, offX, offY, tl, t0, t1, tr, l0, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, blk8x8X, blk8x8Y, mbX, leftMBType, topMBType, curMBType, leftPred, topPred, partPred, list);
                break;
            }
            case 1: {
                this.decodeSub8x4(reader, references, offX, offY, tl, t0, tr, l0, l1, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, blk8x8X, blk8x8Y, mbX, leftMBType, topMBType, curMBType, leftPred, topPred, partPred, list);
                break;
            }
            case 0: {
                this.decodeSub8x8(reader, references, offX, offY, tl, t0, tr, l0, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, blk8x8X, blk8x8Y, mbX, leftMBType, topMBType, curMBType, leftPred, topPred, partPred, list);
            }
        }
    }

    private void decodeSub8x8(BitReader reader, Picture[] references, int offX, int offY, int[] tl, int[] t0, int[] tr, int[] l0, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture mb, int off, int blk8x8X, int blk8x8Y, int mbX, MBType leftMBType, MBType topMBType, MBType curMBType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred partPred, int list) {
        int mvdX = this.readMVD(reader, 0, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 2, 2, list);
        int mvdY = this.readMVD(reader, 1, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 2, 2, list);
        int mvpX = this.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 0);
        int mvpY = this.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 1);
        x10[0] = x11[0] = mvdX + mvpX;
        x01[0] = x11[0];
        x00[0] = x11[0];
        x10[1] = x11[1] = mvpY + mvdY;
        x01[1] = x11[1];
        x00[1] = x11[1];
        this.debugPrint("MVP: (" + mvpX + ", " + mvpY + "), MVD: (" + mvdX + ", " + mvdY + "), MV: (" + x00[0] + "," + x00[1] + "," + refIdx + ")");
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 8, 8);
    }

    private void decodeSub8x4(BitReader reader, Picture[] references, int offX, int offY, int[] tl, int[] t0, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture mb, int off, int blk8x8X, int blk8x8Y, int mbX, MBType leftMBType, MBType topMBType, MBType curMBType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred partPred, int list) {
        int mvdX1 = this.readMVD(reader, 0, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 2, 1, list);
        int mvdY1 = this.readMVD(reader, 1, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 2, 1, list);
        int mvpX1 = this.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 0);
        int mvpY1 = this.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 1);
        x00[0] = x01[0] = mvdX1 + mvpX1;
        x00[1] = x01[1] = mvdY1 + mvpY1;
        this.debugPrint("MVP: (" + mvpX1 + ", " + mvpY1 + "), MVD: (" + mvdX1 + ", " + mvdY1 + "), MV: (" + x00[0] + "," + x00[1] + "," + refIdx + ")");
        int mvdX2 = this.readMVD(reader, 0, lAvb, true, leftMBType, curMBType, leftPred, partPred, partPred, mbX, blk8x8X, blk8x8Y + 1, 2, 1, list);
        int mvdY2 = this.readMVD(reader, 1, lAvb, true, leftMBType, curMBType, leftPred, partPred, partPred, mbX, blk8x8X, blk8x8Y + 1, 2, 1, list);
        int mvpX2 = this.calcMVPredictionMedian(l1, x00, NULL_VECTOR, l0, lAvb, true, false, lAvb, refIdx, 0);
        int mvpY2 = this.calcMVPredictionMedian(l1, x00, NULL_VECTOR, l0, lAvb, true, false, lAvb, refIdx, 1);
        x10[0] = x11[0] = mvdX2 + mvpX2;
        x10[1] = x11[1] = mvdY2 + mvpY2;
        this.debugPrint("MVP: (" + mvpX2 + ", " + mvpY2 + "), MVD: (" + mvdX2 + ", " + mvdY2 + "), MV: (" + x10[0] + "," + x10[1] + "," + refIdx + ")");
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 8, 4);
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4, offX + x10[0], offY + x10[1] + 16, 8, 4);
    }

    private void decodeSub4x8(BitReader reader, Picture[] references, int offX, int offY, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture mb, int off, int blk8x8X, int blk8x8Y, int mbX, MBType leftMBType, MBType topMBType, MBType curMBType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred partPred, int list) {
        int mvdX1 = this.readMVD(reader, 0, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 1, 2, list);
        int mvdY1 = this.readMVD(reader, 1, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 1, 2, list);
        int mvpX1 = this.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 0);
        int mvpY1 = this.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 1);
        x00[0] = x10[0] = mvdX1 + mvpX1;
        x00[1] = x10[1] = mvdY1 + mvpY1;
        this.debugPrint("MVP: (" + mvpX1 + ", " + mvpY1 + "), MVD: (" + mvdX1 + ", " + mvdY1 + "), MV: (" + x00[0] + "," + x00[1] + "," + refIdx + ")");
        int mvdX2 = this.readMVD(reader, 0, true, tAvb, curMBType, topMBType, partPred, topPred, partPred, mbX, blk8x8X + 1, blk8x8Y, 1, 2, list);
        int mvdY2 = this.readMVD(reader, 1, true, tAvb, curMBType, topMBType, partPred, topPred, partPred, mbX, blk8x8X + 1, blk8x8Y, 1, 2, list);
        int mvpX2 = this.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 0);
        int mvpY2 = this.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 1);
        x01[0] = x11[0] = mvdX2 + mvpX2;
        x01[1] = x11[1] = mvdY2 + mvpY2;
        this.debugPrint("MVP: (" + mvpX2 + ", " + mvpY2 + "), MVD: (" + mvdX2 + ", " + mvdY2 + "), MV: (" + x01[0] + "," + x01[1] + "," + refIdx + ")");
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 4, 8);
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off + 4, offX + x01[0] + 16, offY + x01[1], 4, 8);
    }

    private void decodeSub4x4(BitReader reader, Picture[] references, int offX, int offY, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture mb, int off, int blk8x8X, int blk8x8Y, int mbX, MBType leftMBType, MBType topMBType, MBType curMBType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred partPred, int list) {
        int mvdX1 = this.readMVD(reader, 0, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 1, 1, list);
        int mvdY1 = this.readMVD(reader, 1, lAvb, tAvb, leftMBType, topMBType, leftPred, topPred, partPred, mbX, blk8x8X, blk8x8Y, 1, 1, list);
        int mvpX1 = this.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 0);
        int mvpY1 = this.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 1);
        x00[0] = mvdX1 + mvpX1;
        x00[1] = mvdY1 + mvpY1;
        this.debugPrint("MVP: (" + mvpX1 + ", " + mvpY1 + "), MVD: (" + mvdX1 + ", " + mvdY1 + "), MV: (" + x00[0] + "," + x00[1] + "," + refIdx + ")");
        int mvdX2 = this.readMVD(reader, 0, true, tAvb, curMBType, topMBType, partPred, topPred, partPred, mbX, blk8x8X + 1, blk8x8Y, 1, 1, list);
        int mvdY2 = this.readMVD(reader, 1, true, tAvb, curMBType, topMBType, partPred, topPred, partPred, mbX, blk8x8X + 1, blk8x8Y, 1, 1, list);
        int mvpX2 = this.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 0);
        int mvpY2 = this.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 1);
        x01[0] = mvdX2 + mvpX2;
        x01[1] = mvdY2 + mvpY2;
        this.debugPrint("MVP: (" + mvpX2 + ", " + mvpY2 + "), MVD: (" + mvdX2 + ", " + mvdY2 + "), MV: (" + x01[0] + "," + x01[1] + "," + refIdx + ")");
        int mvdX3 = this.readMVD(reader, 0, lAvb, true, leftMBType, curMBType, leftPred, partPred, partPred, mbX, blk8x8X, blk8x8Y + 1, 1, 1, list);
        int mvdY3 = this.readMVD(reader, 1, lAvb, true, leftMBType, curMBType, leftPred, partPred, partPred, mbX, blk8x8X, blk8x8Y + 1, 1, 1, list);
        int mvpX3 = this.calcMVPredictionMedian(l1, x00, x01, l0, lAvb, true, true, lAvb, refIdx, 0);
        int mvpY3 = this.calcMVPredictionMedian(l1, x00, x01, l0, lAvb, true, true, lAvb, refIdx, 1);
        x10[0] = mvdX3 + mvpX3;
        x10[1] = mvdY3 + mvpY3;
        this.debugPrint("MVP: (" + mvpX3 + ", " + mvpY3 + "), MVD: (" + mvdX3 + ", " + mvdY3 + "), MV: (" + x10[0] + "," + x10[1] + "," + refIdx + ")");
        int mvdX4 = this.readMVD(reader, 0, true, true, curMBType, curMBType, partPred, partPred, partPred, mbX, blk8x8X + 1, blk8x8Y + 1, 1, 1, list);
        int mvdY4 = this.readMVD(reader, 1, true, true, curMBType, curMBType, partPred, partPred, partPred, mbX, blk8x8X + 1, blk8x8Y + 1, 1, 1, list);
        int mvpX4 = this.calcMVPredictionMedian(x10, x01, NULL_VECTOR, x00, true, true, false, true, refIdx, 0);
        int mvpY4 = this.calcMVPredictionMedian(x10, x01, NULL_VECTOR, x00, true, true, false, true, refIdx, 1);
        x11[0] = mvdX4 + mvpX4;
        x11[1] = mvdY4 + mvpY4;
        this.debugPrint("MVP: (" + mvpX4 + ", " + mvpY4 + "), MVD: (" + mvdX4 + ", " + mvdY4 + "), MV: (" + x11[0] + "," + x11[1] + "," + refIdx + ")");
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 4, 4);
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off + 4, offX + x01[0] + 16, offY + x01[1], 4, 4);
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4, offX + x10[0], offY + x10[1] + 16, 4, 4);
        BlockInterpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4 + 4, offX + x11[0] + 16, offY + x11[1] + 16, 4, 4);
    }

    private int readMVD(BitReader reader, int comp, boolean leftAvailable, boolean topAvailable, MBType leftType, MBType topType, H264Const.PartPred leftPred, H264Const.PartPred topPred, H264Const.PartPred curPred, int mbX, int partX, int partY, int partW, int partH, int list) {
        if (!this.activePps.entropy_coding_mode_flag) {
            return CAVLCReader.readSE(reader, "mvd_l0_x");
        }
        return this.cabac.readMVD(this.mDecoder, comp, leftAvailable, topAvailable, leftType, topType, leftPred, topPred, curPred, mbX, partX, partY, partW, partH, list);
    }

    public void decodeChromaInter(BitReader reader, int pattern, Frame[][] refs, int[][][] x, H264Const.PartPred[] predType, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, int mbAddr, int qp, Picture mb, Picture mb1) {
        this.predictChromaInter(refs, x, mbX << 3, mbY << 3, 1, mb1, predType);
        this.predictChromaInter(refs, x, mbX << 3, mbY << 3, 2, mb1, predType);
        int qp1 = this.calcQpChroma(qp, this.chromaQpOffset[0]);
        int qp2 = this.calcQpChroma(qp, this.chromaQpOffset[1]);
        this.decodeChromaResidual(reader, leftAvailable, topAvailable, mbX, mbY, pattern, mb, qp1, qp2, MBType.P_16x16);
        this.mbQps[1][mbAddr] = qp1;
        this.mbQps[2][mbAddr] = qp2;
    }

    private void saveMvs(int[][][] x, int mbX, int mbY) {
        int j2 = 0;
        int blkOffY = mbY << 2;
        int blkInd = 0;
        while (j2 < 4) {
            int i2 = 0;
            int blkOffX = mbX << 2;
            while (i2 < 4) {
                this.mvs[0][blkOffY][blkOffX] = x[0][blkInd];
                this.mvs[1][blkOffY][blkOffX] = x[1][blkInd];
                ++i2;
                ++blkOffX;
                ++blkInd;
            }
            ++j2;
            ++blkOffY;
        }
    }

    public void predictChromaInter(Frame[][] refs, int[][][] vectors, int x, int y, int comp, Picture mb, H264Const.PartPred[] predType) {
        Picture[] mbb = new Picture[]{Picture.create(16, 16, this.chromaFormat), Picture.create(16, 16, this.chromaFormat)};
        for (int blk8x8 = 0; blk8x8 < 4; ++blk8x8) {
            for (int list = 0; list < 2; ++list) {
                if (!predType[blk8x8].usesList(list)) continue;
                for (int blk4x4 = 0; blk4x4 < 4; ++blk4x4) {
                    int i2 = H264Const.BLK_INV_MAP[(blk8x8 << 2) + blk4x4];
                    int[] mv = vectors[list][i2];
                    Frame ref = refs[list][mv[2]];
                    int blkPox = (i2 & 3) << 1;
                    int blkPoy = i2 >> 2 << 1;
                    int xx = (x + blkPox << 3) + mv[0];
                    int yy = (y + blkPoy << 3) + mv[1];
                    BlockInterpolator.getBlockChroma(ref.getPlaneData(comp), ref.getPlaneWidth(comp), ref.getPlaneHeight(comp), mbb[list].getPlaneData(comp), blkPoy * mb.getPlaneWidth(comp) + blkPox, mb.getPlaneWidth(comp), xx, yy, 2, 2);
                }
            }
            int blk4x4 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            this.prediction.mergePrediction(vectors[0][blk4x4][2], vectors[1][blk4x4][2], predType[blk8x8], comp, mbb[0].getPlaneData(comp), mbb[1].getPlaneData(comp), H264Const.BLK_8x8_MB_OFF_CHROMA[blk8x8], mb.getPlaneWidth(comp), 4, 4, mb.getPlaneData(comp), refs, this.thisFrame);
        }
    }

    public void decodeMBlockIPCM(BitReader reader, int mbIndex, Picture mb) {
        int mbX = this.mapper.getMbX(mbIndex);
        reader.align();
        int[] samplesLuma = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            samplesLuma[i2] = reader.readNBit(8);
        }
        int MbWidthC = 16 >> this.chromaFormat.compWidth[1];
        int MbHeightC = 16 >> this.chromaFormat.compHeight[1];
        int[] samplesChroma = new int[2 * MbWidthC * MbHeightC];
        for (int i3 = 0; i3 < 2 * MbWidthC * MbHeightC; ++i3) {
            samplesChroma[i3] = reader.readNBit(8);
        }
        this.collectPredictors(mb, mbX);
    }

    public void decodeSkip(Frame[][] refs, int mbIdx, Picture mb, SliceType sliceType) {
        int mbX = this.mapper.getMbX(mbIdx);
        int mbY = this.mapper.getMbY(mbIdx);
        int mbAddr = this.mapper.getAddress(mbIdx);
        int[][][] x = new int[2][16][3];
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        for (int i2 = 0; i2 < 16; ++i2) {
            x[1][i2][2] = -1;
            x[0][i2][2] = -1;
        }
        if (sliceType == SliceType.P) {
            this.predictPSkip(refs, mbX, mbY, this.mapper.leftAvailable(mbIdx), this.mapper.topAvailable(mbIdx), this.mapper.topLeftAvailable(mbIdx), this.mapper.topRightAvailable(mbIdx), x, mb);
            Arrays.fill((Object[])pp, (Object)H264Const.PartPred.L0);
        } else {
            this.predictBDirect(refs, mbX, mbY, this.mapper.leftAvailable(mbIdx), this.mapper.topAvailable(mbIdx), this.mapper.topLeftAvailable(mbIdx), this.mapper.topRightAvailable(mbIdx), x, pp, mb, H264Const.identityMapping4);
            this.savePrediction8x8(mbX, x[0], 0);
            this.savePrediction8x8(mbX, x[1], 1);
        }
        this.decodeChromaSkip(refs, x, pp, mbX, mbY, mb);
        this.collectPredictors(mb, mbX);
        this.saveMvs(x, mbX, mbY);
        this.leftMBType = null;
        this.topMBType[mbX] = null;
        this.mbTypes[mbAddr] = null;
        this.mbQps[0][mbAddr] = this.qp;
        this.mbQps[1][mbAddr] = this.calcQpChroma(this.qp, this.chromaQpOffset[0]);
        this.mbQps[2][mbAddr] = this.calcQpChroma(this.qp, this.chromaQpOffset[1]);
    }

    public void predictBDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture mb, int[] blocks) {
        if (this.sh.direct_spatial_mv_pred_flag) {
            this.predictBSpatialDirect(refs, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb, blocks);
        } else {
            this.predictBTemporalDirect(refs, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb, blocks);
        }
    }

    private void predictBTemporalDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture mb, int[] blocks8x8) {
        Picture mb0 = Picture.create(16, 16, this.chromaFormat);
        Picture mb1 = Picture.create(16, 16, this.chromaFormat);
        for (int blk8x8 : blocks8x8) {
            int blk4x4_0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            pp[blk8x8] = H264Const.PartPred.Bi;
            if (!this.activeSps.direct_8x8_inference_flag) {
                for (int blk4x4 : H264Const.BLK8x8_BLOCKS[blk8x8]) {
                    this.predTemp4x4(refs, mbX, mbY, x, blk4x4);
                    int blkIndX = blk4x4 & 3;
                    int blkIndY = blk4x4 >> 2;
                    this.debugPrint("DIRECT_4x4 [" + blkIndY + ", " + blkIndX + "]: (" + x[0][blk4x4][0] + "," + x[0][blk4x4][1] + "," + x[0][blk4x4][2] + "), (" + x[1][blk4x4][0] + "," + x[1][blk4x4][1] + "," + x[1][blk4x4][2] + ")");
                    int blkPredX = (mbX << 6) + (blkIndX << 4);
                    int blkPredY = (mbY << 6) + (blkIndY << 4);
                    BlockInterpolator.getBlockLuma(refs[0][x[0][blk4x4][2]], mb0, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[0][blk4x4][0], blkPredY + x[0][blk4x4][1], 4, 4);
                    BlockInterpolator.getBlockLuma(refs[1][0], mb1, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[1][blk4x4][0], blkPredY + x[1][blk4x4][1], 4, 4);
                }
            } else {
                int blk4x4Pred = H264Const.BLK_INV_MAP[blk8x8 * 5];
                this.predTemp4x4(refs, mbX, mbY, x, blk4x4Pred);
                this.propagatePred(x, blk8x8, blk4x4Pred);
                int blkIndX = blk4x4_0 & 3;
                int blkIndY = blk4x4_0 >> 2;
                this.debugPrint("DIRECT_8x8 [" + blkIndY + ", " + blkIndX + "]: (" + x[0][blk4x4_0][0] + "," + x[0][blk4x4_0][1] + "," + x[0][blk4x4_0][2] + "), (" + x[1][blk4x4_0][0] + "," + x[1][blk4x4_0][1] + "," + x[0][blk4x4_0][2] + ")");
                int blkPredX = (mbX << 6) + (blkIndX << 4);
                int blkPredY = (mbY << 6) + (blkIndY << 4);
                BlockInterpolator.getBlockLuma(refs[0][x[0][blk4x4_0][2]], mb0, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[0][blk4x4_0][0], blkPredY + x[0][blk4x4_0][1], 8, 8);
                BlockInterpolator.getBlockLuma(refs[1][0], mb1, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[1][blk4x4_0][0], blkPredY + x[1][blk4x4_0][1], 8, 8);
            }
            this.prediction.mergePrediction(x[0][blk4x4_0][2], x[1][blk4x4_0][2], H264Const.PartPred.Bi, 0, mb0.getPlaneData(0), mb1.getPlaneData(0), H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], 16, 8, 8, mb.getPlaneData(0), refs, this.thisFrame);
        }
    }

    private void predTemp4x4(Frame[][] refs, int mbX, int mbY, int[][][] x, int blk4x4) {
        Frame refL0;
        int refIdxL0;
        int mbWidth = this.activeSps.pic_width_in_mbs_minus1 + 1;
        Frame picCol = refs[1][0];
        int blkIndX = blk4x4 & 3;
        int blkIndY = blk4x4 >> 2;
        int blkPosX = (mbX << 2) + blkIndX;
        int blkPosY = (mbY << 2) + blkIndY;
        int[] mvCol = picCol.getMvs()[0][blkPosY][blkPosX];
        if (mvCol[2] == -1) {
            mvCol = picCol.getMvs()[1][blkPosY][blkPosX];
            if (mvCol[2] == -1) {
                refIdxL0 = 0;
                refL0 = refs[0][0];
            } else {
                refL0 = picCol.getRefsUsed()[mbY * mbWidth + mbX][1][mvCol[2]];
                refIdxL0 = this.findPic(refs[0], refL0);
            }
        } else {
            refL0 = picCol.getRefsUsed()[mbY * mbWidth + mbX][0][mvCol[2]];
            refIdxL0 = this.findPic(refs[0], refL0);
        }
        x[0][blk4x4][2] = refIdxL0;
        x[1][blk4x4][2] = 0;
        int td = MathUtil.clip(picCol.getPOC() - refL0.getPOC(), -128, 127);
        if (!refL0.isShortTerm() || td == 0) {
            x[0][blk4x4][0] = mvCol[0];
            x[0][blk4x4][1] = mvCol[1];
            x[1][blk4x4][0] = 0;
            x[1][blk4x4][1] = 0;
        } else {
            int tb = MathUtil.clip(this.thisFrame.getPOC() - refL0.getPOC(), -128, 127);
            int tx = (16384 + Math.abs(td / 2)) / td;
            int dsf = MathUtil.clip(tb * tx + 32 >> 6, -1024, 1023);
            x[0][blk4x4][0] = dsf * mvCol[0] + 128 >> 8;
            x[0][blk4x4][1] = dsf * mvCol[1] + 128 >> 8;
            x[1][blk4x4][0] = x[0][blk4x4][0] - mvCol[0];
            x[1][blk4x4][1] = x[0][blk4x4][1] - mvCol[1];
        }
    }

    private int findPic(Frame[] frames, Frame refL0) {
        for (int i2 = 0; i2 < frames.length; ++i2) {
            if (frames[i2] != refL0) continue;
            return i2;
        }
        System.out.println("ERROR: RefPicList0 shall contain refPicCol");
        return 0;
    }

    private void predictBSpatialDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture mb, int[] blocks8x8) {
        int[] a0 = this.mvLeft[0][0];
        int[] a1 = this.mvLeft[1][0];
        int[] b0 = this.mvTop[0][mbX << 2];
        int[] b1 = this.mvTop[1][mbX << 2];
        int[] c0 = this.mvTop[0][(mbX << 2) + 4];
        int[] c1 = this.mvTop[1][(mbX << 2) + 4];
        int[] d0 = this.mvTopLeft[0];
        int[] d1 = this.mvTopLeft[1];
        int refIdxL0 = this.calcRef(a0, b0, c0, d0, lAvb, tAvb, tlAvb, trAvb, mbX);
        int refIdxL1 = this.calcRef(a1, b1, c1, d1, lAvb, tAvb, tlAvb, trAvb, mbX);
        Picture mb0 = Picture.create(16, 16, this.chromaFormat);
        Picture mb1 = Picture.create(16, 16, this.chromaFormat);
        if (refIdxL0 < 0 && refIdxL1 < 0) {
            for (int blk8x8 : blocks8x8) {
                for (int blk4x4 : H264Const.BLK8x8_BLOCKS[blk8x8]) {
                    x[1][blk4x4][2] = 0;
                    x[1][blk4x4][1] = 0;
                    x[1][blk4x4][0] = 0;
                    x[0][blk4x4][2] = 0;
                    x[0][blk4x4][1] = 0;
                    x[0][blk4x4][0] = 0;
                }
                pp[blk8x8] = H264Const.PartPred.Bi;
                BlockInterpolator.getBlockLuma(refs[0][0], mb0, H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], mbX << 6, mbY << 6, 8, 8);
                BlockInterpolator.getBlockLuma(refs[1][0], mb1, H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], mbX << 6, mbY << 6, 8, 8);
                this.prediction.mergePrediction(0, 0, H264Const.PartPred.Bi, 0, mb0.getPlaneData(0), mb1.getPlaneData(0), H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], 16, 8, 8, mb.getPlaneData(0), refs, this.thisFrame);
                this.debugPrint("DIRECT_8x8 [" + (blk8x8 & 2) + ", " + (blk8x8 << 1 & 2) + "]: (0,0,0), (0,0,0)");
            }
            return;
        }
        int mvX0 = this.calcMVPredictionMedian(a0, b0, c0, d0, lAvb, tAvb, trAvb, tlAvb, refIdxL0, 0);
        int mvY0 = this.calcMVPredictionMedian(a0, b0, c0, d0, lAvb, tAvb, trAvb, tlAvb, refIdxL0, 1);
        int mvX1 = this.calcMVPredictionMedian(a1, b1, c1, d1, lAvb, tAvb, trAvb, tlAvb, refIdxL1, 0);
        int mvY1 = this.calcMVPredictionMedian(a1, b1, c1, d1, lAvb, tAvb, trAvb, tlAvb, refIdxL1, 1);
        Frame col = refs[1][0];
        H264Const.PartPred partPred = refIdxL0 >= 0 && refIdxL1 >= 0 ? H264Const.PartPred.Bi : (refIdxL0 >= 0 ? H264Const.PartPred.L0 : H264Const.PartPred.L1);
        for (int blk8x8 : blocks8x8) {
            int blk4x4_0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            if (!this.activeSps.direct_8x8_inference_flag) {
                for (int blk4x4 : H264Const.BLK8x8_BLOCKS[blk8x8]) {
                    this.pred4x4(mbX, mbY, x, pp, refIdxL0, refIdxL1, mvX0, mvY0, mvX1, mvY1, col, partPred, blk4x4);
                    int blkIndX = blk4x4 & 3;
                    int blkIndY = blk4x4 >> 2;
                    this.debugPrint("DIRECT_4x4 [" + blkIndY + ", " + blkIndX + "]: (" + x[0][blk4x4][0] + "," + x[0][blk4x4][1] + "," + refIdxL0 + "), (" + x[1][blk4x4][0] + "," + x[1][blk4x4][1] + "," + refIdxL1 + ")");
                    int blkPredX = (mbX << 6) + (blkIndX << 4);
                    int blkPredY = (mbY << 6) + (blkIndY << 4);
                    if (refIdxL0 >= 0) {
                        BlockInterpolator.getBlockLuma(refs[0][refIdxL0], mb0, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[0][blk4x4][0], blkPredY + x[0][blk4x4][1], 4, 4);
                    }
                    if (refIdxL1 < 0) continue;
                    BlockInterpolator.getBlockLuma(refs[1][refIdxL1], mb1, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[1][blk4x4][0], blkPredY + x[1][blk4x4][1], 4, 4);
                }
            } else {
                int blk4x4Pred = H264Const.BLK_INV_MAP[blk8x8 * 5];
                this.pred4x4(mbX, mbY, x, pp, refIdxL0, refIdxL1, mvX0, mvY0, mvX1, mvY1, col, partPred, blk4x4Pred);
                this.propagatePred(x, blk8x8, blk4x4Pred);
                int blkIndX = blk4x4_0 & 3;
                int blkIndY = blk4x4_0 >> 2;
                this.debugPrint("DIRECT_8x8 [" + blkIndY + ", " + blkIndX + "]: (" + x[0][blk4x4_0][0] + "," + x[0][blk4x4_0][1] + "," + refIdxL0 + "), (" + x[1][blk4x4_0][0] + "," + x[1][blk4x4_0][1] + "," + refIdxL1 + ")");
                int blkPredX = (mbX << 6) + (blkIndX << 4);
                int blkPredY = (mbY << 6) + (blkIndY << 4);
                if (refIdxL0 >= 0) {
                    BlockInterpolator.getBlockLuma(refs[0][refIdxL0], mb0, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[0][blk4x4_0][0], blkPredY + x[0][blk4x4_0][1], 8, 8);
                }
                if (refIdxL1 >= 0) {
                    BlockInterpolator.getBlockLuma(refs[1][refIdxL1], mb1, H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[1][blk4x4_0][0], blkPredY + x[1][blk4x4_0][1], 8, 8);
                }
            }
            this.prediction.mergePrediction(x[0][blk4x4_0][2], x[1][blk4x4_0][2], refIdxL0 >= 0 ? (refIdxL1 >= 0 ? H264Const.PartPred.Bi : H264Const.PartPred.L0) : H264Const.PartPred.L1, 0, mb0.getPlaneData(0), mb1.getPlaneData(0), H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], 16, 8, 8, mb.getPlaneData(0), refs, this.thisFrame);
        }
    }

    private int calcRef(int[] a0, int[] b0, int[] c0, int[] d0, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int mbX) {
        return this.minPos(this.minPos(lAvb ? a0[2] : -1, tAvb ? b0[2] : -1), trAvb ? c0[2] : (tlAvb ? d0[2] : -1));
    }

    private void propagatePred(int[][][] x, int blk8x8, int blk4x4Pred) {
        int b0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
        int b1 = H264Const.BLK8x8_BLOCKS[blk8x8][1];
        int b2 = H264Const.BLK8x8_BLOCKS[blk8x8][2];
        int b3 = H264Const.BLK8x8_BLOCKS[blk8x8][3];
        int n2 = x[0][blk4x4Pred][0];
        x[0][b3][0] = n2;
        x[0][b2][0] = n2;
        x[0][b1][0] = n2;
        x[0][b0][0] = n2;
        int n3 = x[0][blk4x4Pred][1];
        x[0][b3][1] = n3;
        x[0][b2][1] = n3;
        x[0][b1][1] = n3;
        x[0][b0][1] = n3;
        int n4 = x[0][blk4x4Pred][2];
        x[0][b3][2] = n4;
        x[0][b2][2] = n4;
        x[0][b1][2] = n4;
        x[0][b0][2] = n4;
        int n5 = x[1][blk4x4Pred][0];
        x[1][b3][0] = n5;
        x[1][b2][0] = n5;
        x[1][b1][0] = n5;
        x[1][b0][0] = n5;
        int n6 = x[1][blk4x4Pred][1];
        x[1][b3][1] = n6;
        x[1][b2][1] = n6;
        x[1][b1][1] = n6;
        x[1][b0][1] = n6;
        int n7 = x[1][blk4x4Pred][2];
        x[1][b3][2] = n7;
        x[1][b2][2] = n7;
        x[1][b1][2] = n7;
        x[1][b0][2] = n7;
    }

    private void pred4x4(int mbX, int mbY, int[][][] x, H264Const.PartPred[] pp, int refL0, int refL1, int mvX0, int mvY0, int mvX1, int mvY1, Frame col, H264Const.PartPred partPred, int blk4x4) {
        boolean colZero;
        int blkIndX = blk4x4 & 3;
        int blkIndY = blk4x4 >> 2;
        int blkPosX = (mbX << 2) + blkIndX;
        int blkPosY = (mbY << 2) + blkIndY;
        x[0][blk4x4][2] = refL0;
        x[1][blk4x4][2] = refL1;
        int[] mvCol = col.getMvs()[0][blkPosY][blkPosX];
        if (mvCol[2] == -1) {
            mvCol = col.getMvs()[1][blkPosY][blkPosX];
        }
        boolean bl = colZero = col.isShortTerm() && mvCol[2] == 0 && MathUtil.abs(mvCol[0]) >> 1 == 0 && MathUtil.abs(mvCol[1]) >> 1 == 0;
        if (refL0 > 0 || !colZero) {
            x[0][blk4x4][0] = mvX0;
            x[0][blk4x4][1] = mvY0;
        }
        if (refL1 > 0 || !colZero) {
            x[1][blk4x4][0] = mvX1;
            x[1][blk4x4][1] = mvY1;
        }
        pp[H264Const.BLK_8x8_IND[blk4x4]] = partPred;
    }

    private int minPos(int a2, int b2) {
        return a2 >= 0 && b2 >= 0 ? Math.min(a2, b2) : Math.max(a2, b2);
    }

    public void predictPSkip(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, Picture mb) {
        int mvX = 0;
        int mvY = 0;
        if (lAvb && tAvb) {
            int[] b2 = this.mvTop[0][mbX << 2];
            int[] a2 = this.mvLeft[0][0];
            if (!(a2[0] == 0 && a2[1] == 0 && a2[2] == 0 || b2[0] == 0 && b2[1] == 0 && b2[2] == 0)) {
                mvX = this.calcMVPredictionMedian(a2, b2, this.mvTop[0][(mbX << 2) + 4], this.mvTopLeft[0], lAvb, tAvb, trAvb, tlAvb, 0, 0);
                mvY = this.calcMVPredictionMedian(a2, b2, this.mvTop[0][(mbX << 2) + 4], this.mvTopLeft[0], lAvb, tAvb, trAvb, tlAvb, 0, 1);
            }
        }
        this.debugPrint("MV_SKIP: (" + mvX + "," + mvY + ")");
        int blk8x8X = mbX << 1;
        H264Const.PartPred partPred = H264Const.PartPred.L0;
        this.predModeTop[blk8x8X + 1] = partPred;
        this.predModeTop[blk8x8X] = partPred;
        this.predModeLeft[1] = partPred;
        this.predModeLeft[0] = partPred;
        int xx = mbX << 2;
        this.copyVect(this.mvTopLeft[0], this.mvTop[0][xx + 3]);
        this.saveVect(this.mvTop[0], xx, xx + 4, mvX, mvY, 0);
        this.saveVect(this.mvLeft[0], 0, 4, mvX, mvY, 0);
        for (int i2 = 0; i2 < 16; ++i2) {
            x[0][i2][0] = mvX;
            x[0][i2][1] = mvY;
            x[0][i2][2] = 0;
        }
        BlockInterpolator.getBlockLuma(refs[0][0], mb, 0, (mbX << 6) + mvX, (mbY << 6) + mvY, 16, 16);
        this.prediction.mergePrediction(0, 0, H264Const.PartPred.L0, 0, mb.getPlaneData(0), null, 0, 16, 16, 16, mb.getPlaneData(0), refs, this.thisFrame);
    }

    public void decodeChromaSkip(Frame[][] reference, int[][][] vectors, H264Const.PartPred[] pp, int mbX, int mbY, Picture mb) {
        this.predictChromaInter(reference, vectors, mbX << 3, mbY << 3, 1, mb, pp);
        this.predictChromaInter(reference, vectors, mbX << 3, mbY << 3, 2, mb, pp);
    }

    private void debugPrint(String str) {
        if (this.debug) {
            System.out.println(str);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

