/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.common.Assert;
import org.jcodec.common.tools.MathUtil;

public class Intra8x8PredictionBuilder {
    static int[] topBuf = new int[16];
    static int[] leftBuf = new int[8];
    static int[] genBuf = new int[24];

    public static void predictWithMode(int mode, int[] residual, boolean leftAvailable, boolean topAvailable, boolean topLeftAvailable, boolean topRightAvailable, int[] leftRow, int[] topLine, int[] topLeft, int mbOffX, int blkX, int blkY) {
        switch (mode) {
            case 0: {
                Assert.assertTrue(topAvailable);
                Intra8x8PredictionBuilder.predictVertical(residual, topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 1: {
                Assert.assertTrue(leftAvailable);
                Intra8x8PredictionBuilder.predictHorizontal(residual, topLeftAvailable, topLeft, leftRow, mbOffX, blkX, blkY);
                break;
            }
            case 2: {
                Intra8x8PredictionBuilder.predictDC(residual, topLeftAvailable, topRightAvailable, leftAvailable, topAvailable, topLeft, leftRow, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 3: {
                Assert.assertTrue(topAvailable);
                Intra8x8PredictionBuilder.predictDiagonalDownLeft(residual, topLeftAvailable, topAvailable, topRightAvailable, topLeft, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 4: {
                Assert.assertTrue(topAvailable && leftAvailable && topLeftAvailable);
                Intra8x8PredictionBuilder.predictDiagonalDownRight(residual, topRightAvailable, topLeft, leftRow, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 5: {
                Assert.assertTrue(topAvailable && leftAvailable && topLeftAvailable);
                Intra8x8PredictionBuilder.predictVerticalRight(residual, topRightAvailable, topLeft, leftRow, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 6: {
                Assert.assertTrue(topAvailable && leftAvailable && topLeftAvailable);
                Intra8x8PredictionBuilder.predictHorizontalDown(residual, topRightAvailable, topLeft, leftRow, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 7: {
                Assert.assertTrue(topAvailable);
                Intra8x8PredictionBuilder.predictVerticalLeft(residual, topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX, blkX, blkY);
                break;
            }
            case 8: {
                Assert.assertTrue(leftAvailable);
                Intra8x8PredictionBuilder.predictHorizontalUp(residual, topLeftAvailable, topLeft, leftRow, mbOffX, blkX, blkY);
            }
        }
        int oo1 = mbOffX + blkX;
        int off1 = (blkY << 4) + blkX + 7;
        topLeft[blkY >> 2] = topLine[oo1 + 7];
        for (int i2 = 0; i2 < 8; ++i2) {
            leftRow[blkY + i2] = residual[off1 + (i2 << 4)];
        }
        int off2 = (blkY << 4) + blkX + 112;
        for (int i3 = 0; i3 < 8; ++i3) {
            topLine[oo1 + i3] = residual[off2 + i3];
        }
        topLeft[(blkY >> 2) + 1] = leftRow[blkY + 3];
    }

    private static void interpolateTop(boolean topLeftAvailable, boolean topRightAvailable, int[] topLeft, int[] topLine, int blkX, int blkY, int[] out) {
        int i2;
        int a2 = topLeftAvailable ? topLeft[blkY >> 2] : topLine[blkX];
        out[0] = a2 + (topLine[blkX] << 1) + topLine[blkX + 1] + 2 >> 2;
        for (i2 = 1; i2 < 7; ++i2) {
            out[i2] = topLine[blkX + i2 - 1] + (topLine[blkX + i2] << 1) + topLine[blkX + i2 + 1] + 2 >> 2;
        }
        if (topRightAvailable) {
            while (i2 < 15) {
                out[i2] = topLine[blkX + i2 - 1] + (topLine[blkX + i2] << 1) + topLine[blkX + i2 + 1] + 2 >> 2;
                ++i2;
            }
            out[15] = topLine[blkX + 14] + (topLine[blkX + 15] << 1) + topLine[blkX + 15] + 2 >> 2;
        } else {
            out[7] = topLine[blkX + 6] + (topLine[blkX + 7] << 1) + topLine[blkX + 7] + 2 >> 2;
            for (i2 = 8; i2 < 16; ++i2) {
                out[i2] = topLine[blkX + 7];
            }
        }
    }

    private static void interpolateLeft(boolean topLeftAvailable, int[] topLeft, int[] leftRow, int blkY, int[] out) {
        int a2 = topLeftAvailable ? topLeft[blkY >> 2] : leftRow[0];
        out[0] = a2 + (leftRow[blkY] << 1) + leftRow[blkY + 1] + 2 >> 2;
        for (int i2 = 1; i2 < 7; ++i2) {
            out[i2] = leftRow[blkY + i2 - 1] + (leftRow[blkY + i2] << 1) + leftRow[blkY + i2 + 1] + 2 >> 2;
        }
        out[7] = leftRow[blkY + 6] + (leftRow[blkY + 7] << 1) + leftRow[blkY + 7] + 2 >> 2;
    }

    private static int interpolateTopLeft(boolean topAvailable, boolean leftAvailable, int[] topLeft, int[] topLine, int[] leftRow, int mbOffX, int blkX, int blkY) {
        int a2 = topLeft[blkY >> 2];
        int b2 = topAvailable ? topLine[mbOffX + blkX] : a2;
        int c2 = leftAvailable ? leftRow[blkY] : a2;
        int aa = a2 << 1;
        return aa + b2 + c2 + 2 >> 2;
    }

    public static void copyAdd(int[] src, int srcOff, int[] dst, int dstOff) {
        dst[dstOff] = MathUtil.clip(dst[dstOff] + src[srcOff], 0, 255);
        dst[dstOff + 1] = MathUtil.clip(dst[dstOff + 1] + src[srcOff + 1], 0, 255);
        dst[dstOff + 2] = MathUtil.clip(dst[dstOff + 2] + src[srcOff + 2], 0, 255);
        dst[dstOff + 3] = MathUtil.clip(dst[dstOff + 3] + src[srcOff + 3], 0, 255);
        dst[dstOff + 4] = MathUtil.clip(dst[dstOff + 4] + src[srcOff + 4], 0, 255);
        dst[dstOff + 5] = MathUtil.clip(dst[dstOff + 5] + src[srcOff + 5], 0, 255);
        dst[dstOff + 6] = MathUtil.clip(dst[dstOff + 6] + src[srcOff + 6], 0, 255);
        dst[dstOff + 7] = MathUtil.clip(dst[dstOff + 7] + src[srcOff + 7], 0, 255);
    }

    public static void fillAdd(int[] dst, int off, int val) {
        int i2 = 0;
        while (i2 < 8) {
            dst[off] = MathUtil.clip(dst[off] + val, 0, 255);
            dst[off + 1] = MathUtil.clip(dst[off + 1] + val, 0, 255);
            dst[off + 2] = MathUtil.clip(dst[off + 2] + val, 0, 255);
            dst[off + 3] = MathUtil.clip(dst[off + 3] + val, 0, 255);
            dst[off + 4] = MathUtil.clip(dst[off + 4] + val, 0, 255);
            dst[off + 5] = MathUtil.clip(dst[off + 5] + val, 0, 255);
            dst[off + 6] = MathUtil.clip(dst[off + 6] + val, 0, 255);
            dst[off + 7] = MathUtil.clip(dst[off + 7] + val, 0, 255);
            ++i2;
            off += 16;
        }
    }

    private static void predictVertical(int[] residual, boolean topLeftAvailable, boolean topRightAvailable, int[] topLeft, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        int i2 = 0;
        int off = (blkY << 4) + blkX;
        while (i2 < 8) {
            residual[off] = MathUtil.clip(residual[off] + topBuf[0], 0, 255);
            residual[off + 1] = MathUtil.clip(residual[off + 1] + topBuf[1], 0, 255);
            residual[off + 2] = MathUtil.clip(residual[off + 2] + topBuf[2], 0, 255);
            residual[off + 3] = MathUtil.clip(residual[off + 3] + topBuf[3], 0, 255);
            residual[off + 4] = MathUtil.clip(residual[off + 4] + topBuf[4], 0, 255);
            residual[off + 5] = MathUtil.clip(residual[off + 5] + topBuf[5], 0, 255);
            residual[off + 6] = MathUtil.clip(residual[off + 6] + topBuf[6], 0, 255);
            residual[off + 7] = MathUtil.clip(residual[off + 7] + topBuf[7], 0, 255);
            ++i2;
            off += 16;
        }
    }

    private static void predictHorizontal(int[] residual, boolean topLeftAvailable, int[] topLeft, int[] leftRow, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateLeft(topLeftAvailable, topLeft, leftRow, blkY, leftBuf);
        int i2 = 0;
        int off = (blkY << 4) + blkX;
        while (i2 < 8) {
            residual[off] = MathUtil.clip(residual[off] + leftBuf[i2], 0, 255);
            residual[off + 1] = MathUtil.clip(residual[off + 1] + leftBuf[i2], 0, 255);
            residual[off + 2] = MathUtil.clip(residual[off + 2] + leftBuf[i2], 0, 255);
            residual[off + 3] = MathUtil.clip(residual[off + 3] + leftBuf[i2], 0, 255);
            residual[off + 4] = MathUtil.clip(residual[off + 4] + leftBuf[i2], 0, 255);
            residual[off + 5] = MathUtil.clip(residual[off + 5] + leftBuf[i2], 0, 255);
            residual[off + 6] = MathUtil.clip(residual[off + 6] + leftBuf[i2], 0, 255);
            residual[off + 7] = MathUtil.clip(residual[off + 7] + leftBuf[i2], 0, 255);
            ++i2;
            off += 16;
        }
    }

    private static void predictDC(int[] residual, boolean topLeftAvailable, boolean topRightAvailable, boolean leftAvailable, boolean topAvailable, int[] topLeft, int[] leftRow, int[] topLine, int mbOffX, int blkX, int blkY) {
        if (topAvailable && leftAvailable) {
            Intra8x8PredictionBuilder.interpolateTop(topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
            Intra8x8PredictionBuilder.interpolateLeft(topLeftAvailable, topLeft, leftRow, blkY, leftBuf);
            int sum1 = topBuf[0] + topBuf[1] + topBuf[2] + topBuf[3];
            int sum2 = topBuf[4] + topBuf[5] + topBuf[6] + topBuf[7];
            int sum3 = leftBuf[0] + leftBuf[1] + leftBuf[2] + leftBuf[3];
            int sum4 = leftBuf[4] + leftBuf[5] + leftBuf[6] + leftBuf[7];
            Intra8x8PredictionBuilder.fillAdd(residual, (blkY << 4) + blkX, sum1 + sum2 + sum3 + sum4 + 8 >> 4);
        } else if (leftAvailable) {
            Intra8x8PredictionBuilder.interpolateLeft(topLeftAvailable, topLeft, leftRow, blkY, leftBuf);
            int sum3 = leftBuf[0] + leftBuf[1] + leftBuf[2] + leftBuf[3];
            int sum4 = leftBuf[4] + leftBuf[5] + leftBuf[6] + leftBuf[7];
            Intra8x8PredictionBuilder.fillAdd(residual, (blkY << 4) + blkX, sum3 + sum4 + 4 >> 3);
        } else if (topAvailable) {
            Intra8x8PredictionBuilder.interpolateTop(topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
            int sum1 = topBuf[0] + topBuf[1] + topBuf[2] + topBuf[3];
            int sum2 = topBuf[4] + topBuf[5] + topBuf[6] + topBuf[7];
            Intra8x8PredictionBuilder.fillAdd(residual, (blkY << 4) + blkX, sum1 + sum2 + 4 >> 3);
        } else {
            Intra8x8PredictionBuilder.fillAdd(residual, (blkY << 4) + blkX, 128);
        }
    }

    private static void predictDiagonalDownLeft(int[] residual, boolean topLeftAvailable, boolean topAvailable, boolean topRightAvailable, int[] topLeft, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        Intra8x8PredictionBuilder.genBuf[0] = topBuf[0] + topBuf[2] + (topBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[1] = topBuf[1] + topBuf[3] + (topBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[2] = topBuf[2] + topBuf[4] + (topBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[3] = topBuf[3] + topBuf[5] + (topBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[4] = topBuf[4] + topBuf[6] + (topBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[5] = topBuf[5] + topBuf[7] + (topBuf[6] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[6] = topBuf[6] + topBuf[8] + (topBuf[7] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[7] = topBuf[7] + topBuf[9] + (topBuf[8] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[8] = topBuf[8] + topBuf[10] + (topBuf[9] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[9] = topBuf[9] + topBuf[11] + (topBuf[10] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[10] = topBuf[10] + topBuf[12] + (topBuf[11] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[11] = topBuf[11] + topBuf[13] + (topBuf[12] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = topBuf[12] + topBuf[14] + (topBuf[13] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[13] = topBuf[13] + topBuf[15] + (topBuf[14] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[14] = topBuf[14] + topBuf[15] + (topBuf[15] << 1) + 2 >> 2;
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 1, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 3, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 4, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 5, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 6, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 7, residual, off + 112);
    }

    private static void predictDiagonalDownRight(int[] residual, boolean topRightAvailable, int[] topLeft, int[] leftRow, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(true, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        Intra8x8PredictionBuilder.interpolateLeft(true, topLeft, leftRow, blkY, leftBuf);
        int tl = Intra8x8PredictionBuilder.interpolateTopLeft(true, true, topLeft, topLine, leftRow, mbOffX, blkX, blkY);
        Intra8x8PredictionBuilder.genBuf[0] = leftBuf[7] + leftBuf[5] + (leftBuf[6] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[1] = leftBuf[6] + leftBuf[4] + (leftBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[2] = leftBuf[5] + leftBuf[3] + (leftBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[3] = leftBuf[4] + leftBuf[2] + (leftBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[4] = leftBuf[3] + leftBuf[1] + (leftBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[5] = leftBuf[2] + leftBuf[0] + (leftBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[6] = leftBuf[1] + tl + (leftBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[7] = leftBuf[0] + topBuf[0] + (tl << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[8] = tl + topBuf[1] + (topBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[9] = topBuf[0] + topBuf[2] + (topBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[10] = topBuf[1] + topBuf[3] + (topBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[11] = topBuf[2] + topBuf[4] + (topBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = topBuf[3] + topBuf[5] + (topBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[13] = topBuf[4] + topBuf[6] + (topBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[14] = topBuf[5] + topBuf[7] + (topBuf[6] << 1) + 2 >> 2;
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 7, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 6, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 5, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 4, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 3, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 1, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off + 112);
    }

    private static void predictVerticalRight(int[] residual, boolean topRightAvailable, int[] topLeft, int[] leftRow, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(true, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        Intra8x8PredictionBuilder.interpolateLeft(true, topLeft, leftRow, blkY, leftBuf);
        int tl = Intra8x8PredictionBuilder.interpolateTopLeft(true, true, topLeft, topLine, leftRow, mbOffX, blkX, blkY);
        Intra8x8PredictionBuilder.genBuf[0] = leftBuf[5] + leftBuf[3] + (leftBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[1] = leftBuf[3] + leftBuf[1] + (leftBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[2] = leftBuf[1] + tl + (leftBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[3] = tl + topBuf[0] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[4] = topBuf[0] + topBuf[1] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[5] = topBuf[1] + topBuf[2] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[6] = topBuf[2] + topBuf[3] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[7] = topBuf[3] + topBuf[4] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[8] = topBuf[4] + topBuf[5] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[9] = topBuf[5] + topBuf[6] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[10] = topBuf[6] + topBuf[7] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[11] = leftBuf[6] + leftBuf[4] + (leftBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = leftBuf[4] + leftBuf[2] + (leftBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[13] = leftBuf[2] + leftBuf[0] + (leftBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[14] = leftBuf[0] + topBuf[0] + (tl << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[15] = tl + topBuf[1] + (topBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[16] = topBuf[0] + topBuf[2] + (topBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[17] = topBuf[1] + topBuf[3] + (topBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[18] = topBuf[2] + topBuf[4] + (topBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[19] = topBuf[3] + topBuf[5] + (topBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[20] = topBuf[4] + topBuf[6] + (topBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[21] = topBuf[5] + topBuf[7] + (topBuf[6] << 1) + 2 >> 2;
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 3, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 14, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 13, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 1, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 12, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 11, residual, off + 112);
    }

    private static void predictHorizontalDown(int[] residual, boolean topRightAvailable, int[] topLeft, int[] leftRow, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(true, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        Intra8x8PredictionBuilder.interpolateLeft(true, topLeft, leftRow, blkY, leftBuf);
        int tl = Intra8x8PredictionBuilder.interpolateTopLeft(true, true, topLeft, topLine, leftRow, mbOffX, blkX, blkY);
        Intra8x8PredictionBuilder.genBuf[0] = leftBuf[7] + leftBuf[6] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[1] = leftBuf[5] + leftBuf[7] + (leftBuf[6] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[2] = leftBuf[6] + leftBuf[5] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[3] = leftBuf[4] + leftBuf[6] + (leftBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[4] = leftBuf[5] + leftBuf[4] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[5] = leftBuf[3] + leftBuf[5] + (leftBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[6] = leftBuf[4] + leftBuf[3] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[7] = leftBuf[2] + leftBuf[4] + (leftBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[8] = leftBuf[3] + leftBuf[2] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[9] = leftBuf[1] + leftBuf[3] + (leftBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[10] = leftBuf[2] + leftBuf[1] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[11] = leftBuf[0] + leftBuf[2] + (leftBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = leftBuf[1] + leftBuf[0] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[13] = tl + leftBuf[1] + (leftBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[14] = leftBuf[0] + tl + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[15] = leftBuf[0] + topBuf[0] + (tl << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[16] = tl + topBuf[1] + (topBuf[0] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[17] = topBuf[0] + topBuf[2] + (topBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[18] = topBuf[1] + topBuf[3] + (topBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[19] = topBuf[2] + topBuf[4] + (topBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[20] = topBuf[3] + topBuf[5] + (topBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[21] = topBuf[4] + topBuf[6] + (topBuf[5] << 1) + 2 >> 2;
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 14, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 12, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 10, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 8, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 6, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 4, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off + 112);
    }

    private static void predictVerticalLeft(int[] residual, boolean topLeftAvailable, boolean topRightAvailable, int[] topLeft, int[] topLine, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateTop(topLeftAvailable, topRightAvailable, topLeft, topLine, mbOffX + blkX, blkY, topBuf);
        Intra8x8PredictionBuilder.genBuf[0] = topBuf[0] + topBuf[1] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[1] = topBuf[1] + topBuf[2] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[2] = topBuf[2] + topBuf[3] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[3] = topBuf[3] + topBuf[4] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[4] = topBuf[4] + topBuf[5] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[5] = topBuf[5] + topBuf[6] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[6] = topBuf[6] + topBuf[7] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[7] = topBuf[7] + topBuf[8] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[8] = topBuf[8] + topBuf[9] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[9] = topBuf[9] + topBuf[10] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[10] = topBuf[10] + topBuf[11] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[11] = topBuf[0] + topBuf[2] + (topBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = topBuf[1] + topBuf[3] + (topBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[13] = topBuf[2] + topBuf[4] + (topBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[14] = topBuf[3] + topBuf[5] + (topBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[15] = topBuf[4] + topBuf[6] + (topBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[16] = topBuf[5] + topBuf[7] + (topBuf[6] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[17] = topBuf[6] + topBuf[8] + (topBuf[7] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[18] = topBuf[7] + topBuf[9] + (topBuf[8] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[19] = topBuf[8] + topBuf[10] + (topBuf[9] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[20] = topBuf[9] + topBuf[11] + (topBuf[10] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[21] = topBuf[10] + topBuf[12] + (topBuf[11] << 1) + 2 >> 2;
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 11, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 1, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 12, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 13, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 3, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 14, residual, off + 112);
    }

    private static void predictHorizontalUp(int[] residual, boolean topLeftAvailable, int[] topLeft, int[] leftRow, int mbOffX, int blkX, int blkY) {
        Intra8x8PredictionBuilder.interpolateLeft(topLeftAvailable, topLeft, leftRow, blkY, leftBuf);
        Intra8x8PredictionBuilder.genBuf[0] = leftBuf[0] + leftBuf[1] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[1] = leftBuf[2] + leftBuf[0] + (leftBuf[1] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[2] = leftBuf[1] + leftBuf[2] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[3] = leftBuf[3] + leftBuf[1] + (leftBuf[2] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[4] = leftBuf[2] + leftBuf[3] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[5] = leftBuf[4] + leftBuf[2] + (leftBuf[3] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[6] = leftBuf[3] + leftBuf[4] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[7] = leftBuf[5] + leftBuf[3] + (leftBuf[4] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[8] = leftBuf[4] + leftBuf[5] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[9] = leftBuf[6] + leftBuf[4] + (leftBuf[5] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[10] = leftBuf[5] + leftBuf[6] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[11] = leftBuf[7] + leftBuf[5] + (leftBuf[6] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[12] = leftBuf[6] + leftBuf[7] + 1 >> 1;
        Intra8x8PredictionBuilder.genBuf[13] = leftBuf[6] + leftBuf[7] + (leftBuf[7] << 1) + 2 >> 2;
        Intra8x8PredictionBuilder.genBuf[20] = Intra8x8PredictionBuilder.genBuf[21] = leftBuf[7];
        Intra8x8PredictionBuilder.genBuf[19] = Intra8x8PredictionBuilder.genBuf[21];
        Intra8x8PredictionBuilder.genBuf[18] = Intra8x8PredictionBuilder.genBuf[21];
        Intra8x8PredictionBuilder.genBuf[17] = Intra8x8PredictionBuilder.genBuf[21];
        Intra8x8PredictionBuilder.genBuf[16] = Intra8x8PredictionBuilder.genBuf[21];
        Intra8x8PredictionBuilder.genBuf[15] = Intra8x8PredictionBuilder.genBuf[21];
        Intra8x8PredictionBuilder.genBuf[14] = Intra8x8PredictionBuilder.genBuf[21];
        int off = (blkY << 4) + blkX;
        Intra8x8PredictionBuilder.copyAdd(genBuf, 0, residual, off);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 2, residual, off + 16);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 4, residual, off + 32);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 6, residual, off + 48);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 8, residual, off + 64);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 10, residual, off + 80);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 12, residual, off + 96);
        Intra8x8PredictionBuilder.copyAdd(genBuf, 14, residual, off + 112);
    }
}

