/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.common.model.Picture;

public class BlockInterpolator {
    private static int[] tmp1 = new int[1024];
    private static LumaInterpolator[] safe = new LumaInterpolator[]{new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma00(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma10(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma20(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma30(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma01(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma11(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma21(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma31(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma02(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma12(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma22(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma32(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma03(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma13(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma23(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma33(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }};
    private static LumaInterpolator[] unsafe = new LumaInterpolator[]{new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma00Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma10Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma20Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma30Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma01Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma11Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma21Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma31Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma02Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma12Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma22Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma32Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma03Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma13Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma23Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }, new LumaInterpolator(){

        @Override
        public void getLuma(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
            BlockInterpolator.getLuma33Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        }
    }};

    public static void getBlockLuma(Picture pic, Picture out, int off, int x, int y, int w, int h2) {
        int xInd = x & 3;
        int yInd = y & 3;
        int xFp = x >> 2;
        int yFp = y >> 2;
        if (xFp < 2 || yFp < 2 || xFp > pic.getWidth() - w - 5 || yFp > pic.getHeight() - h2 - 5) {
            unsafe[(yInd << 2) + xInd].getLuma(pic.getData()[0], pic.getWidth(), pic.getHeight(), out.getPlaneData(0), off, out.getPlaneWidth(0), xFp, yFp, w, h2);
        } else {
            safe[(yInd << 2) + xInd].getLuma(pic.getData()[0], pic.getWidth(), pic.getHeight(), out.getPlaneData(0), off, out.getPlaneWidth(0), xFp, yFp, w, h2);
        }
    }

    public static void getBlockChroma(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int xInd = x & 7;
        int yInd = y & 7;
        int xFull = x >> 3;
        int yFull = y >> 3;
        if (xFull < 0 || xFull > picW - blkW - 1 || yFull < 0 || yFull > picH - blkH - 1) {
            if (xInd == 0 && yInd == 0) {
                BlockInterpolator.getChroma00Unsafe(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, blkW, blkH);
            } else if (yInd == 0) {
                BlockInterpolator.getChromaX0Unsafe(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, xInd, blkW, blkH);
            } else if (xInd == 0) {
                BlockInterpolator.getChroma0XUnsafe(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, yInd, blkW, blkH);
            } else {
                BlockInterpolator.getChromaXXUnsafe(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, xInd, yInd, blkW, blkH);
            }
        } else if (xInd == 0 && yInd == 0) {
            BlockInterpolator.getChroma00(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, blkW, blkH);
        } else if (yInd == 0) {
            BlockInterpolator.getChromaX0(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, xInd, blkW, blkH);
        } else if (xInd == 0) {
            BlockInterpolator.getChroma0X(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, yInd, blkW, blkH);
        } else {
            BlockInterpolator.getChromaXX(pels, picW, picH, blk, blkOff, blkStride, xFull, yFull, xInd, yInd, blkW, blkH);
        }
    }

    private static void getLuma00(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            System.arraycopy(pic, off, blk, blkOff, blkW);
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma00Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, j2 + y) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2)];
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma20NoRound(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            int off1 = -2;
            for (int i2 = 0; i2 < blkW; ++i2) {
                int val = pic[off + off1] + pic[off + off1 + 5] - 5 * (pic[off + off1 + 1] + pic[off + off1 + 4]) + 20 * (pic[off + off1 + 2] + pic[off + off1 + 3]);
                ++off1;
                blk[blkOff + i2] = val;
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma20(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20NoRound(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 16 >> 5);
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma20UnsafeNoRound(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxW = picW - 1;
        int maxH = picH - 1;
        for (int i2 = 0; i2 < blkW; ++i2) {
            int ipos_m2 = BlockInterpolator.iClip3(0, maxW, x + i2 - 2);
            int ipos_m1 = BlockInterpolator.iClip3(0, maxW, x + i2 - 1);
            int ipos = BlockInterpolator.iClip3(0, maxW, x + i2);
            int ipos_p1 = BlockInterpolator.iClip3(0, maxW, x + i2 + 1);
            int ipos_p2 = BlockInterpolator.iClip3(0, maxW, x + i2 + 2);
            int ipos_p3 = BlockInterpolator.iClip3(0, maxW, x + i2 + 3);
            int boff = blkOff;
            for (int j2 = 0; j2 < blkH; ++j2) {
                int result;
                int lineStart = BlockInterpolator.iClip3(0, maxH, j2 + y) * picW;
                blk[boff + i2] = result = pic[lineStart + ipos_m2] + pic[lineStart + ipos_p3] - (pic[lineStart + ipos_m1] + pic[lineStart + ipos_p2]) * 5 + (pic[lineStart + ipos] + pic[lineStart + ipos_p1]) * 20;
                boff += blkStride;
            }
        }
    }

    private static void getLuma20Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20UnsafeNoRound(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int i2 = 0; i2 < blkW; ++i2) {
            int boff = blkOff;
            for (int j2 = 0; j2 < blkH; ++j2) {
                blk[boff + i2] = BlockInterpolator.iClip3(0, 255, blk[boff + i2] + 16 >> 5);
                boff += blkStride;
            }
        }
    }

    private static void getLuma02NoRound(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int off = (y - 2) * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int val;
                blk[blkOff + i2] = val = pic[off + i2] + pic[off + i2 + 5 * picW] - 5 * (pic[off + i2 + picW] + pic[off + i2 + 4 * picW]) + 20 * (pic[off + i2 + 2 * picW] + pic[off + i2 + 3 * picW]);
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma02(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma02NoRound(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 16 >> 5);
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma02UnsafeNoRound(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            int offP0 = BlockInterpolator.iClip3(0, maxH, y + j2 - 2) * picW;
            int offP1 = BlockInterpolator.iClip3(0, maxH, y + j2 - 1) * picW;
            int offP2 = BlockInterpolator.iClip3(0, maxH, y + j2) * picW;
            int offP3 = BlockInterpolator.iClip3(0, maxH, y + j2 + 1) * picW;
            int offP4 = BlockInterpolator.iClip3(0, maxH, y + j2 + 2) * picW;
            int offP5 = BlockInterpolator.iClip3(0, maxH, y + j2 + 3) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                int result;
                int pres_x = BlockInterpolator.iClip3(0, maxW, x + i2);
                blk[blkOff + i2] = result = pic[pres_x + offP0] + pic[pres_x + offP5] - (pic[pres_x + offP1] + pic[pres_x + offP4]) * 5 + (pic[pres_x + offP2] + pic[pres_x + offP3]) * 20;
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma02Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma02UnsafeNoRound(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 16 >> 5);
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma10(int[] oic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(oic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + oic[off + i2] + 1 >> 1;
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma10Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        BlockInterpolator.getLuma20Unsafe(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, j2 + y) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2)] + 1 >> 1;
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma30(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = pic[off + i2 + 1] + blk[blkOff + i2] + 1 >> 1;
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma30Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        BlockInterpolator.getLuma20Unsafe(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, j2 + y) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2 + 1)] + 1 >> 1;
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma01(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma02(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[off + i2] + 1 >> 1;
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma01Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        BlockInterpolator.getLuma02Unsafe(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, y + j2) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2)] + 1 >> 1;
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma03(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma02(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[off + i2 + picW] + 1 >> 1;
            }
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getLuma03Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        BlockInterpolator.getLuma02Unsafe(pic, picW, picH, blk, blkOff, blkStride, x, y, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, y + j2 + 1) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2)] + 1 >> 1;
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma21(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20NoRound(pic, picW, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        int off = blkW << 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += blkW;
        }
    }

    private static void getLuma21Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20UnsafeNoRound(pic, picW, imgH, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        int off = blkW << 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += blkW;
        }
    }

    private static void getLuma22(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20NoRound(pic, picW, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma22Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20UnsafeNoRound(pic, picW, imgH, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
            }
            blkOff += blkStride;
        }
    }

    private static void getLuma23(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20NoRound(pic, picW, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        int off = blkW << 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2 + blkW] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += blkW;
        }
    }

    private static void getLuma23Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20UnsafeNoRound(pic, picW, imgH, tmp1, 0, blkW, x, y - 2, blkW, blkH + 7);
        BlockInterpolator.getLuma02NoRound(tmp1, blkW, blk, blkOff, blkStride, 0, 2, blkW, blkH);
        int off = blkW << 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2 + blkW] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += blkW;
        }
    }

    private static void getLuma12(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int tmpW = blkW + 7;
        BlockInterpolator.getLuma02NoRound(pic, picW, tmp1, 0, tmpW, x - 2, y, tmpW, blkH);
        BlockInterpolator.getLuma20NoRound(tmp1, tmpW, blk, blkOff, blkStride, 2, 0, blkW, blkH);
        int off = 2;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += tmpW;
        }
    }

    private static void getLuma12Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int tmpW = blkW + 7;
        BlockInterpolator.getLuma02UnsafeNoRound(pic, picW, imgH, tmp1, 0, tmpW, x - 2, y, tmpW, blkH);
        BlockInterpolator.getLuma20NoRound(tmp1, tmpW, blk, blkOff, blkStride, 2, 0, blkW, blkH);
        int off = 2;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += tmpW;
        }
    }

    private static void getLuma32(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int tmpW = blkW + 7;
        BlockInterpolator.getLuma02NoRound(pic, picW, tmp1, 0, tmpW, x - 2, y, tmpW, blkH);
        BlockInterpolator.getLuma20NoRound(tmp1, tmpW, blk, blkOff, blkStride, 2, 0, blkW, blkH);
        int off = 2;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2 + 1] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += tmpW;
        }
    }

    private static void getLuma32Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int tmpW = blkW + 7;
        BlockInterpolator.getLuma02UnsafeNoRound(pic, picW, imgH, tmp1, 0, tmpW, x - 2, y, tmpW, blkH);
        BlockInterpolator.getLuma20NoRound(tmp1, tmpW, blk, blkOff, blkStride, 2, 0, blkW, blkH);
        int off = 2;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int rounded = BlockInterpolator.iClip3(0, 255, blk[blkOff + i2] + 512 >> 10);
                int rounded2 = BlockInterpolator.iClip3(0, 255, tmp1[off + i2 + 1] + 16 >> 5);
                blk[blkOff + i2] = rounded + rounded2 + 1 >> 1;
            }
            blkOff += blkStride;
            off += tmpW;
        }
    }

    private static void getLuma33(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(pic, picW, blk, blkOff, blkStride, x, y + 1, blkW, blkH);
        BlockInterpolator.getLuma02(pic, picW, tmp1, 0, blkW, x + 1, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma33Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20Unsafe(pic, picW, imgH, blk, blkOff, blkStride, x, y + 1, blkW, blkH);
        BlockInterpolator.getLuma02Unsafe(pic, picW, imgH, tmp1, 0, blkW, x + 1, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma11(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(pic, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        BlockInterpolator.getLuma02(pic, picW, tmp1, 0, blkW, x, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma11Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20Unsafe(pic, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        BlockInterpolator.getLuma02Unsafe(pic, picW, imgH, tmp1, 0, blkW, x, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma13(int[] pic, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(pic, picW, blk, blkOff, blkStride, x, y + 1, blkW, blkH);
        BlockInterpolator.getLuma02(pic, picW, tmp1, 0, blkW, x, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma13Unsafe(int[] pic, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20Unsafe(pic, picW, imgH, blk, blkOff, blkStride, x, y + 1, blkW, blkH);
        BlockInterpolator.getLuma02Unsafe(pic, picW, imgH, tmp1, 0, blkW, x, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma31(int[] pels, int picW, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20(pels, picW, blk, blkOff, blkStride, x, y, blkW, blkH);
        BlockInterpolator.getLuma02(pels, picW, tmp1, 0, blkW, x + 1, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static void getLuma31Unsafe(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        BlockInterpolator.getLuma20Unsafe(pels, picW, imgH, blk, blkOff, blkStride, x, y, blkW, blkH);
        BlockInterpolator.getLuma02Unsafe(pels, picW, imgH, tmp1, 0, blkW, x + 1, y, blkW, blkH);
        BlockInterpolator.mergeCrap(blk, blkOff, blkStride, blkW, blkH);
    }

    private static int iClip3(int min, int max, int val) {
        return val < min ? min : (val > max ? max : val);
    }

    private static void mergeCrap(int[] blk, int blkOff, int blkStride, int blkW, int blkH) {
        int tOff = 0;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = blk[blkOff + i2] + tmp1[tOff + i2] + 1 >> 1;
            }
            blkOff += blkStride;
            tOff += blkW;
        }
    }

    private static void getChroma00(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int off = y * picW + x;
        for (int j2 = 0; j2 < blkH; ++j2) {
            System.arraycopy(pic, off, blk, blkOff, blkW);
            off += picW;
            blkOff += blkStride;
        }
    }

    private static void getChroma00Unsafe(int[] pic, int picW, int picH, int[] blk, int blkOff, int blkStride, int x, int y, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            int lineStart = BlockInterpolator.iClip3(0, maxH, j2 + y) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = pic[lineStart + BlockInterpolator.iClip3(0, maxW, x + i2)];
            }
            blkOff += blkStride;
        }
    }

    private static void getChroma0X(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracY, int blkW, int blkH) {
        int w00 = fullY * picW + fullX;
        int w01 = w00 + (fullY < picH - 1 ? picW : 0);
        int eMy = 8 - fracY;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = eMy * pels[w00 + i2] + fracY * pels[w01 + i2] + 4 >> 3;
            }
            w00 += picW;
            w01 += picW;
            blkOff += blkStride;
        }
    }

    private static void getChroma0XUnsafe(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracY, int blkW, int blkH) {
        int maxW = picW - 1;
        int maxH = picH - 1;
        int eMy = 8 - fracY;
        for (int j2 = 0; j2 < blkH; ++j2) {
            int off00 = BlockInterpolator.iClip3(0, maxH, fullY + j2) * picW;
            int off01 = BlockInterpolator.iClip3(0, maxH, fullY + j2 + 1) * picW;
            for (int i2 = 0; i2 < blkW; ++i2) {
                int w00 = BlockInterpolator.iClip3(0, maxW, fullX + i2) + off00;
                int w01 = BlockInterpolator.iClip3(0, maxW, fullX + i2) + off01;
                blk[blkOff + i2] = eMy * pels[w00] + fracY * pels[w01] + 4 >> 3;
            }
            blkOff += blkStride;
        }
    }

    private static void getChromaX0(int[] pels, int picW, int imgH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracX, int blkW, int blkH) {
        int w00 = fullY * picW + fullX;
        int w10 = w00 + (fullX < picW - 1 ? 1 : 0);
        int eMx = 8 - fracX;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = eMx * pels[w00 + i2] + fracX * pels[w10 + i2] + 4 >> 3;
            }
            w00 += picW;
            w10 += picW;
            blkOff += blkStride;
        }
    }

    private static void getChromaX0Unsafe(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracX, int blkW, int blkH) {
        int eMx = 8 - fracX;
        int maxW = picW - 1;
        int maxH = picH - 1;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int w00 = BlockInterpolator.iClip3(0, maxH, fullY + j2) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2);
                int w10 = BlockInterpolator.iClip3(0, maxH, fullY + j2) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2 + 1);
                blk[blkOff + i2] = eMx * pels[w00] + fracX * pels[w10] + 4 >> 3;
            }
            blkOff += blkStride;
        }
    }

    private static void getChromaXX(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracX, int fracY, int blkW, int blkH) {
        int w00 = fullY * picW + fullX;
        int w01 = w00 + (fullY < picH - 1 ? picW : 0);
        int w10 = w00 + (fullX < picW - 1 ? 1 : 0);
        int w11 = w10 + w01 - w00;
        int eMx = 8 - fracX;
        int eMy = 8 - fracY;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                blk[blkOff + i2] = eMx * eMy * pels[w00 + i2] + fracX * eMy * pels[w10 + i2] + eMx * fracY * pels[w01 + i2] + fracX * fracY * pels[w11 + i2] + 32 >> 6;
            }
            blkOff += blkStride;
            w00 += picW;
            w01 += picW;
            w10 += picW;
            w11 += picW;
        }
    }

    private static void getChromaXXUnsafe(int[] pels, int picW, int picH, int[] blk, int blkOff, int blkStride, int fullX, int fullY, int fracX, int fracY, int blkW, int blkH) {
        int maxH = picH - 1;
        int maxW = picW - 1;
        int eMx = 8 - fracX;
        int eMy = 8 - fracY;
        for (int j2 = 0; j2 < blkH; ++j2) {
            for (int i2 = 0; i2 < blkW; ++i2) {
                int w00 = BlockInterpolator.iClip3(0, maxH, fullY + j2) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2);
                int w01 = BlockInterpolator.iClip3(0, maxH, fullY + j2 + 1) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2);
                int w10 = BlockInterpolator.iClip3(0, maxH, fullY + j2) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2 + 1);
                int w11 = BlockInterpolator.iClip3(0, maxH, fullY + j2 + 1) * picW + BlockInterpolator.iClip3(0, maxW, fullX + i2 + 1);
                blk[blkOff + i2] = eMx * eMy * pels[w00] + fracX * eMy * pels[w10] + eMx * fracY * pels[w01] + fracX * fracY * pels[w11] + 32 >> 6;
            }
            blkOff += blkStride;
        }
    }

    private static interface LumaInterpolator {
        public void getLuma(int[] var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10);
    }
}

