/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.muxer.MP4Muxer;

public class H264Utils {
    public static ByteBuffer nextNALUnit(ByteBuffer buf) {
        H264Utils.skipToNALUnit(buf);
        return H264Utils.gotoNALUnit(buf);
    }

    public static final void skipToNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return;
        }
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position());
            break;
        }
    }

    public static final ByteBuffer gotoNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return null;
        }
        int from = buf.position();
        ByteBuffer result = buf.slice();
        result.order(ByteOrder.BIG_ENDIAN);
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position() - (val == 1 ? 4 : 3));
            result.limit(buf.position() - from);
            break;
        }
        return result;
    }

    public static final void unescapeNAL(ByteBuffer _buf) {
        if (_buf.remaining() < 2) {
            return;
        }
        ByteBuffer in = _buf.duplicate();
        ByteBuffer out = _buf.duplicate();
        byte p1 = in.get();
        out.put(p1);
        byte p2 = in.get();
        out.put(p2);
        while (in.hasRemaining()) {
            byte b2 = in.get();
            if (p1 != 0 || p2 != 0 || b2 != 3) {
                out.put(b2);
            }
            p1 = p2;
            p2 = b2;
        }
        _buf.limit(out.position());
    }

    public static final void escapeNAL(ByteBuffer src, ByteBuffer dst) {
        int p1 = src.get();
        int p2 = src.get();
        dst.put((byte)p1);
        dst.put((byte)p2);
        while (src.hasRemaining()) {
            int b2 = src.get();
            if (p1 == 0 && p2 == 0 && (b2 & 0xFF) <= 3) {
                dst.put((byte)3);
                p1 = p2;
                p2 = 3;
            }
            dst.put((byte)b2);
            p1 = p2;
            p2 = b2;
        }
    }

    public static int golomb2Signed(int val) {
        int sign = ((val & 1) << 1) - 1;
        val = ((val >> 1) + (val & 1)) * sign;
        return val;
    }

    public static List<ByteBuffer> splitMOVPacket(ByteBuffer buf, AvcCBox avcC) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        int nls = avcC.getNalLengthSize();
        ByteBuffer dup = buf.duplicate();
        while (dup.hasRemaining()) {
            int len = H264Utils.readLen(dup, nls);
            result.add(NIOUtils.read(dup, len));
        }
        return result;
    }

    private static int readLen(ByteBuffer dup, int nls) {
        switch (nls) {
            case 1: {
                return dup.get() & 0xFF;
            }
            case 2: {
                return dup.getShort() & 0xFFFF;
            }
            case 3: {
                return (dup.getShort() & 0xFFFF) << 8 | dup.get() & 0xFF;
            }
            case 4: {
                return dup.getInt();
            }
        }
        throw new IllegalArgumentException("NAL Unit length size can not be " + nls);
    }

    public static void encodeMOVPacket(ByteBuffer avcFrame, List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
        ByteBuffer buf;
        ByteBuffer dup = avcFrame.duplicate();
        ByteBuffer d1 = avcFrame.duplicate();
        int tot = 0;
        while ((buf = H264Utils.nextNALUnit(dup)) != null) {
            d1.position(tot);
            d1.putInt(buf.remaining());
            tot += buf.remaining() + 4;
            NALUnit nu = NALUnit.read(buf);
            if (nu.type == NALUnitType.PPS && ppsList != null) {
                ppsList.add(buf);
                continue;
            }
            if (nu.type != NALUnitType.SPS || spsList == null) continue;
            spsList.add(buf);
        }
    }

    public static SampleEntry createMOVSampleEntry(List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
        SeqParameterSet sps = SeqParameterSet.read(spsList.get(0).duplicate());
        AvcCBox avcC = new AvcCBox(sps.profile_idc, 0, sps.level_idc, spsList, ppsList);
        int codedWidth = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int codedHeight = H264Utils.getPicHeightInMbs(sps) << 4;
        int width = sps.frame_cropping_flag ? codedWidth - (sps.frame_crop_right_offset + sps.frame_crop_left_offset << sps.chroma_format_idc.compWidth[1]) : codedWidth;
        int height = sps.frame_cropping_flag ? codedHeight - (sps.frame_crop_bottom_offset + sps.frame_crop_top_offset << sps.chroma_format_idc.compHeight[1]) : codedHeight;
        Size size = new Size(width, height);
        VideoSampleEntry se = MP4Muxer.videoSampleEntry("avc1", size, "JCodec");
        se.add(avcC);
        return se;
    }

    public static SampleEntry createMOVSampleEntry(SeqParameterSet initSPS, PictureParameterSet initPPS) {
        ByteBuffer bb1 = ByteBuffer.allocate(512);
        ByteBuffer bb2 = ByteBuffer.allocate(512);
        initSPS.write(bb1);
        initPPS.write(bb2);
        bb1.flip();
        bb2.flip();
        return H264Utils.createMOVSampleEntry(Arrays.asList(bb1), Arrays.asList(bb2));
    }

    public static boolean idrSlice(ByteBuffer _data) {
        ByteBuffer segment;
        ByteBuffer data = _data.duplicate();
        while ((segment = H264Utils.nextNALUnit(data)) != null) {
            if (NALUnit.read((ByteBuffer)segment).type != NALUnitType.IDR_SLICE) continue;
            return true;
        }
        return false;
    }

    public static boolean idrSlice(List<ByteBuffer> _data) {
        for (ByteBuffer segment : _data) {
            if (NALUnit.read((ByteBuffer)segment.duplicate()).type != NALUnitType.IDR_SLICE) continue;
            return true;
        }
        return false;
    }

    public static void saveRawFrame(ByteBuffer data, AvcCBox avcC, File f2) throws IOException {
        FileChannelWrapper raw = NIOUtils.writableFileChannel(f2);
        H264Utils.saveStreamParams(avcC, raw);
        raw.write(data.duplicate());
        raw.close();
    }

    public static void saveStreamParams(AvcCBox avcC, SeekableByteChannel raw) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        for (ByteBuffer byteBuffer : avcC.getSpsList()) {
            raw.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 103}));
            H264Utils.escapeNAL(byteBuffer.duplicate(), bb);
            bb.flip();
            raw.write(bb);
            bb.clear();
        }
        for (ByteBuffer byteBuffer : avcC.getPpsList()) {
            raw.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 104}));
            H264Utils.escapeNAL(byteBuffer.duplicate(), bb);
            bb.flip();
            raw.write(bb);
            bb.clear();
        }
    }

    public static int getPicHeightInMbs(SeqParameterSet sps) {
        int picHeightInMbs = sps.pic_height_in_map_units_minus1 + 1 << (sps.frame_mbs_only_flag ? 0 : 1);
        return picHeightInMbs;
    }

    public static List<ByteBuffer> splitFrame(ByteBuffer frame) {
        ByteBuffer segment;
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        while ((segment = H264Utils.nextNALUnit(frame)) != null) {
            result.add(segment);
        }
        return result;
    }

    public static void joinNALUnits(List<ByteBuffer> nalUnits, ByteBuffer out) {
        for (ByteBuffer nal : nalUnits) {
            out.putInt(1);
            out.put(nal.duplicate());
        }
    }
}

