/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.aac.blocks;

import org.jcodec.codecs.aac.BlockType;
import org.jcodec.codecs.aac.blocks.AACTab;
import org.jcodec.codecs.aac.blocks.Block;
import org.jcodec.codecs.aac.blocks.BlockICS;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.VLC;

public class BlockCCE
extends Block {
    private int coupling_point;
    private int num_coupled;
    private BlockType[] type;
    private int[] id_select;
    private int[] ch_select;
    private int sign;
    private Object scale;
    private Object[] cce_scale;
    private BlockICS blockICS;
    private BlockICS.BandType[] bandType;
    static VLC vlc = new VLC(AACTab.ff_aac_scalefactor_code, AACTab.ff_aac_scalefactor_bits);

    public BlockCCE(BlockICS.BandType[] bandType) {
        this.bandType = bandType;
    }

    @Override
    public void parse(BitReader in) {
        int c2;
        int num_gain = 0;
        this.coupling_point = 2 * in.read1Bit();
        this.num_coupled = in.readNBit(3);
        for (c2 = 0; c2 <= this.num_coupled; ++c2) {
            ++num_gain;
            this.type[c2] = in.read1Bit() != 0 ? BlockType.TYPE_CPE : BlockType.TYPE_SCE;
            this.id_select[c2] = in.readNBit(4);
            if (this.type[c2] == BlockType.TYPE_CPE) {
                this.ch_select[c2] = in.readNBit(2);
                if (this.ch_select[c2] != 3) continue;
                ++num_gain;
                continue;
            }
            this.ch_select[c2] = 2;
        }
        this.coupling_point += in.read1Bit() | this.coupling_point >> 1;
        this.sign = in.read1Bit();
        this.scale = this.cce_scale[in.readNBit(2)];
        this.blockICS = new BlockICS();
        this.blockICS.parse(in);
        for (c2 = 0; c2 < num_gain; ++c2) {
            int idx = 0;
            int cge = 1;
            int gain = 0;
            if (c2 != 0) {
                cge = this.coupling_point == CouplingPoint.AFTER_IMDCT.ordinal() ? 1 : in.read1Bit();
                int n2 = gain = cge != 0 ? vlc.readVLC(in) - 60 : 0;
            }
            if (this.coupling_point == CouplingPoint.AFTER_IMDCT.ordinal()) continue;
            for (int g2 = 0; g2 < this.blockICS.num_window_groups; ++g2) {
                int sfb = 0;
                while (sfb < this.blockICS.maxSfb) {
                    if (this.bandType[idx] != BlockICS.BandType.ZERO_BT && cge == 0) {
                        int t = vlc.readVLC(in) - 60;
                    }
                    ++sfb;
                    ++idx;
                }
            }
        }
    }

    static enum CouplingPoint {
        BEFORE_TNS,
        BETWEEN_TNS_AND_IMDCT,
        UNDEF,
        AFTER_IMDCT;

    }
}

