/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.specific;

import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleEntry;

public class AVCMP4Adaptor
implements ContainerAdaptor {
    private H264Decoder decoder;
    private SampleEntry[] ses;
    private AvcCBox avcCBox;
    private int curENo;

    public AVCMP4Adaptor(SampleEntry[] ses) {
        this.ses = ses;
        this.curENo = -1;
    }

    @Override
    public Picture decodeFrame(Packet packet, int[][] data) {
        this.updateState(packet);
        Frame pic = this.decoder.decodeFrame(H264Utils.splitMOVPacket(packet.getData(), this.avcCBox), data);
        PixelAspectExt pasp = Box.findFirst((NodeBox)this.ses[this.curENo], PixelAspectExt.class, "pasp");
        if (pasp != null) {
            // empty if block
        }
        return pic;
    }

    private void updateState(Packet packet) {
        int eNo = ((MP4Packet)packet).getEntryNo();
        if (eNo != this.curENo) {
            this.curENo = eNo;
            this.avcCBox = new AvcCBox();
            this.avcCBox.parse(Box.findFirst((NodeBox)this.ses[this.curENo], LeafBox.class, "avcC").getData());
            this.decoder = new H264Decoder();
            this.decoder.addSps(this.avcCBox.getSpsList());
            this.decoder.addPps(this.avcCBox.getPpsList());
        }
    }

    @Override
    public boolean canSeek(Packet pkt) {
        this.updateState(pkt);
        return H264Utils.idrSlice(H264Utils.splitMOVPacket(pkt.getData(), this.avcCBox));
    }
}

