/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.MP4Muxer;

public class SequenceMuxer {
    private SeekableByteChannel ch;
    private FramesMP4MuxerTrack outTrack;
    private int frameNo;
    private MP4Muxer muxer;
    private Size size;

    public SequenceMuxer(File out) throws IOException {
        this.ch = NIOUtils.writableFileChannel(out);
        this.muxer = new MP4Muxer(this.ch, Brand.MP4);
        this.outTrack = this.muxer.addTrackForCompressed(TrackType.VIDEO, 25);
    }

    public void encodeImage(File png) throws IOException {
        if (this.size == null) {
            BufferedImage read = ImageIO.read(png);
            this.size = new Size(read.getWidth(), read.getHeight());
        }
        this.outTrack.addFrame(new MP4Packet(NIOUtils.fetchFrom(png), this.frameNo, 25L, 1L, this.frameNo, true, null, this.frameNo, 0));
        ++this.frameNo;
    }

    public void finish() throws IOException {
        this.outTrack.addSampleEntry(MP4Muxer.videoSampleEntry("png ", this.size, "JCodec"));
        this.muxer.writeHeader();
        NIOUtils.closeQuietly(this.ch);
    }
}

