/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jcodec.api.JCodecException;
import org.jcodec.api.UnsupportedFormatException;
import org.jcodec.api.specific.AVCMP4Adaptor;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;

public class FrameGrab {
    private static final int KEYFRAME_TEST_STEP = 24;
    private DemuxerTrack videoTrack;
    private ContainerAdaptor decoder;
    private SeekableByteChannel ch;

    public FrameGrab(SeekableByteChannel in) throws IOException, JCodecException {
        this.ch = in;
        ByteBuffer header = ByteBuffer.allocate(65536);
        this.ch.read(header);
        header.flip();
        JCodecUtil.Format detectFormat = JCodecUtil.detectFormat(header);
        switch (detectFormat) {
            case MOV: {
                MP4Demuxer demuxer = new MP4Demuxer(this.ch);
                this.videoTrack = demuxer.getVideoTrack();
                break;
            }
            case MPEG_PS: {
                throw new UnsupportedFormatException("MPEG PS is temporarily unsupported.");
            }
            case MPEG_TS: {
                throw new UnsupportedFormatException("MPEG TS is temporarily unsupported.");
            }
            default: {
                throw new UnsupportedFormatException("Container format is not supported by JCodec");
            }
        }
        this.decodeLeadingFrames();
    }

    public FrameGrab seekToSecondPrecise(double second) throws IOException, JCodecException {
        this.videoTrack.seek(second);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab seekToFramePrecise(int frameNumber) throws IOException, JCodecException {
        this.videoTrack.gotoFrame(frameNumber);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab seekToSecondSloppy(double second) throws IOException, JCodecException {
        this.videoTrack.seek(second);
        this.goToPrevKeyframe();
        return this;
    }

    public FrameGrab seekToFrameSloppy(int frameNumber) throws IOException, JCodecException {
        this.videoTrack.gotoFrame(frameNumber);
        this.goToPrevKeyframe();
        return this;
    }

    private void goToPrevKeyframe() throws IOException, JCodecException {
        Packet frame = this.videoTrack.nextFrame();
        int orig = (int)frame.getFrameNo();
        this.decoder = this.detectDecoder(this.videoTrack, frame);
        if (!frame.isKeyFrame() || !this.decoder.canSeek(frame)) {
            ArrayList<Packet> packets = new ArrayList<Packet>();
            int keyFrame = this.detectKeyFrame((int)frame.getFrameNo(), packets);
            this.videoTrack.gotoFrame(keyFrame == -1 ? 0L : (long)keyFrame);
        } else {
            this.videoTrack.gotoFrame(orig);
        }
    }

    private void decodeLeadingFrames() throws IOException, JCodecException {
        Packet frame = this.videoTrack.nextFrame();
        int orig = (int)frame.getFrameNo();
        this.decoder = this.detectDecoder(this.videoTrack, frame);
        if (!frame.isKeyFrame() || !this.decoder.canSeek(frame)) {
            ArrayList<Packet> packets = new ArrayList<Packet>();
            int keyFrame = this.detectKeyFrame((int)frame.getFrameNo(), packets);
            if (keyFrame != -1) {
                Collections.sort(packets, Packet.FRAME_ASC);
                Iterator it = packets.iterator();
                while (it.hasNext() && ((Packet)it.next()).getFrameNo() != (long)keyFrame) {
                    it.remove();
                }
                Picture buf = Picture.create(1920, 1088, ColorSpace.YUV444);
                for (Packet packet : packets) {
                    this.decoder.decodeFrame(packet, buf.getData());
                }
            } else {
                orig = 0;
            }
        }
        this.videoTrack.gotoFrame(orig);
    }

    private int detectKeyFrame(int start, List<Packet> packets) throws IOException {
        int keyFrame = -1;
        while (keyFrame == -1 && start > 0) {
            int prevStart = Math.max(start - 24, 0);
            this.videoTrack.gotoFrame(prevStart);
            while (this.videoTrack.getCurFrame() < (long)start) {
                Packet frame = this.videoTrack.nextFrame();
                if (frame.isKeyFrame() && this.decoder.canSeek(frame)) {
                    keyFrame = (int)frame.getFrameNo();
                }
                packets.add(frame);
            }
            start = prevStart;
        }
        return keyFrame;
    }

    private ContainerAdaptor detectDecoder(DemuxerTrack videoTrack, Packet frame) throws JCodecException {
        SampleEntry se;
        VideoDecoder byFourcc;
        if (videoTrack instanceof AbstractMP4DemuxerTrack && (byFourcc = this.byFourcc((se = ((AbstractMP4DemuxerTrack)videoTrack).getSampleEntries()[((MP4Packet)frame).getEntryNo()]).getHeader().getFourcc())) instanceof H264Decoder) {
            return new AVCMP4Adaptor(((AbstractMP4DemuxerTrack)videoTrack).getSampleEntries());
        }
        throw new UnsupportedFormatException("Codec is not supported");
    }

    private VideoDecoder byFourcc(String fourcc) {
        if (fourcc.equals("avc1")) {
            return new H264Decoder();
        }
        if (fourcc.equals("m1v1") || fourcc.equals("m2v1")) {
            return new MPEGDecoder();
        }
        if (fourcc.equals("apco") || fourcc.equals("apcs") || fourcc.equals("apcn") || fourcc.equals("apch") || fourcc.equals("ap4h")) {
            return new ProresDecoder();
        }
        return null;
    }

    public BufferedImage getFrame() throws IOException {
        return JCodecUtil.toBufferedImage(this.getNativeFrame());
    }

    public Picture getNativeFrame() throws IOException {
        Packet frames = this.videoTrack.nextFrame();
        Picture buffer = Picture.create(1920, 1088, ColorSpace.YUV444);
        return this.decoder.decodeFrame(frames, buffer.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getFrame(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableFileChannel(file);
            BufferedImage bufferedImage = new FrameGrab(ch).seekToSecondPrecise(second).getFrame();
            return bufferedImage;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static BufferedImage getFrame(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return new FrameGrab(file).seekToSecondPrecise(second).getFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture getNativeFrame(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableFileChannel(file);
            Picture picture = new FrameGrab(ch).seekToSecondPrecise(second).getNativeFrame();
            return picture;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static Picture getNativeFrame(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return new FrameGrab(file).seekToSecondPrecise(second).getNativeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getFrame(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableFileChannel(file);
            BufferedImage bufferedImage = new FrameGrab(ch).seekToFramePrecise(frameNumber).getFrame();
            return bufferedImage;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static BufferedImage getFrame(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return new FrameGrab(file).seekToFramePrecise(frameNumber).getFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture getNativeFrame(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableFileChannel(file);
            Picture picture = new FrameGrab(ch).seekToFramePrecise(frameNumber).getNativeFrame();
            return picture;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static Picture getNativeFrame(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return new FrameGrab(file).seekToFramePrecise(frameNumber).getNativeFrame();
    }
}

