/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.algo;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Vector;
import org.jcodec.algo.ControlPoint;

class InterpPanel
extends Panel {
    public static final int POLY = 0;
    public static final int NAT_SPL = 1;
    public static final int NAK_SPL = 2;
    private int mode = 0;
    public static final int ADD = 0;
    public static final int MOVE = 1;
    public static final int DELETE = 2;
    private int action = 0;
    private Vector points = new Vector(16, 4);
    private int moving_point;
    private int precision = 10;

    public InterpPanel() {
        this.setBackground(Color.white);
    }

    public void setAction(int action) {
        switch (action) {
            case 0: 
            case 1: 
            case 2: {
                this.action = action;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setCurveType(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void clearPoints() {
        this.points.removeAllElements();
    }

    private int findPoint(int a2, int b2) {
        int max = this.points.size();
        for (int i2 = 0; i2 < max; ++i2) {
            ControlPoint pnt = (ControlPoint)this.points.elementAt(i2);
            if (!pnt.within(a2, b2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean handleEvent(Event e2) {
        switch (e2.id) {
            case 501: {
                switch (this.action) {
                    case 0: {
                        int i2;
                        int np = this.points.size();
                        for (i2 = 0; i2 <= np - 1 && ((ControlPoint)this.points.elementAt((int)i2)).x < e2.x; ++i2) {
                        }
                        ControlPoint pnt = new ControlPoint(e2.x, e2.y);
                        if (i2 <= np - 1) {
                            this.points.insertElementAt(pnt, i2);
                        } else {
                            this.points.addElement(pnt);
                        }
                        this.repaint();
                        break;
                    }
                    case 1: {
                        this.moving_point = this.findPoint(e2.x, e2.y);
                        break;
                    }
                    case 2: {
                        int delete_pt = this.findPoint(e2.x, e2.y);
                        if (delete_pt < 0) break;
                        this.points.removeElementAt(delete_pt);
                        this.repaint();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return true;
            }
            case 502: {
                if (this.moving_point >= 0) {
                    this.moving_point = -1;
                    this.repaint();
                }
                return true;
            }
            case 506: {
                if (this.moving_point >= 0) {
                    int np = this.points.size();
                    if (!(this.moving_point != np - 1 && e2.x > ((ControlPoint)this.points.elementAt((int)(this.moving_point + 1))).x || this.moving_point != 0 && e2.x < ((ControlPoint)this.points.elementAt((int)(this.moving_point - 1))).x)) {
                        ControlPoint pnt = (ControlPoint)this.points.elementAt(this.moving_point);
                        pnt.x = e2.x;
                        pnt.y = e2.y;
                    } else {
                        int i3;
                        this.points.removeElementAt(this.moving_point);
                        for (i3 = 0; i3 <= np - 2 && ((ControlPoint)this.points.elementAt((int)i3)).x < e2.x; ++i3) {
                        }
                        ControlPoint pnt2 = new ControlPoint(e2.x, e2.y);
                        if (i3 <= np - 1) {
                            this.points.insertElementAt(pnt2, i3);
                        } else {
                            this.points.addElement(pnt2);
                        }
                        this.moving_point = i3;
                    }
                    this.repaint();
                }
                return true;
            }
            case 201: {
                System.exit(0);
                return true;
            }
        }
        return false;
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b2, int n2) {
        int i2;
        for (i2 = 2; i2 <= n2; ++i2) {
            sub[i2] = sub[i2] / diag[i2 - 1];
            diag[i2] = diag[i2] - sub[i2] * sup[i2 - 1];
            b2[i2] = b2[i2] - sub[i2] * b2[i2 - 1];
        }
        b2[n2] = b2[n2] / diag[n2];
        for (i2 = n2 - 1; i2 >= 1; --i2) {
            b2[i2] = (b2[i2] - sup[i2] * b2[i2 + 1]) / diag[i2];
        }
    }

    @Override
    public void paint(Graphics g2) {
        int np = this.points.size();
        float[] d2 = new float[np];
        float[] x = new float[np];
        float oldy = 0.0f;
        float oldt = 0.0f;
        int npp = np * this.precision;
        g2.setColor(this.getForeground());
        g2.setPaintMode();
        g2.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        if (np > 0) {
            for (int i2 = 0; i2 < np; ++i2) {
                ControlPoint p = (ControlPoint)this.points.elementAt(i2);
                x[i2] = p.x;
                d2[i2] = p.y;
                g2.drawRect(p.x - 4, p.y - 4, 4 * 2, 4 * 2);
            }
            switch (this.mode) {
                case 0: {
                    for (int k2 = 1; k2 <= np - 1; ++k2) {
                        for (int i3 = 0; i3 <= np - 1 - k2; ++i3) {
                            d2[i3] = (d2[i3 + 1] - d2[i3]) / (x[i3 + k2] - x[i3]);
                        }
                    }
                    float dt = ((float)this.size().width - 1.0f) / (float)npp;
                    for (int k3 = 0; k3 <= npp; ++k3) {
                        float t = (float)k3 * dt;
                        float y = d2[0];
                        for (int i4 = 1; i4 <= np - 1; ++i4) {
                            y = y * (t - x[i4]) + d2[i4];
                        }
                        g2.drawLine((int)oldt, (int)oldy, (int)t, (int)y);
                        oldt = t;
                        oldy = y;
                    }
                    break;
                }
                case 1: {
                    int i5;
                    if (np <= 1) break;
                    float[] a2 = new float[np];
                    float[] h2 = new float[np];
                    for (i5 = 1; i5 <= np - 1; ++i5) {
                        h2[i5] = x[i5] - x[i5 - 1];
                    }
                    if (np > 2) {
                        float[] sub = new float[np - 1];
                        float[] diag = new float[np - 1];
                        float[] sup = new float[np - 1];
                        for (int i6 = 1; i6 <= np - 2; ++i6) {
                            diag[i6] = (h2[i6] + h2[i6 + 1]) / 3.0f;
                            sup[i6] = h2[i6 + 1] / 6.0f;
                            sub[i6] = h2[i6] / 6.0f;
                            a2[i6] = (d2[i6 + 1] - d2[i6]) / h2[i6 + 1] - (d2[i6] - d2[i6 - 1]) / h2[i6];
                        }
                        this.solveTridiag(sub, diag, sup, a2, np - 2);
                    }
                    oldt = x[0];
                    oldy = d2[0];
                    g2.drawLine((int)oldt, (int)oldy, (int)oldt, (int)oldy);
                    for (i5 = 1; i5 <= np - 1; ++i5) {
                        for (int j2 = 1; j2 <= this.precision; ++j2) {
                            float t1 = h2[i5] * (float)j2 / (float)this.precision;
                            float t2 = h2[i5] - t1;
                            float y = ((-a2[i5 - 1] / 6.0f * (t2 + h2[i5]) * t1 + d2[i5 - 1]) * t2 + (-a2[i5] / 6.0f * (t1 + h2[i5]) * t2 + d2[i5]) * t1) / h2[i5];
                            float t = x[i5 - 1] + t1;
                            g2.drawLine((int)oldt, (int)oldy, (int)t, (int)y);
                            oldt = t;
                            oldy = y;
                        }
                    }
                    break;
                }
            }
        }
    }
}

