/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.algo;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import org.jcodec.algo.InterpPanel;

class CurveControls
extends Panel {
    InterpPanel target;
    Checkbox cb_add;
    Checkbox cb_move;
    Checkbox cb_delete;
    String st_add_label = "Add Points";
    String st_move_label = "Move Points";
    String st_delete_label = "Delete Points";

    public CurveControls(InterpPanel target) {
        this.target = target;
        this.setLayout(new FlowLayout(1));
        this.setBackground(Color.lightGray);
        Button clear = new Button("Clear");
        this.add("West", clear);
        CheckboxGroup action_group = new CheckboxGroup();
        this.cb_add = new Checkbox(this.st_add_label, action_group, true);
        this.add(this.cb_add);
        this.cb_move = new Checkbox(this.st_move_label, action_group, false);
        this.add(this.cb_move);
        this.cb_delete = new Checkbox(this.st_delete_label, action_group, false);
        this.add(this.cb_delete);
    }

    @Override
    public void paint(Graphics g2) {
        Rectangle r = this.bounds();
        g2.setColor(Color.lightGray);
        g2.draw3DRect(0, 0, r.width, r.height, false);
    }

    @Override
    public boolean action(Event e2, Object arg) {
        String button;
        if (e2.target instanceof Checkbox) {
            String cbox = ((Checkbox)e2.target).getLabel();
            if (cbox.equals(this.st_add_label)) {
                this.target.setAction(0);
            } else if (cbox.equals(this.st_move_label)) {
                this.target.setAction(1);
            } else if (cbox.equals(this.st_delete_label)) {
                this.target.setAction(2);
            }
        } else if (e2.target instanceof Button && (button = ((Button)e2.target).getLabel()).equals("Clear")) {
            this.target.clearPoints();
            this.cb_add.setState(true);
            this.cb_delete.setState(false);
            this.cb_move.setState(false);
            this.target.setAction(0);
            this.target.repaint();
        }
        return true;
    }
}

