/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class CSVWriter {
    private String newline = System.getProperty("line.separator");
    private OutputStreamWriter writer = null;
    private int nbrRows = 0;

    public CSVWriter(File file, String string) throws IOException {
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writer = new OutputStreamWriter((OutputStream)fileOutputStream, string);
    }

    public void writeHeader(String[] stringArray) throws IOException {
        int n2 = stringArray.length;
        this.doWriteData(stringArray);
    }

    public void writeData(String[] stringArray) throws IOException {
        this.doWriteData(stringArray);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void doWriteData(String[] stringArray) throws IOException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                this.writer.write(";");
            }
            if (stringArray[i2] == null) continue;
            this.writer.write("\"");
            this.writer.write(this.toCsvValue(stringArray[i2]));
            this.writer.write("\"");
        }
        this.writer.write(this.newline);
        ++this.nbrRows;
    }

    private String toCsvValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            stringBuilder.append(c2);
            switch (c2) {
                case '\"': {
                    stringBuilder.append('\"');
                }
            }
        }
        return stringBuilder.toString();
    }
}

