/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class UserTypeModifier {
    final HsqlNameManager.HsqlName name;
    final int schemaObjectType;
    final Type dataType;
    Constraint[] constraints = Constraint.emptyArray;
    Expression defaultExpression;
    boolean isNullable = true;

    public UserTypeModifier(HsqlNameManager.HsqlName hsqlName, int n2, Type type) {
        this.name = hsqlName;
        this.schemaObjectType = n2;
        this.dataType = type;
    }

    public int schemaObjectType() {
        return this.schemaObjectType;
    }

    public void addConstraint(Constraint constraint) {
        int n2 = this.constraints.length;
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, n2 + 1);
        this.constraints[n2] = constraint;
        this.setNotNull();
    }

    public void removeConstraint(String string) {
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            if (!this.constraints[i2].getName().name.equals(string)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i2, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String string) {
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            if (!this.constraints[i2].getName().name.equals(string)) continue;
            return this.constraints[i2];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression expression) {
        this.defaultExpression = expression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            if (!this.constraints[i2].isNotNull()) continue;
            this.isNullable = false;
            break;
        }
    }

    public int getType() {
        return this.schemaObjectType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            OrderedHashSet orderedHashSet2 = this.constraints[i2].getReferences();
            if (orderedHashSet2 == null) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        Collation collation = this.dataType.getCollation();
        if (collation != null && collation.isObjectCollation()) {
            orderedHashSet.add(collation.getName());
        }
        return orderedHashSet;
    }

    public final OrderedHashSet getComponents() {
        if (this.constraints == null) {
            return null;
        }
        OrderedHashSet<Constraint> orderedHashSet = new OrderedHashSet<Constraint>();
        orderedHashSet.addAll(this.constraints);
        return orderedHashSet;
    }

    public void compile(Session session) {
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            this.constraints[i2].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.schemaObjectType == 12) {
            Collation collation;
            stringBuilder.append("CREATE").append(' ').append("TYPE").append(' ');
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
            stringBuilder.append(' ').append("AS").append(' ');
            stringBuilder.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                stringBuilder.append(' ').append(collation.getCollateSQL());
            }
        } else {
            Collation collation;
            stringBuilder.append("CREATE").append(' ').append("DOMAIN").append(' ');
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
            stringBuilder.append(' ').append("AS").append(' ');
            stringBuilder.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                stringBuilder.append(' ').append(collation.getCollateSQL());
            }
            if (this.defaultExpression != null) {
                stringBuilder.append(' ').append("DEFAULT").append(' ');
                stringBuilder.append(this.defaultExpression.getSQL());
            }
            for (int i2 = 0; i2 < this.constraints.length; ++i2) {
                stringBuilder.append(' ').append("CONSTRAINT").append(' ');
                stringBuilder.append(this.constraints[i2].getName().statementName).append(' ');
                stringBuilder.append("CHECK").append('(').append(this.constraints[i2].getCheckSQL()).append(')');
            }
        }
        return stringBuilder.toString();
    }
}

