/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

public class TimestampData {
    final long seconds;
    final int nanos;
    final int zone;

    public TimestampData(long l2) {
        this.seconds = l2;
        this.nanos = 0;
        this.zone = 0;
    }

    public TimestampData(long l2, int n2) {
        this.seconds = l2;
        this.nanos = n2;
        this.zone = 0;
    }

    public TimestampData(long l2, int n2, int n3) {
        this.seconds = l2;
        this.nanos = n2;
        this.zone = n3;
    }

    public static TimestampData fromMillisecondsGMT(long l2) {
        long l3 = l2 / 1000L;
        int n2 = (int)(l2 % 1000L) * 1000000;
        return new TimestampData(l3, n2);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public long getMillis() {
        return this.seconds * 1000L;
    }

    public boolean equals(Object object) {
        if (object instanceof TimestampData) {
            return this.seconds == ((TimestampData)object).seconds && this.nanos == ((TimestampData)object).nanos && this.zone == ((TimestampData)object).zone;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.seconds ^ this.nanos;
    }

    public int compareTo(TimestampData timestampData) {
        long l2 = this.seconds - timestampData.seconds;
        if (l2 == 0L && (l2 = (long)(this.nanos - timestampData.nanos)) == 0L) {
            return 0;
        }
        return l2 > 0L ? 1 : -1;
    }
}

