/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public final class NumberType
extends Type {
    static final int tinyintPrecision = 3;
    static final int smallintPrecision = 5;
    static final int integerPrecision = 10;
    public static final int bigintPrecision = 19;
    static final int doublePrecision = 0;
    public static final int defaultNumericPrecision = 128;
    public static final int defaultNumericScale = 32;
    public static final int maxNumericPrecision = Integer.MAX_VALUE;
    static final int bigintSquareNumericPrecision = 40;
    public static final int TINYINT_WIDTH = 8;
    public static final int SMALLINT_WIDTH = 16;
    public static final int INTEGER_WIDTH = 32;
    public static final int BIGINT_WIDTH = 64;
    public static final int DOUBLE_WIDTH = 128;
    public static final int DECIMAL_WIDTH = 256;
    public static final Type SQL_NUMERIC_DEFAULT_INT = new NumberType(2, 128L, 0);
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MIN_LONG_BI = MIN_LONG.toBigInteger();
    public static final BigInteger MAX_LONG_BI = MAX_LONG.toBigInteger();
    final int typeWidth;

    public NumberType(int n2, long l2, int n3) {
        super(2, n2, l2, n3);
        switch (n2) {
            case -6: {
                this.typeWidth = 8;
                break;
            }
            case 5: {
                this.typeWidth = 16;
                break;
            }
            case 4: {
                this.typeWidth = 32;
                break;
            }
            case 25: {
                this.typeWidth = 64;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.typeWidth = 128;
                break;
            }
            case 2: 
            case 3: {
                this.typeWidth = 256;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
    }

    public int getPrecision() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return this.typeWidth;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int getDecimalPrecision() {
        switch (this.typeCode) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 25: {
                return 19;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.displaySize() - 1;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                if (this.scale == 0) {
                    if (this.precision == 0L) {
                        return 646456995;
                    }
                    return (int)this.precision + 1;
                }
                if (this.precision == (long)this.scale) {
                    return (int)this.precision + 3;
                }
                return (int)this.precision + 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 25: {
                return 20;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 25 ? -5 : this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 25: {
                return Long.class;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 25: {
                return "java.lang.Long";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.getPrecision();
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 25: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return this.getNameString();
    }

    @Override
    public String getDefinition() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                StringBuilder stringBuilder = new StringBuilder(16);
                stringBuilder.append(this.getNameString());
                stringBuilder.append('(');
                stringBuilder.append(this.precision);
                if (this.scale != 0) {
                    stringBuilder.append(',');
                    stringBuilder.append(this.scale);
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
        }
        return this.getNameString();
    }

    @Override
    public long getMaxPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        return this.getNumericPrecisionInRadix();
    }

    @Override
    public int getMaxScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Short.MAX_VALUE;
            }
        }
        return 0;
    }

    @Override
    public boolean acceptsPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecisionRadix() {
        if (this.typeCode == 3 || this.typeCode == 2) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 2: 
            case 3: {
                return this.scale == 0;
            }
        }
        return true;
    }

    @Override
    public boolean isExactNumberType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDecimalType() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int getNominalWidth() {
        return this.typeWidth;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.isNumberType()) {
            int n2 = ((NumberType)type).typeWidth;
            return n2 - this.typeWidth;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this == type) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        switch (type.typeCode) {
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (this.typeWidth == 128) {
            return this;
        }
        if (((NumberType)type).typeWidth == 128) {
            return type;
        }
        if (this.typeWidth <= 64 && ((NumberType)type).typeWidth <= 64) {
            return this.typeWidth > ((NumberType)type).typeWidth ? this : type;
        }
        int n2 = this.scale > type.scale ? this.scale : type.scale;
        long l2 = this.precision - (long)this.scale > type.precision - (long)type.scale ? this.precision - (long)this.scale : type.precision - (long)type.scale;
        return NumberType.getNumberType(3, l2 + (long)n2, n2);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        long l2;
        int n3;
        if (type.typeCode == 0) {
            type = this;
        }
        switch (n2) {
            case 32: 
            case 35: {
                break;
            }
            case 34: {
                if (!type.isIntervalType()) break;
                return type.getCombinedType(session, this, 34);
            }
            default: {
                return this.getAggregateType(type);
            }
        }
        if (!type.isNumberType()) {
            throw Error.error(5562);
        }
        if (this.typeWidth == 128 || ((NumberType)type).typeWidth == 128) {
            return Type.SQL_DOUBLE;
        }
        if (n2 != 35 || session.database.sqlAvgScale == 0) {
            n3 = n2 == 35 ? this.typeWidth : this.typeWidth + ((NumberType)type).typeWidth;
            if (n3 <= 32) {
                return Type.SQL_INTEGER;
            }
            if (n3 <= 64) {
                return Type.SQL_BIGINT;
            }
        }
        switch (n2) {
            case 32: {
                n3 = this.scale > type.scale ? this.scale : type.scale;
                l2 = this.getDecimalPrecision() - this.scale > ((NumberType)type).getDecimalPrecision() - type.scale ? (long)(this.getDecimalPrecision() - this.scale) : (long)(((NumberType)type).getDecimalPrecision() - type.scale);
                ++l2;
                break;
            }
            case 35: {
                l2 = this.getDecimalPrecision() - this.scale + type.scale;
                int n4 = n3 = this.scale > type.scale ? this.scale : type.scale;
                if (session.database.sqlAvgScale <= n3) break;
                n3 = session.database.sqlAvgScale;
                break;
            }
            case 34: {
                l2 = this.getDecimalPrecision() - this.scale + ((NumberType)type).getDecimalPrecision() - type.scale;
                n3 = this.scale + type.scale;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberType");
            }
        }
        return NumberType.getNumberType(3, (long)n3 + l2, n3);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                if (object2 instanceof Integer) {
                    int n2;
                    int n3 = ((Number)object).intValue();
                    return n3 > (n2 = ((Number)object2).intValue()) ? 1 : (n2 > n3 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    double d2;
                    double d3 = ((Number)object).doubleValue();
                    return d3 > (d2 = ((Number)object2).doubleValue()) ? 1 : (d2 > d3 ? -1 : 0);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                    return bigDecimal.compareTo((BigDecimal)object2);
                }
            }
            case 25: {
                if (object2 instanceof Long) {
                    long l2;
                    long l3 = ((Number)object).longValue();
                    return l3 > (l2 = ((Number)object2).longValue()) ? 1 : (l2 > l3 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
                    BigDecimal bigDecimal2 = BigDecimal.valueOf((Double)object2);
                    return bigDecimal.compareTo(bigDecimal2);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                    return bigDecimal.compareTo((BigDecimal)object2);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                double d4 = ((Number)object).doubleValue();
                double d5 = ((Number)object2).doubleValue();
                return NumberType.compareDouble(d4, d5);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = NumberType.convertToDecimal(object2);
                return ((BigDecimal)object).compareTo(bigDecimal);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object;
            }
            case 6: 
            case 7: 
            case 8: {
                return object;
            }
            case 2: 
            case 3: {
                int n2;
                BigDecimal bigDecimal = (BigDecimal)object;
                if (this.scale != bigDecimal.scale()) {
                    bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.HALF_DOWN);
                }
                if ((long)(n2 = JavaSystem.precision(bigDecimal)) > this.precision) {
                    throw Error.error(3403);
                }
                return bigDecimal;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.typeCode == this.typeCode) {
            switch (this.typeCode) {
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (this.scale != bigDecimal.scale()) {
                        bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.HALF_DOWN);
                    }
                    if ((long)JavaSystem.precision(bigDecimal) > this.precision) {
                        throw Error.error(3403);
                    }
                    return bigDecimal;
                }
            }
            return object;
        }
        if (type.isIntervalType()) {
            int n2 = ((IntervalType)type).startIntervalType;
            switch (n2) {
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    double d2 = ((IntervalType)type).convertToDoubleStartUnits(object);
                    return this.convertToType(sessionInterface, d2, Type.SQL_DOUBLE);
                }
            }
        }
        switch (type.typeCode) {
            case 40: {
                object = ((ClobData)object).getSubString(sessionInterface, 0L, (int)((ClobData)object).length(sessionInterface));
            }
            case 1: 
            case 12: {
                object = sessionInterface.getScanner().convertToNumber((String)object, this);
                object = this.convertToDefaultType(sessionInterface, object);
                return this.convertToTypeLimits(sessionInterface, object);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            case 14: 
            case 15: {
                if (type.precision == 1L) {
                    if (((BinaryData)object).getBytes()[0] == 0) {
                        object = ValuePool.INTEGER_0;
                        break;
                    }
                    object = ValuePool.INTEGER_1;
                    break;
                }
                throw Error.error(5561);
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return NumberType.convertToInt(sessionInterface, object, this.typeCode);
            }
            case 25: {
                return NumberType.convertToLong(sessionInterface, object);
            }
            case 6: 
            case 7: 
            case 8: {
                return NumberType.convertToDouble(object);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = null;
                if (this.scale == 0 && object instanceof Double) {
                    double d3 = ((Number)object).doubleValue();
                    if (sessionInterface instanceof Session && !((Session)sessionInterface).database.sqlConvertTruncate) {
                        d3 = Math.rint(d3);
                    }
                    if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                        throw Error.error(3403);
                    }
                    bigDecimal = BigDecimal.valueOf(d3);
                }
                if (bigDecimal == null) {
                    bigDecimal = NumberType.convertToDecimal(object);
                }
                return this.convertToTypeLimits(sessionInterface, bigDecimal);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.isLobType()) {
            throw Error.error(5561);
        }
        switch (type.typeCode) {
            case 16: {
                object = (Boolean)object != false ? ValuePool.INTEGER_1 : ValuePool.INTEGER_0;
                type = Type.SQL_INTEGER;
            }
        }
        return this.convertToType(sessionInterface, object, type);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof Number) {
            if (object instanceof BigInteger) {
                object = new BigDecimal((BigInteger)object);
            } else if (object instanceof Float) {
                object = ((Float)object).doubleValue();
            } else if (object instanceof Byte) {
                object = ValuePool.getInt(((Byte)object).intValue());
            } else if (object instanceof Short) {
                object = ValuePool.getInt(((Short)object).intValue());
            }
            if (object instanceof Integer) {
                NumberType numberType = Type.SQL_INTEGER;
            } else if (object instanceof Long) {
                NumberType numberType = Type.SQL_BIGINT;
            } else if (object instanceof Double) {
                NumberType numberType = Type.SQL_DOUBLE;
            } else if (object instanceof BigDecimal) {
                NumberType numberType = Type.SQL_DECIMAL_DEFAULT;
            } else {
                throw Error.error(5561);
            }
            switch (this.typeCode) {
                case -6: 
                case 4: 
                case 5: {
                    return NumberType.convertToInt(sessionInterface, object, 4);
                }
                case 25: {
                    return NumberType.convertToLong(sessionInterface, object);
                }
                case 6: 
                case 7: 
                case 8: {
                    return NumberType.convertToDouble(object);
                }
                case 2: 
                case 3: {
                    object = NumberType.convertToDecimal(object);
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (this.scale != bigDecimal.scale()) {
                        bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.HALF_DOWN);
                    }
                    return bigDecimal;
                }
            }
            throw Error.error(5561);
        }
        if (!(object instanceof String)) {
            throw Error.error(5561);
        }
        CharacterType characterType = Type.SQL_VARCHAR;
        return this.convertToType(sessionInterface, object, characterType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return this.convertToDefaultType(sessionInterface, object);
    }

    static Integer convertToInt(SessionInterface sessionInterface, Object object, int n2) {
        int n3;
        if (object instanceof Integer) {
            if (n2 == 4) {
                return (Integer)object;
            }
            n3 = (Integer)object;
        } else if (object instanceof Long) {
            long l2 = (Long)object;
            if (Integer.MAX_VALUE < l2 || l2 < Integer.MIN_VALUE) {
                throw Error.error(3403);
            }
            n3 = (int)l2;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_INT) > 0 || bigDecimal.compareTo(MIN_INT) < 0) {
                throw Error.error(3403);
            }
            n3 = bigDecimal.intValue();
        } else if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (sessionInterface instanceof Session && !((Session)sessionInterface).database.sqlConvertTruncate) {
                d2 = Math.rint(d2);
            }
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 >= 2.147483648E9 || d2 <= -2.147483649E9) {
                throw Error.error(3403);
            }
            n3 = (int)d2;
        } else {
            throw Error.error(5561);
        }
        if (n2 == -6 ? 127 < n3 || n3 < -128 : n2 == 5 && (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE)) {
            throw Error.error(3403);
        }
        return n3;
    }

    static Long convertToLong(SessionInterface sessionInterface, Object object) {
        if (object instanceof Integer) {
            return ValuePool.getLong(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_LONG) > 0 || bigDecimal.compareTo(MIN_LONG) < 0) {
                throw Error.error(3403);
            }
            return ValuePool.getLong(bigDecimal.longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (sessionInterface instanceof Session && !((Session)sessionInterface).database.sqlConvertTruncate) {
                d2 = Math.rint(d2);
            }
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 >= 9.223372036854776E18 || d2 <= -9.223372036854776E18) {
                throw Error.error(3403);
            }
            return ValuePool.getLong((long)d2);
        }
        throw Error.error(5561);
    }

    private static Double convertToDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        double d2 = NumberType.toDouble(object);
        return ValuePool.getDouble(Double.doubleToLongBits(d2));
    }

    public static double toDouble(Object object) {
        if (!(object instanceof Number)) {
            throw Error.error(3471);
        }
        double d2 = ((Number)object).doubleValue();
        return d2;
    }

    private static BigDecimal convertToDecimal(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Integer || object instanceof Long) {
            return BigDecimal.valueOf(((Number)object).longValue());
        }
        if (object instanceof Double) {
            double d2 = ((Number)object).doubleValue();
            if (Double.isInfinite(d2) || Double.isNaN(d2)) {
                throw Error.error(3403);
            }
            return BigDecimal.valueOf(d2);
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object.toString();
            }
            case 7: 
            case 8: {
                double d2 = (Double)object;
                if (d2 == Double.NEGATIVE_INFINITY) {
                    return "-1E0/0";
                }
                if (d2 == Double.POSITIVE_INFINITY) {
                    return "1E0/0";
                }
                if (Double.isNaN(d2)) {
                    return "0E0/0E0";
                }
                String string = Double.toString(d2);
                if (string.indexOf(69) < 0) {
                    string = string.concat("E0");
                }
                return string;
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).toPlainString();
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return this.convertToString(object);
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isNumberType()) {
            return true;
        }
        if (type.isIntervalType()) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        return type.isBitType() && type.precision == 1L;
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        switch (this.typeCode) {
            case -6: {
                if (type.typeCode != 5) break;
                return 1;
            }
            case 5: {
                if (type.typeCode != this.typeCode && type.typeCode != -6) break;
                return 0;
            }
            case 4: 
            case 25: {
                if (type.typeCode != this.typeCode) break;
                return 0;
            }
            case 2: 
            case 3: {
                if (type.typeCode != 3 && type.typeCode != 2 || this.scale != type.scale) break;
                if (this.precision >= type.precision) {
                    return 0;
                }
                return 1;
            }
            case 6: 
            case 7: 
            case 8: {
                if (type.typeCode != 7 && type.typeCode != 6 && type.typeCode != 8) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int compareToTypeRange(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof BigDecimal) {
            int n2;
            int n3;
            long l2 = ((Number)object).longValue();
            switch (this.typeCode) {
                case -6: {
                    int n4 = NumberType.compareBigDecimalToLongLimits(object);
                    if (n4 != 0) {
                        return n4;
                    }
                    n3 = -128;
                    n2 = 127;
                    break;
                }
                case 5: {
                    int n5 = NumberType.compareBigDecimalToLongLimits(object);
                    if (n5 != 0) {
                        return n5;
                    }
                    n3 = Short.MIN_VALUE;
                    n2 = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    int n6 = NumberType.compareBigDecimalToLongLimits(object);
                    if (n6 != 0) {
                        return n6;
                    }
                    n3 = Integer.MIN_VALUE;
                    n2 = Integer.MAX_VALUE;
                    break;
                }
                case 25: {
                    int n7 = NumberType.compareBigDecimalToLongLimits(object);
                    return n7;
                }
                case 2: 
                case 3: {
                    if (this.precision - (long)this.scale >= 19L && object instanceof Long) {
                        return 0;
                    }
                    if (this.precision - (long)this.scale >= 10L && object instanceof Integer) {
                        return 0;
                    }
                    BigDecimal bigDecimal = NumberType.convertToDecimal(object);
                    int n8 = bigDecimal.scale();
                    int n9 = JavaSystem.precision(bigDecimal);
                    if (n8 < 0) {
                        n9 -= n8;
                        n8 = 0;
                    }
                    return this.precision - (long)this.scale >= (long)(n9 - n8) ? 0 : bigDecimal.signum();
                }
                default: {
                    return 0;
                }
            }
            if ((long)n2 < l2) {
                return 1;
            }
            if (l2 < (long)n3) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Object add(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 + d3));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.add(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 + n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 + l3);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object subtract(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 - d3));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 - n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 - l3);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object multiply(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 * d3));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 * n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 * l3);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    @Override
    public Object divide(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                if (d3 == 0.0 && (session == null || session.database.sqlDoubleNaN)) {
                    throw Error.error(3432);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d2 / d3));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                if (bigDecimal2.signum() == 0) {
                    throw Error.error(3432);
                }
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, this.scale, RoundingMode.DOWN);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                if (n3 == 0) {
                    throw Error.error(3432);
                }
                return ValuePool.getInt(n2 / n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                if (l3 == 0L) {
                    throw Error.error(3432);
                }
                return ValuePool.getLong(l2 / l3);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Object modulo(Session session, Object object, Object object2, Type type) {
        if (!type.isNumberType()) {
            throw Error.error(5561);
        }
        object = this.truncate(object, this.scale);
        object2 = ((NumberType)type).truncate(object2, type.scale);
        Object object3 = this.divide(null, object, object2);
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                object3 = this.truncate(object3, 0);
            }
        }
        object3 = this.multiply(object3, object2);
        object3 = this.subtract(session, object, object3, this);
        return type.convertToType(null, object3, this);
    }

    @Override
    public Object absolute(Object object) {
        return this.isNegative(object) ? this.negate(object) : object;
    }

    @Override
    public Object negate(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = -((Number)object).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: {
                int n2 = ((Number)object).intValue();
                if (n2 == -128) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n2);
            }
            case 5: {
                int n3 = ((Number)object).intValue();
                if (n3 == Short.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n3);
            }
            case 4: {
                int n4 = ((Number)object).intValue();
                if (n4 == Integer.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getInt(-n4);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                if (l2 == Long.MIN_VALUE) {
                    throw Error.error(3403);
                }
                return ValuePool.getLong(-l2);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public int getNumericPrecisionInRadix() {
        switch (this.typeCode) {
            case -6: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 25: {
                return 64;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public Type getIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return SQL_NUMERIC_DEFAULT_INT;
            }
            case 2: 
            case 3: {
                return this.scale == 0 ? this : new NumberType(this.typeCode, this.precision, 0);
            }
        }
        return this;
    }

    public static boolean isZero(Object object) {
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).signum() == 0;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0 || ((Double)object).isNaN();
        }
        return ((Number)object).longValue() == 0L;
    }

    @Override
    public boolean isNegative(Object object) {
        return this.compareToZero(object) < 0;
    }

    public int compareToZero(Object object) {
        if (object == null) {
            return 0;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                return d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).signum();
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                return n2 == 0 ? 0 : (n2 < 0 ? -1 : 1);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }

    public static long scaledDecimal(Object object, int n2) {
        if (object == null) {
            return 0L;
        }
        if (n2 == 0) {
            return 0L;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (bigDecimal.scale() == 0) {
            return 0L;
        }
        bigDecimal = bigDecimal.setScale(0, RoundingMode.FLOOR);
        bigDecimal = ((BigDecimal)object).subtract(bigDecimal);
        return bigDecimal.movePointRight(n2).longValue();
    }

    public static int compareBigDecimalToLongLimits(Object object) {
        if (object instanceof BigDecimal) {
            int n2 = NumberType.compareToLongLimits((BigDecimal)object);
            return n2;
        }
        return 0;
    }

    public static int compareToLongLimits(BigDecimal bigDecimal) {
        if (MIN_LONG.compareTo(bigDecimal) > 0) {
            return -1;
        }
        if (MAX_LONG.compareTo(bigDecimal) < 0) {
            return 1;
        }
        return 0;
    }

    public static int compareToLongLimits(BigInteger bigInteger) {
        if (MIN_LONG_BI.compareTo(bigInteger) > 0) {
            return -1;
        }
        if (MAX_LONG_BI.compareTo(bigInteger) < 0) {
            return 1;
        }
        return 0;
    }

    public Object ceiling(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = Math.ceil((Double)object);
                if (Double.isInfinite(d2)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, RoundingMode.CEILING);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object floor(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = Math.floor((Double)object);
                if (Double.isInfinite(d2)) {
                    throw Error.error(3403);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, RoundingMode.FLOOR);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object truncate(Object object, int n2) {
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal = NumberType.convertToDecimal(object);
        bigDecimal = bigDecimal.setScale(n2, RoundingMode.DOWN);
        if (this.typeCode == 3 || this.typeCode == 2) {
            bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.DOWN);
        }
        object = this.convertToDefaultType(null, bigDecimal);
        return this.convertToTypeLimits(null, object);
    }

    public Object round(Object object, int n2) {
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal = NumberType.convertToDecimal(object);
        switch (this.typeCode) {
            case 8: {
                bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_EVEN);
                break;
            }
            default: {
                bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
                bigDecimal = bigDecimal.setScale(this.scale, RoundingMode.DOWN);
            }
        }
        object = this.convertToDefaultType(null, bigDecimal);
        return this.convertToTypeLimits(null, object);
    }

    public static int compareDouble(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return Double.isNaN(d3) ? 0 : -1;
        }
        if (Double.isNaN(d3)) {
            return 1;
        }
        return Double.compare(d2, d3);
    }

    public static NumberType getNumberType(int n2, long l2, int n3) {
        switch (n2) {
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                return new NumberType(n2, l2, n3);
            }
        }
        throw Error.runtimeError(201, "NumberType");
    }
}

